program Demo2;

uses
  	MCGA256, Crt, Dos, Memory;

var
    SpriteArray:   array [1..14] of SpritePointer;
    SpritesActive: array [1..14] of boolean;
	StandardPal: PaletteArray;
    i, hr, min, sec, hund: word;
    NoFrames, StartSec, EndSec: longint;



procedure ErrorReadingFile;
begin
	CloseGraphics;
    WriteLn('Program terminated: Error reading file.');
    Halt(2);
end; {ErrorReadingFile}



procedure LoadSpriteData;
var i: word;
begin
    if (not LoadSprite('BALL1.PCX',  SpriteArray[1]))  then ErrorReadingFile;
    if (not LoadSprite('BALL2.PCX',  SpriteArray[2]))  then ErrorReadingFile;
    if (not LoadSprite('BALL3.PCX',  SpriteArray[3]))  then ErrorReadingFile;
    if (not LoadSprite('BALL4.PCX',  SpriteArray[4]))  then ErrorReadingFile;
    if (not LoadSprite('BALL5.PCX',  SpriteArray[5]))  then ErrorReadingFile;
    if (not LoadSprite('BALL6.PCX',  SpriteArray[6]))  then ErrorReadingFile;
    if (not LoadSprite('BALL7.PCX',  SpriteArray[7]))  then ErrorReadingFile;
    if (not LoadSprite('BALL8.PCX',  SpriteArray[8]))  then ErrorReadingFile;
    if (not LoadSprite('BALL9.PCX',  SpriteArray[9]))  then ErrorReadingFile;
    if (not LoadSprite('BALL10.PCX', SpriteArray[10])) then ErrorReadingFile;
    if (not LoadSprite('BALL11.PCX', SpriteArray[11])) then ErrorReadingFile;
    if (not LoadSprite('BALL12.PCX', SpriteArray[12])) then ErrorReadingFile;
    if (not LoadSprite('BALL13.PCX', SpriteArray[13])) then ErrorReadingFile;
    if (not LoadSprite('BALL14.PCX', SpriteArray[14])) then ErrorReadingFile;

    for i := 1 to 14 do SpritesActive[i] := false;
end; {LoadSpriteData}



procedure AnimateBalls;
var
	Xpositions, Ypositions, Yfactor, ActiveList: array[1..5] of integer;
    i: word;
    Ch: char;
begin
	Xpositions[1] := 70; 	Ypositions[1] := 65;
    Xpositions[2] := 106;	Ypositions[2] := 75;
    Xpositions[3] := 142;	Ypositions[3] := 85;
	Xpositions[4] := 178;	Ypositions[4] := 95;
    Xpositions[5] := 214;	Ypositions[5] := 105;

    Yfactor[1] := 2;		ActiveList[1] := 1;
    Yfactor[2] := 2;		ActiveList[2] := 3;
    Yfactor[3] := 2;		ActiveList[3] := 7;
    Yfactor[4] := 2;		ActiveList[4] := 10;
    Yfactor[5] := 2;		ActiveList[5] := 14;

    for i := 1 to 5 do
    begin
    	SpritesActive[ActiveList[i]] := true;
        SpriteArray[ActiveList[i]]^.x := Xpositions[i];
        SpriteArray[ActiveList[i]]^.y := Ypositions[i];
    end;

    repeat
    	for i := 1 to 5 do
		begin
			SaveSprite(SpriteArray[ActiveList[i]]);
            DrawSprite(SpriteArray[ActiveList[i]]);
        end;
        CopyVirtualScreen(50, 150);
        INC(NoFrames);
        for i := 1 to 5 do
			RestoreSprite(SpriteArray[ActiveList[i]]);

        for i := 1 to 5 do
		begin
        	SpritesActive[ActiveList[i]] := false;
        	if (ActiveList[i] = 14) then ActiveList[i] := 1
            else INC(ActiveList[i]);
            SpritesActive[ActiveList[i]] := true;
            if (Ypositions[i] = 65) then Yfactor[i] := 2;
            if (Ypositions[i] = 105) then Yfactor[i] := -2;
            Ypositions[i] := Ypositions[i] + Yfactor[i];
            SpriteArray[ActiveList[i]]^.x := Xpositions[i];
            SpriteArray[ActiveList[i]]^.y := Ypositions[i];
        end;
    until keypressed;
    Ch := ReadKey;
end; {AnimateBalls}




begin
  	if (not OpenGraphics) then
    begin
    	WriteLn('Error opening graphics library.');
        Halt(1);
    end;

    for i := 1 to 14 do
    begin
    	SpriteArray[i] := CreateSprite(32, 32);
        if (SpriteArray[i] = nil) then
        begin
        	CloseGraphics;
            WriteLn('Error not enough memory.');
            Halt(3);
        end;
    end;

    SetActivePage(VirtualScreen);
   	LoadSpriteData;
    FillRectangle(0, 0, 319, 199, 0);
    if (not LoadPalette('STANDARD.PAL', StandardPal)) then ErrorReadingFile;
    SetPalette(StandardPal);
    NoFrames := 0;
    GetTime(hr, min, sec, hund);
    StartSec := (hr * 3600) + (min * 60) + sec;
    AnimateBalls;
    GetTime(hr, min, sec, hund);
    EndSec := (hr * 3600) + (min * 60) + sec;
    for i := 1 to 14 do DestroySprite(SpriteArray[i]);
  	CloseGraphics;
    WriteLn('You managed approximately ', NoFrames div (EndSec - StartSec), ' frames per second.');
end. 