
program SHOW256;

(* Sample implementation of PCX.TPU for 320x200x256-color files. Enter
   a filename (without extension) on the command line or, if running under
   Turbo, in the Parameters box. *)

uses
  DOS,
  CRT,
  PCX;

var
  blackpal : array[0..255] of RGBrec;

  (* -------------------------- SHOW256 --------------------------------- *)

BEGIN
  pcxfilename := paramstr(1) + '.PCX';
  setmode($13);                        (* Initialize graphics *)
  fillchar(blackpal, 768, 0);          (* Set all colors to black *)
  setregisters(blackpal);
  read_pcx256(pcxfilename);            (* Put image into display memory *)
  if file_error then
    begin
      setmode(3);
      writeln('Can''t read that file.');
      halt
    end;
  setregisters(RGB256);                (* Show true colors *)
  repeat
   until (readkey <> #1);
  setmode(3)                           (* Restore text mode *)
END.

