
program SHOWEGA;

(* Sample implementation of PCX.TPU for EGA. You need to have the Turbo
   .BGI files in the current directory, or change the Initgraph path. Enter
   a filename (without extension) on the command line or, if running under
   Turbo, in the Parameters box. *)

uses
  GRAPH,
  CRT,
  PCX;

var
  grdriver,
  grmode : integer;

BEGIN
  pcxfilename := paramstr(1) + '.PCX';
  grdriver := ega;
  grmode := egahi;    (* 640x350x16 format *)
  initgraph(grdriver, grmode, '');
  setvisualpage(1);                    (* Hide the image *)
  read_pcx_file(grdriver, pcxfilename);
  if file_error then
    begin
      closegraph;
      write('File not found.');
      halt
    end;
  setallpalette(pal);
  setvisualpage(0);                    (* Show the image *)
  repeat
  until (readkey <> #1);
  closegraph
END.

