
program SHOWVGA;

(* Sample implementation of PCX.TPU for VGA 16-color files. You need to
   have the Turbo .BGI files in the current directory, or change the
   Initgraph path. Enter a filename (without extension) on the command line
   or, if running under Turbo, in the Parameters box. *)

uses
  GRAPH,
  DOS,
  CRT,
  PCX;

var
  slot,
  grdriver,
  grmode : integer;

  (* --------------------------------------------------------------------- *)

  procedure VIDEO_DISABLE(off : boolean);

(* Because an extra display page is not always available in VGA modes,
   we can't use SetVisualPage to hide the image while it is being written
   to the screen and the colors are being altered. Instead we can get BIOS
   to turn off the screen. This method has the added advantage of speeding
   up the writing of the image to display memory. Note that the function is
   not available on EGA cards. *)

  var
    regs : registers;

  begin
    regs.ah := $12;                    { BIOS function }
    regs.al := ord(off);               { 0 = on, 1 = off }
    regs.bl := $36;                    { Subfunction }
    intr($10, regs);                   { Call BIOS }
  end;

  (* --------------------------------------------------------------------- *)

BEGIN                                  { SHOWVGA }
  pcxfilename := paramstr(1) + '.PCX';
  grdriver := vga;
  grmode := vgahi;    { 640x480x16 format }
  initgraph(grdriver, grmode, '');
  VIDEO_DISABLE(true);
  read_pcx_file(grdriver, pcxfilename);
  if file_error then
    begin
      closegraph;
      writeln('File ', fexpand(pcxfilename), ' not found.');
      halt
    end;
  for slot := 0 to 15 do               { Alter the registers }
    with RGBpal[slot] do
      setRGBpalette(slot, redval, greenval, blueval);
  setallpalette(pal);                  { Point to registers 0-15 }
  VIDEO_DISABLE(false);                { Turn on video }
  repeat
  until (readkey <> #1);
  closegraph
END.

