/*
   Strip Chart Library Example for drawing step functions.

   Copyright (c) 1993 by Christopher Lim.  All rights reserved.
*/

#include "sc.h"
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>

/*------------------------------------------------------------*/

void GetPrinterType(unsigned char *printerType, unsigned char *printerRes,
   char **s)
{
   int c;
   unsigned char i,j;

   printf("Select printer type and resolution code: \n");
   printf("[1] 9 PIN LOW RES\n");
   printf("[2] 9 PIN HIGH RES\n");
   printf("[3] 24 PIN LOW RES\n");
   printf("[4] 24 PIN HIGH RES\n");
   printf("Select code [1,2,3 or 4]: ");
   c = getch();
   printf("%c\n",c);
   switch (c)
   {
        case '1': i = SC_9PIN; j = SC_LOW_RES;
             *s = "9 PIN LOW RES";
             break;
        case '2': i = SC_9PIN; j = SC_HIGH_RES;
             *s = "9 PIN HIGH RES";
             break;
        case '3': i = SC_24PIN; j = SC_LOW_RES;
             *s = "24 PIN LOW RES";
             break;
        case '4': i = SC_24PIN; j = SC_HIGH_RES;
             *s = "24 PIN HIGH RES";
             break;
        default:
             printf("Aborted\n");
             exit(1);
   }
   printf("%s\n",*s);
   *printerType = i;
   *printerRes = j;
   return;
}

/*------------------------------------------------------------*/

void ErrorTrap(char *msg)
{
    printf("%s\n",msg);
    exit(1);
}

/*------------------------------------------------------------*/

void main()
{
   int i;
   int error;
   double level;
   char *s;
   unsigned char printerType, printerRes;
   SC_WINDOW *w;


   if (!SC_PrinterReady(LPT1))
   {
      printf("Printer at LPT1 is not ready!\n");
      exit(1);
   }

   GetPrinterType(&printerType, &printerRes, &s);

   SC_SetErrorTrap(ErrorTrap);

   /* Initialize: use metric units, 20 cm paper width,
      plot speed of 2 cm/sec
   */
   SC_Init(LPT1, printerType, printerRes, CENTIMETERS, 20.0, 2.0, &error);

   /* Add a trace window:
      0.5 cm from top of page, 5.0 cm height,
      real world coordinates range from -1.0 to 1.0,
      draw a border around the trace
   */
   w = SC_AddTraceWindow(0.5, 5.0, -1.0, 1.0, SCF_BORDER, &error);

   /* draw steps */
   level = -1.0; /* first point */
   for (i=0; i <= 10; i++)
   {
      /* Draw a horizontal line at current level */
      SC_Trace(w,level,&error);
      SC_Draw();

      /* change level */
      level += 1.0;
      if (level > 1.0)
         level = -1.0; /* wrap */

      /* Draw vertical line to new level */
      SC_Trace(w,level,&error);
      SC_Draw();

      SC_Advance(1.0); /* advance paper 1.0 sec == 2 cm */
   }

   SC_Close(); /* terminate strip chart */
}
