/*.............................. TIF_DEMO.C ................. 12-23-92 .....*/
/* This program demonstrates the use of the TIFF reading and display        */
/* capabilities of the VSA256 Version 1.1b Graphics Library and the         */
/* TIFF256 Graphics Library Extensions Version 1.0                          */
/*                                                                          */
/* TO RUN:  - Enter VESA video mode                                         */
/*          - Hit any key to continue or ESC to exit program                */
/*          - Enter x,y image origin                                        */
/*          - Enter full TIFF file name including path and extension        */
/*          - Image is now drawn                                            */
/*          - Hit any key to repeat sequence or ESC to exit program         */
/*                                                                          */
/* NOTE: Sometimes your input is not visible, depending on the Color Look   */
/*       Up Table that is active due to last image ploted.  Keep typing,    */
/*       your input will be accepted anyway.                                */
/*..........................................................................*/

#include <io.h>             /* Required to support TIFF256 Graphics Library */
#include <stdio.h>          /* Required to support TIFF256 Graphics Library */
#include <fcntl.h>          /* Required to support TIFF256 Graphics Library */
#include<math.h>
#include<limits.h>

#include "tiff.h"           /* Required to support TIFF256 Graphics Library */
#include "vsa.h"            /* Required to support VSA256 Graphics Library  */

#ifndef _MSC_VER
/*.....                This is line for Borland C Only !               .....*/
extern unsigned _stklen = 10000;
#endif

void main()
{
	int a,b,r0,c0,bug,i;
	unsigned vmode,xx,yy,x0,y0,ya;
	char filename[100],key;
	ya = 4;
/*..........................................................................*/
/*               Initialize video mode and VSA256 environment.              */
/*               Valid modes are: 100h, 101h, 103h, and 105h.               */
/*..........................................................................*/
	bug = 0;
	printf("\n");
	printf("Input VESA standard Video Mode (hex)\n");
	printf("(100, 101, 103, or 105): ");
	scanf("%x",&vmode);
	if(vmode == 0x666)
		{
			printf("Welcome to the Trident Bug Patch for Video Mode 103\n");
			printf("Please enter Character Height in pixels (Try 16): ");
			scanf("%d",&bug);
			vmode = 0x103;
		}
	if((i = vsa_init(vmode)) != 0)
		{
			printf("Error Initializing Requested Video Mode!\n");
			if(i==1) printf("  - Did You Load Correct VESA Driver (TSR) ??\n");
			if(i==2) printf("  - VESA BIOS Extensions (Driver) Not Loaded !!\n");
			if(i==3) printf("  - Requested Video Mode Not Supported by this Card!\n");
			if(i==4) printf("  - Mode Not an SVGA Mode Supported by this Card!\n");
			if(i==5) printf("  - VESA Driver Not Returning Mode Information!\n");
			if(i==6) printf("  - Text I/O Not Supported by your VESA BIOS TSR!\n");
			return;
		}
	if(bug != 0)
		YCharSize = bug;
	xx = XResolution;
	yy = YResolution;
	vsa_set_text_cursor_mode(1);
	r0 = 0.85*YCharResolution;
	c0 = 0.5*XCharResolution - 17;
/*..........................................................................*/
/*             Draw color look up table at bottom of screen.                */
/*..........................................................................*/
	rainbow_lut();
	tf_set_prime_colors();
HERE:
	a = .125*xx;
	b = .91*yy;
	color_bar(a,b);
/*..........................................................................*/
/*                   Draw Prime Colors at screen right.                     */
/*..........................................................................*/
	a = xx - 11*XCharSize;
	b = ya*YCharSize;
	prime_list(a,b);
/*..........................................................................*/
/*                          Draw a banner                                   */
/*..........................................................................*/
	banner(ya);
/*..........................................................................*/
/*                         Outline Screen                                   */
/*..........................................................................*/
	vsa_set_color(TF_Red);
	vsa_move_to(0,0);
	vsa_rect(xx-1,yy-1);
	vsa_move_to(1,1);
	vsa_rect(xx-2,yy-2);
/*..........................................................................*/
/*         Wait for any key to continue; if ESC key, quit program.          */
/*..........................................................................*/
	vsa_write_string(r0,c0,TF_Yellow,
									 "Press ESC to exit, Any other key to continue ...   ");
	key = getch();
	if(key == 27)
		goto BAIL;
/*..........................................................................*/
/*                   Get picture start coordinates.                         */
/*..........................................................................*/
	vsa_set_text_color(TF_Red);
	vsa_set_text_cursor(r0,c0);
	vsa_write_string_alt("                                                   ");
	vsa_set_text_cursor(r0,c0);
	vsa_write_string_alt("Input picture origin (x0,y0): ");
	scanf("%d,%d",&x0,&y0);
	x0 += 5;
	y0 += ya*YCharSize+4;
/*..........................................................................*/
/*                            Open TIFF File.                               */
/*..........................................................................*/
FILENAME:
	vsa_set_text_color(TF_Green);
	vsa_set_text_cursor(r0,c0);
	vsa_write_string_alt("                                                   ");
	vsa_set_text_cursor(r0,c0);
	vsa_write_string_alt("Input full Filename: ");
	scanf("%s",filename);
  if(tf_open_file(filename) == -1)
		goto FILENAME;
/*..........................................................................*/
/*                      Get TIFF File information.                          */
/*..........................................................................*/
	if(tf_get_file_info() == 1)
		{
			printf("Error\n");
			return;
		}
/*..........................................................................*/
/*  Prior to reading the image information, set defaults for all globals.   */
/*..........................................................................*/
	tf_set_defaults();
/*..........................................................................*/
/* Read image information.  Globals are set, pointers to image data are     */
/* extracted.                                                               */
/*..........................................................................*/
	if(tf_read_ifd() == 1)
		goto NOTSUPPORTED;
/*..........................................................................*/
/*                 Display TIFF image starting at (x0,y0).                  */
/*..........................................................................*/
	tf_display_image(x0,y0);
/*..........................................................................*/
/*                 Restore Prime Color Values.                              */
/*..........................................................................*/
	tf_set_prime_colors();
/*..........................................................................*/
/*                            Frame new image.                              */
/*..........................................................................*/
	vsa_set_color(TF_White);
	vsa_move_to(x0-2,y0-2);
	vsa_rect(x0+(unsigned)TF_ImageWidth+1,y0+(unsigned)TF_ImageLength+1);
	vsa_set_color(TF_Black);
	vsa_move_to(x0-1,y0-1);
	vsa_rect(x0+(unsigned)TF_ImageWidth,y0+(unsigned)TF_ImageLength);
/*..........................................................................*/
/*                 Update Image Statistics                                  */
/*..........................................................................*/
	a = .70*xx;
	b = .60*yy;
	image_stats(a,b);
/*..........................................................................*/
/*                        Close opened TIFF file.                           */
/*..........................................................................*/
NOTSUPPORTED:
	tf_close_file();
	goto HERE;
/*..........................................................................*/
/*                       Restore text video mode and Bail Out.              */
/*..........................................................................*/
BAIL:
	vsa_set_svga_mode(0x3);
	tf_about();
	return;                       /*.....            End main            .....*/
}


rainbow_lut()
{
	int i,start,count;
	unsigned char color_array[768];
	for(i=0;i<224;i++)
		{
			color_array[3*i+2]=0;
			color_array[3*i+1]=0;
			color_array[3*i]=0;
		}
/*................................ RED .....................................*/
	for(i=0;i<56;i++)
		{
				color_array[3*i] = 63*sin((i*6.28)/112.0);
		}
/*............................... BLUE .....................................*/
	for(i=0;i<126;i++)
		{
				color_array[3*i+2] = 63*sin((i*6.28)/252.0);
		}
/*............................... GREEN ....................................*/
	for(i=96;i<210;i++)
		{
				color_array[3*i+1] = 63*sin(((i-90)*6.28)/252.0);
		}
/*................................ RED .....................................*/
	for(i=140;i<224;i++)
		{
				color_array[3*i]   = 63*sin(((i-140)*6.28)/280.0);
		}
	start = 32;
	count = 224;
	vsa_write_color_block(start,count,color_array);
	return 0;
}


color_bar(x0,y0)
int x0,y0;
{
	char text[100];
	unsigned char row,col;
	int i;
	unsigned xx,yy,a,b;
	float c;
	xx = XResolution;
	yy = YResolution;
/*..........................................................................*/
/*     Draw outline for color bar.                                          */
/*..........................................................................*/
	vsa_set_color(15);
	vsa_move_to(x0-1,y0-1);
	a = .75*xx;
	b = .065*yy;
	vsa_rect(x0+a+1,y0+b+1);
	c = (float)a/256;
	for(i=0;i<256;i++)
		{
			vsa_set_color((unsigned char)i);
			vsa_move_to(x0+(unsigned)(i*c),y0);
			vsa_rect_fill(x0+(unsigned)(c+i*c),y0+b);
		}
	return 0;
}

prime_list(x0,y0)
int x0,y0;
{
	unsigned char row,col;
	int i;
	unsigned xxx,yyy;

	xxx = x0 + 9*XCharSize;
	yyy = y0;

	row = (y0)/YCharSize;
	col = (x0)/XCharSize;
	vsa_set_color(TF_Black);
	vsa_write_string(row,col,TF_Black,"Black =  ");
	vsa_move_to(xxx,yyy);
	vsa_rect_fill(xxx+XCharSize,yyy+YCharSize-4);

	row ++;
  yyy += YCharSize;
	vsa_set_color(TF_Red);
	vsa_write_string(row,col,TF_Red,"Red =    ");
	vsa_move_to(xxx,yyy);
	vsa_rect_fill(xxx+XCharSize,yyy+YCharSize-4);

	row ++;
  yyy += YCharSize;
	vsa_set_color(TF_Orange);
	vsa_write_string(row,col,TF_Orange,"Orange = ");
	vsa_move_to(xxx,yyy);
	vsa_rect_fill(xxx+XCharSize,yyy+YCharSize-4);

	row ++;
  yyy += YCharSize;
	vsa_set_color(TF_Yellow);
	vsa_write_string(row,col,TF_Yellow,"Yellow = ");
	vsa_move_to(xxx,yyy);
	vsa_rect_fill(xxx+XCharSize,yyy+YCharSize-4);

	row ++;
  yyy += YCharSize;
	vsa_set_color(TF_Green);
	vsa_write_string(row,col,TF_Green,"Green =  ");
	vsa_move_to(xxx,yyy);
	vsa_rect_fill(xxx+XCharSize,yyy+YCharSize-4);

	row ++;
  yyy += YCharSize;
	vsa_set_color(TF_Aqua);
	vsa_write_string(row,col,TF_Aqua,"Aqua =   ");
	vsa_move_to(xxx,yyy);
	vsa_rect_fill(xxx+XCharSize,yyy+YCharSize-4);

	row ++;
  yyy += YCharSize;
	vsa_set_color(TF_Blue);
	vsa_write_string(row,col,TF_Blue,"Blue =   ");
	vsa_move_to(xxx,yyy);
	vsa_rect_fill(xxx+XCharSize,yyy+YCharSize-4);

	row ++;
  yyy += YCharSize;
	vsa_set_color(TF_Violet);
	vsa_write_string(row,col,TF_Violet,"Violet = ");
	vsa_move_to(xxx,yyy);
	vsa_rect_fill(xxx+XCharSize,yyy+YCharSize-4);

	row ++;
  yyy += YCharSize;
	vsa_set_color(TF_White);
	vsa_write_string(row,col,TF_White,"White =  ");
	vsa_move_to(xxx,yyy);
	vsa_rect_fill(xxx+XCharSize,yyy+YCharSize-4);

	return 0;
}

image_stats()
{
	char text[100];
	unsigned char row,col;

	row = 1;
	col = 39;

	sprintf(text,"Width  = %d     ",TF_ImageWidth);
	vsa_write_string(row,col,TF_White,text);
	row++;
	sprintf(text,"Length = %d     ",TF_ImageLength);
	vsa_write_string(row,col,TF_White,text);
	row++;
	row = 1;
	col = 55;
	if(TF_PhotometricInterpretation < 2)
		{
			vsa_write_string(row,col,TF_White,"Color Model = Bilevel or");
			row++;
			vsa_write_string(row,col,TF_White,"              GrayScale ");
			row++;
			sprintf(text,"%d Bits Per Pixel        ",TF_BitsPerSample[0]);
			vsa_write_string(row,col,TF_White,text);
			row++;
		}
	if(TF_PhotometricInterpretation == 2)
		{
			vsa_write_string(row,col,TF_White,"Color Model = True Color");
			row++;
			vsa_write_string(row,col,TF_White,"24 Bits Per Pixel       ");
			row++;
			vsa_write_string(row,col,TF_White,"(8 bits each R,G,B)     ");
			row++;
		}
	if(TF_PhotometricInterpretation == 3)
		{
			vsa_write_string(row,col,TF_White,"Color Model = Palette   ");
			row++;
			sprintf(text,"%d Bits Per Pixel        ",TF_BitsPerSample[0]);
			vsa_write_string(row,col,TF_White,text);
			row++;
			vsa_write_string(row,col,TF_White,"                        ");
			row++;
		}
	if(TF_PhotometricInterpretation > 3)
		vsa_write_string(row,col,TF_White,"Color Model = Unknown   ");
	return 0;
}

banner(ya)
unsigned ya;
{
	unsigned char row,col;
	char text[100];
	unsigned xx,yy;
	xx = XResolution;
	yy = YResolution;
	vsa_move_to(0,0);
	vsa_set_color(TF_Red);
	vsa_rect(xx-1,ya*YCharSize);
	vsa_move_to(38*XCharSize,0);
	vsa_line_to(38*XCharSize,ya*YCharSize);
	vsa_move_to(38*XCharSize+1,0);
	vsa_line_to(38*XCharSize+1,ya*YCharSize);
	row = 1;
	col = 2;
	sprintf(text,"TIFF256 GRAPHICS LIBRARY EXTENSIONS");
	vsa_write_string(row,col,TF_Green,text);
	sprintf(text,"           VERSION 1.0");
	vsa_write_string(row+1,col,TF_Green,text);
	sprintf(text,"    Copyright Spyro Gumas 1992");
	vsa_write_string(row+2,col,TF_Green,text);
	return 0;
}
