/*****************************************************************************
 VGLMOUSE.C

 Simple routines for mouse handling.  Nothing special, but somebody asked
 for them.  Should work with all Microsoft compatible mice.

 Mark
 morley@camosun.bc.ca
*****************************************************************************/

#include <dos.h>

static int Mouse = 0;                   /* Whether or not we have a mouse   */
static int Hidden = 0;                  /* Whether or not it's hidden       */

/*****************************************************************************
 Returns 1 if there is a mouse attached, 0 if not.  You must have first
 called vglMouseInit()
*****************************************************************************/
int vglMousePresent()
{
   return Mouse;
}

/*****************************************************************************
 Initialize the mouse (if it exists).  Returns 1 if the mouse exists, 0 if
 it doesn't.  By default the mouse is hidden and must be explicitly turned
 on (vglShowMouse)
*****************************************************************************/
int vglInitMouse()
{
   union REGS r;

   r.x.ax = 0;
   int86( 0x33, &r, &r );
   if( r.x.ax )
   {
      Mouse = 1;
      r.x.ax = 0x1c;
      r.x.bx = 1;
      int86( 0x33, &r, &r );
   }
   else
      Mouse = 0;
   Hidden = 1;
   return Mouse;
}

/*****************************************************************************
 Turns on the mouse cursor.
*****************************************************************************/
int vglShowMouse()
{
   union REGS r;

   if( Mouse && Hidden )
   {
      r.x.ax = 1;
      int86( 0x33, &r, &r );
      Hidden = 0;
      return 1;
   }
   return 0;
}

/*****************************************************************************
 Hides the mouse cursor.
*****************************************************************************/
int vglHideMouse()
{
   union REGS r;

   if( Mouse && !Hidden )
   {
      r.x.ax = 2;
      int86( 0x33, &r, &r );
      Hidden = 1;
      return 1;
   }
   return 0;
}

/*****************************************************************************
 Hides the mouse cursor if it lies within the specified rectangle.
*****************************************************************************/
int vglHideMouseIf( int x1, int y1, int x2, int y2 )
{
   int x, y, b;

   if( Mouse && !Hidden )
   {
      vglGetMouseInfo( &x, &y, &b );
      if( x >= x1 && x <= x2 && y >= y1 && y <= y2 )
         return( vglHideMouse() );
   }
   return 0;
}

/*****************************************************************************
 Returns the mouse status.  It's X and Y position is returned in 'x' and 'y',
 and its button status is returned in 'b'.
*****************************************************************************/
int vglGetMouseInfo( int* x, int* y, int* b )
{
   union REGS r;

   if( Mouse )
   {
      r.x.ax = 3;
      int86( 0x33, &r, &r );
      *b = r.x.bx;
      *x = r.x.cx;
      *y = r.x.dx;
      return *b;
   }
   else
      return 0;
}

