#include <stdio.h>
#include <math.h>
#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include "vort.h"

#define	CMAPSIZE	256

extern char	*rindex();


/*
 * simple program to display a single channel of an pixel file. Channel
 * displayed depends on the name of the program at run time.
 */
main(ac, av)
	int	ac;
	char	**av;
{
	Frame		frame;
	Canvas		canvas;
	char		name[BUFSIZ], title[BUFSIZ], *pt;
	register int	x, y, val, ox;
	image		*im;
	short		i, h, w;
	u_char		r[CMAPSIZE], b[CMAPSIZE], g[CMAPSIZE], *red, *green, *blue, *alpha, *channel;
	register Pixwin	*pw;

	
	if ((pt = rindex(av[0], '/')) != (char *)NULL)
		strcpy(name, pt + 1);
	else
		strcpy(name, av[0]);

	if (ac != 2) {
		fprintf(stderr, "%s: usage %s filename.\n", av[0], av[0]);
		exit(1);
	}

	if ((im = openimage(av[1], "r")) == (image *)NULL) {
		fprintf(stderr, "%s: can't open file %s.\n", av[0], av[1]);
		exit(1);
	}

	w = imagewidth(im);
	h = imageheight(im);

	red = (u_char *)malloc(w);
	green = (u_char *)malloc(w);
	blue = (u_char *)malloc(w);
	alpha = (u_char *)malloc(w);

	strcpy(title, name);
	strcat(title, ": ");
	strcat(title, imagetitle(im));

	frame = window_create(0, FRAME, WIN_HEIGHT, h, WIN_WIDTH, w, FRAME_LABEL, name, 0);
	canvas = window_create(frame, CANVAS, CANVAS_RETAINED, FALSE, WIN_HEIGHT, h, WIN_WIDTH, w, 0);
	window_fit(frame);
	pw =(Pixwin *)canvas_pixwin(canvas);

	if (name[0] == 'r') {
		channel = red;
		for (i = 0; i < CMAPSIZE; i++) {
			g[i] = b[i] = 0;
			r[i] = i;
		}
	} else if (name[0] == 'g') {
		channel = green;
		for (i = 0; i < CMAPSIZE; i++) {
			r[i] = b[i] = 0;
			g[i] = i;
		}
	} else if (name[0] == 'b') {
		channel = blue;
		for (i = 0; i < CMAPSIZE; i++) {
			r[i] = g[i] = 0;
			b[i] = i;
		}
	} else if (name[0] == 'a') {
		channel = alpha;
		for (i = 0; i < CMAPSIZE; i++)
			r[i] = g[i] = b[i] = i;
	}

	pw_setcmsname(pw, name);
	pw_putcolormap(pw, 0, CMAPSIZE, r, g, b);

	window_set(canvas, CANVAS_RETAINED, TRUE, 0);

	pw_batch_on(pw);

	y = 0;
	x = 0;
	val = -1;

	while (readrgbaline(im, red, green, blue, alpha)) {
		for (x = 0; x != w; x++)
			pw_put(pw, x, y, channel[x]);
		y++;
	}

	pw_batch_off(pw);
	window_main_loop(frame);

	exit(0);
}
