/*
 * VGA 320 x 200 display routine for VORT PCDISP.
 */

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <memory.h>
#include "pcdisp.h"


int		vega_palette();
int		vega_overscan();

static vga320x200_init();
static vga320x200_line();
static vga320x200_block();
static vga320x200_fill();
static vga320x200_front();
static vga320x200_back();
static vga320x200_swap();
static vga320x200_text();
extern vga320x200_EMSdecode();


static	ADAPTER	vga320x200 = {
			"VGA 320 x 200, 256 colour",
			320,
			200,
			8,
			0x13, 0,
			0,
			vga320x200_init,
			vga320x200_line,
			vga320x200_EMSdecode,
			NULL,
			vga320x200_block,
			vga320x200_fill,
			vega_palette,
			vega_overscan,
			vga320x200_front,
			vga320x200_back,
			vga320x200_swap,
			vga320x200_text,
			NULL,
			NULL
			};


/* for doing system stuff */
static	union	REGS	regs;
static	struct	SREGS	segregs;


/* vga video buffer pointers */
static	char	*vfbuf,
				*vbbuf,
				*vp;

/* video buffer flag: == 0 front buffer; != 0 back buffer */
static	int		to_back_buffer = 0;
static	int		double_buffer = FALSE;



int			setup_vga320x200(a)
ADAPTER		*a;
{
	memmove(a, &vga320x200, sizeof(vga320x200));
	return 1;
}


static
int			vga320x200_init()
{
	regs.x.ax = 0x13;
 	int86(0x10, &regs, &regs);

	vfbuf = vp = (char *)0xa0000000;
	vbbuf = calloc(vga320x200.width*vga320x200.height, 1);
	if (!vbbuf) {
		fprintf(stderr, "setup_vga320x200: memory request for %u bytes failed\n", vga320x200.width*vga320x200.height);
		double_buffer = FALSE;
		}
	else double_buffer = TRUE;
	return 1;
}


static
int			vga320x200_line(p, l, x, y)
char		*p;
int			l,
			x,
			y;
{
	if (y >= 200 || x >= 319) return;
	memmove(vp + y*320 + x, p, min(l, 320-x));
}


static
int			vga320x200_block(p, w, h, x, y)
char		*p;
int			w,
			h,
			x,
			y;
{
	int		i, w1;
	char	*v;

	/* ensure everything is in range */
	v = vp + y*320 + x;
	if (w + x > 320) w1 = 320 - x;
	else w1 = w;
	if (h + y > 200) h = 200 - y;

	/* output line by line */
	for (i = 0; i < h; i++) {
		memmove(v, p, w1);
		v += 320;
		p += w;
		}
}


static
int			vga320x200_fill(x, y, w, h, palette_index)
{
	int		j;

	if (x == 0 && y == 0 && w == 320 && h == 200) {
		memset(vp, palette_index, 320*200);
		}
	else {
		for (j = 0; j < h; j++) {
			memset(vp+j*320+x, palette_index, w);
			}
		}
}


static
int			vga320x200_front()
{
	if (double_buffer) vp = vfbuf;
}


static
int			vga320x200_back()
{
	if (double_buffer) vp = vbbuf;
}


static
int			vga320x200_swap()
{
	if (double_buffer) memmove(vfbuf, vbbuf, 320*200);
}


static
int			vga320x200_text(p, x, y)
char		*p;
int			x,
			y;
{
}

