/*.................................. VSA.H ................. 5-8-92 ........*/
/* This file declares the VSA256 Graphics Library functions and global      */
/* parameters used throughout the graphics routines.                        */
/*                                                                          */
/*            Copyright Spyro Gumas, 1992.  All Rights Reserved.            */
/*..........................................................................*/


/*..........................................................................*/
/*                          Function Prototypes                             */
/*..........................................................................*/
unsigned  _far _cdecl vsa_set_svga_mode( unsigned );
unsigned  _far _cdecl vsa_get_svga_mode( unsigned _far * );
unsigned  _far _cdecl vsa_set_display_start( unsigned, unsigned );
unsigned  _far _cdecl vsa_get_display_start( unsigned _far *,
											unsigned _far * );
unsigned  _far _cdecl vsa_init( unsigned );
void _far _cdecl vsa_set_color( unsigned );
void _far _cdecl vsa_set_text_color( unsigned );
void _far _cdecl vsa_set_text_cursor_mode( unsigned );
void _far _cdecl vsa_set_text_cursor( unsigned, unsigned );
void _far _cdecl vsa_write_char( unsigned, unsigned, char );
void _far _cdecl vsa_write_string( unsigned, unsigned, unsigned, char _far * );
void _far _cdecl vsa_write_string_alt( char _far * );
void _far _cdecl vsa_read_color_register( unsigned, unsigned char _far *,
								 unsigned char _far *, unsigned char _far *);
void _far _cdecl vsa_write_color_register( unsigned, unsigned char,
								 unsigned char, unsigned char );
void _far _cdecl vsa_read_color_block( unsigned, unsigned,
								 unsigned char _far * );
void _far _cdecl vsa_write_color_block( unsigned, unsigned,
								 unsigned char _far * );
void _far _cdecl vsa_move_to( unsigned, unsigned );
void _far _cdecl vsa_set_pixel( unsigned, unsigned );
void _far _cdecl vsa_line_to( unsigned, unsigned );
void _far _cdecl vsa_rect_fill( unsigned, unsigned );
void _far _cdecl vsa_rect( unsigned, unsigned );
void _far _cdecl vsa_h_line( unsigned, unsigned, unsigned );
void _far _cdecl vsa_v_line( unsigned, unsigned, unsigned );
void _far _cdecl vsa_raster_line( unsigned, unsigned,unsigned,
																	unsigned char _far *);
void _far _cdecl vsa_about( void );

/*..........................................................................*/
/*                          Function Prototypes                             */
/*   The following functions only work in VESA mode 105h (1024 x 768 x 8)   */
/*   and should run alittle faster, but they should only be used            */
/*   experimentaly cause they "aint really checked out".                    */
/*..........................................................................*/
void _far _cdecl vsa_line_to_x( unsigned, unsigned );
void _far _cdecl vsa_rect_fill_x( unsigned, unsigned );
void _far _cdecl vsa_h_line_x( unsigned, unsigned, unsigned );
void _far _cdecl vsa_v_line_x( unsigned, unsigned, unsigned );
void _far _cdecl vsa_raster_line_x( unsigned, unsigned,unsigned,
																		unsigned char _far *);

/*..........................................................................*/
/*                    External Parameter Declarations                       */
/*..........................................................................*/
unsigned XResolution, YResolution, XCharResolution, YCharResolution;
unsigned char XCharSize, YCharSize;
unsigned char BitsPerPixel;
