/*..........................................................................*/
/*                              VSA_DEMO.C              7-4-92              */
/*                                                                          */
/*  This is the "C" source code for the VSA_DEMO.EXE program.  This program */
/*  demonstrates the usage of the VSA256 Graphics Library, Version 1.1      */
/*  functions.                                                              */
/*                                                                          */
/*            Copyright Spyro Gumas, 1992.  All Rights Reserved.            */
/*..........................................................................*/

#include<stdlib.h>
#include<math.h>
#include<limits.h>
#include<bios.h>

#include "vsa.h"             /* Required to support VSA256 Graphics Library */


void cube(int,int,int);
void rainbow_lut();
void special_lut();
void color_bar(int,int);
void banner(int,int);
void image(int,int);

float SIN_LUT[1024];

void main()
{
	int i,x,y,size;
	unsigned vmode,xx,yy,a,b,c,d;
	unsigned char color,j,jj,row,col;
	char text[100],your_name[80];
	unsigned char color_array[768],save_color_array[768];
	unsigned char red[256],green[256],blue[256];
	srand(1);
/*..........................................................................*/
/*                      Initialize sin look up table.                       */
/*  Index 'i' goes from 0 to 1023 and is equivalent to 0 to 360 degrees.    */
/*..........................................................................*/
	for(i=0;i<1024;i++)
		SIN_LUT[i] = sin(i*6.28/1024.0);
/*..........................................................................*/
/*               Initialize video mode and VSA256 environment.              */
/*               Valid modes are: 100h, 101h, 103h, and 105h.               */
/*..........................................................................*/
	printf("\n");
	printf("Input VESA standard Video Mode (hex)\n");
	printf("(100, 101, 103, or 105): ");
	scanf("%x",&vmode);
	vsa_init(vmode);
	xx = XResolution;
	yy = YResolution;
	vsa_set_color(1);
	vsa_move_to(0,0);
	vsa_rect(xx-1,yy-1);

/*..........................................................................*/
/*             Draw color look up table at bottom of screen.                */
/*..........................................................................*/
	rainbow_lut();
	a = .125*xx;
	b = .81*yy;
	color_bar(a,b);
/*..........................................................................*/
/*            Draw "random" cubes enclosed by rectangle                     */
/*..........................................................................*/
	a = .6*xx;
	b = .4*yy;
	c = .88*xx;
	d = .72*yy;
	vsa_move_to(a,b);
	vsa_set_color(180);
	vsa_rect(c,d);
	vsa_move_to(a+1,b+1);
	vsa_set_color(20);
	vsa_rect_fill(c-1,d-1);
	for(i=0;i<16;i++)
		{
			x = a+5+.23*xx*(float)rand()/RAND_MAX;
			y = b+5+.23*yy*(float)rand()/RAND_MAX;
			size = .05*xx*(float)rand()/RAND_MAX;
			color = (unsigned char) i;
			vsa_set_color(color);
			cube(x,y,size);
		}
	row = (.74*yy)/YCharSize;
	col = (.64*xx)/XCharSize;
	row = (d)/YCharSize + 1;
	col = (a+(c-a)/2)/XCharSize - 12;
	sprintf(text,"Lines using `vsa_line_to'");
	vsa_write_string(row,col,250,text);
/*..........................................................................*/
/*                          Draw a banner                                   */
/*..........................................................................*/
	a = .55*xx;
	b = .06*yy;
	banner(a,b);
/*..........................................................................*/
/*                    Draw 2D sine-cosine image                             */
/*..........................................................................*/
	a = .08*xx;
	b = .26*yy;
	image(a,b);
/*..........................................................................*/
/*                        Using Text Cursor Mode 1.                         */
/*..........................................................................*/
	row = .1*yy/YCharSize;
	col = .05*xx/XCharSize;
	vsa_set_text_cursor_mode(1);
	vsa_write_string(row,col,250,"Please Enter Your Name: ");
	scanf("%s",&your_name);

	vsa_set_text_color(200);
	vsa_set_text_cursor(row+1,col);
	vsa_write_string_alt("Hello ");
	vsa_write_string_alt(your_name);
	vsa_write_string_alt(", Hit any key to bail.");
/*..........................................................................*/
/*    Now do sliding blue color effect, until someone presses a key.        */
/*..........................................................................*/
	vsa_read_color_block(251,5,save_color_array);
	for(j=0;j<5;j++)
		{
			red[j+251]   = save_color_array[3*j];
			green[j+251] = save_color_array[3*j+1];
			blue[j+251]  = save_color_array[3*j+2];
		}
INFINITE_LOOP:
	for(i=32;i<256;i++)
		{
			j = (unsigned char) i;
			vsa_read_color_register(j,&red[j],&green[j],&blue[j]);
			vsa_write_color_register(j,0,0,63);
			if(j <= 36)
				jj = (unsigned char)(j-37);
			else
				jj = (unsigned char)(j-5);
			vsa_write_color_register(jj,red[jj],green[jj],blue[jj]);
/*.....
			For Borland C, Use this line instead.
			if(bioskey(1))
.....*/
			if(_bios_keybrd(_KEYBRD_READY))
				goto BAIL;
		}
	goto INFINITE_LOOP;
/*..........................................................................*/
/*           Restore text video mode and print information.                 */
/*..........................................................................*/
BAIL:
	vsa_set_svga_mode(0x3);
	vsa_about();
	return;
}

void cube(int x,int y,int size)
{
	int sizeb;
	sizeb = size/2;
	vsa_move_to(x,y);
	vsa_line_to(x+size,y);
	vsa_line_to(x+size,y+size);
	vsa_line_to(x,y+size);
	vsa_line_to(x,y);
	vsa_line_to(x+sizeb,y+sizeb);
	vsa_line_to(x+sizeb+size,y+sizeb);
	vsa_line_to(x+sizeb+size,y+sizeb+size);
	vsa_line_to(x+sizeb,y+sizeb+size);
	vsa_line_to(x+sizeb,y+sizeb);
	vsa_move_to(x+size,y);
	vsa_line_to(x+sizeb+size,y+sizeb);
	vsa_move_to(x+size,y+size);
	vsa_line_to(x+sizeb+size,y+sizeb+size);
	vsa_move_to(x,y+size);
	vsa_line_to(x+sizeb,y+sizeb+size);
	return;
}

void rainbow_lut()
{
	int i,start,count;
	unsigned char color_array[768];
	for(i=0;i<224;i++)
		{
			color_array[3*i+2]=0;
			color_array[3*i+1]=0;
			color_array[3*i]=0;
		}
/*................................ RED .....................................*/
	for(i=0;i<56;i++)
		{
				color_array[3*i] = 63*sin((i*6.28)/112.0);
		}
/*............................... BLUE .....................................*/
	for(i=0;i<126;i++)
		{
				color_array[3*i+2] = 63*sin((i*6.28)/252.0);
		}
/*............................... GREEN ....................................*/
	for(i=96;i<210;i++)
		{
				color_array[3*i+1] = 63*sin(((i-90)*6.28)/252.0);
		}
/*................................ RED .....................................*/
	for(i=140;i<224;i++)
		{
				color_array[3*i]   = 63*sin(((i-140)*6.28)/280.0);
		}
	start = 32;
	count = 224;
	vsa_write_color_block(start,count,color_array);
	return;
}

void special_lut()
{
	int i,start,count;
	unsigned char color_array[768];
	for(i=0;i<256;i++)
		{
			color_array[3*i+2]=0;
			color_array[3*i+1]=0;
			color_array[3*i]=0;
		}
/*............................... BLUE .....................................*/
	for(i=0;i<128;i++)
		{
				color_array[3*i+2] = 63*sin((i*6.28)/256.0);
		}
/*............................... GREEN ....................................*/
	for(i=48;i<240;i++)
		{
				color_array[3*i+1] = 63*sin(((i-48)*6.28)/384.0);
		}
/*................................ RED .....................................*/
	for(i=128;i<256;i++)
		{
				color_array[3*i]   = 63*sin(((i-128)*6.28)/512.0);
		}
	start = 0;
	count = 256;
	vsa_write_color_block(start,count,color_array);
	return;
}

void color_bar(x0,y0)
int x0,y0;
{
	char text[100];
	unsigned char row,col;
	int i;
	unsigned xx,yy,a,b;
	float c;
	xx = XResolution;
	yy = YResolution;
/*..........................................................................*/
/*     Draw outline for color bar.                                          */
/*..........................................................................*/
	vsa_set_color(15);
	vsa_move_to(x0-1,y0-1);
	a = .75*xx;
	b = .065*yy;
	vsa_rect(x0+a+1,y0+b+1);
	c = (float)a/256;
	for(i=0;i<256;i++)
		{
			vsa_set_color((unsigned char)i);
			vsa_move_to(x0+(unsigned)(i*c),y0);
			vsa_rect_fill(x0+(unsigned)(c+i*c),y0+b);
		}
	row = (y0+b+1)/YCharSize + 1;
	col = (x0+a/2)/XCharSize - 31;
	sprintf(text,"Color Look Up Table Manipulation using");
	vsa_write_string(row,col,63,text);
	sprintf(text," `vsa_write_color_block'");
	vsa_write_string(row,col+38,63,text);
	sprintf(text,"'vsa_read_color_register' and");
	vsa_write_string(row+1,col,63,text);
	sprintf(text,"`vsa_write_color_register'.");
	vsa_write_string(row+1,col+31,63,text);
	return;
}

void banner(int x,int y)
{
	int x0,y0,x1,y1;
	unsigned char row,col;
	char text[100];
	unsigned xx,yy,a,b;
	xx = XResolution;
	yy = YResolution;
	a = .40*xx;
	b = .17*yy;
	vsa_move_to(x,y);
	vsa_set_color(1);
	vsa_rect_fill(x+a,y+b);
	vsa_move_to(x+5,y+5);
	vsa_set_color(0);
	vsa_rect_fill(x+a-5,y+b-5);
	row = (y+6+b/2)/YCharSize - 1;
	col = (x+(a+5)/2)/XCharSize - 13;
	sprintf(text,"VSA256 GRAPHICS LIBRARY");
	vsa_write_string(row,col,200,text);
	sprintf(text,"for C Programmers");
	vsa_write_string(row+1,col,200,text);
	sprintf(text,"Copyright Spyro Gumas 1992");
	vsa_write_string(row+2,col,200,text);
	vsa_set_text_color(250);
	vsa_write_char(row+1,col+18,'V');
	vsa_write_char(row+1,col+19,'1');
	vsa_write_char(row+1,col+20,'.');
	vsa_write_char(row+1,col+21,'1');
	row = (y+b)/YCharSize + 1;
	col = (x+(a+5)/2)/XCharSize - 13;
	sprintf(text,"Character and Text Strings");
	vsa_write_string(row,col,2,text);
	sprintf(text,"using `vsa_write_char'");
	vsa_write_string(row+1,col,2,text);
	sprintf(text,"and `vsa_write_string'");
	vsa_write_string(row+2,col,2,text);
	return;
}

void image(int x,int y)
{
	int i,j;
	long ii,jj,z1,z2;
	unsigned char array[1024],row,col;
	char text[100];
	unsigned xx,yy,a,b;
	xx = XResolution;
	yy = YResolution;
	a = .4*xx;
	b = .26*yy;
	z1 = 2*1024L/a;
	z2 = 1024L/b;
	vsa_move_to(x-2,y-2);
	vsa_set_color(250);
	vsa_rect(x+a+1,y+b+1);
	for(j=0;j<b;j++)
		{
			for(i=0;i<a;i++)
				{
					ii = (i*z1) & 0x000003ff;
					jj = (j*z2+256) & 0x000003ff;
/*.....
					array[i] = 144+112*sin(i*6.28/c)*cos(j*6.28/c);
.....*/
					array[i] = 144+112*SIN_LUT[ii]*SIN_LUT[jj];
				}
			vsa_raster_line(x,x+a-1,y+j,array);
		}
	row = (y+b+1)/YCharSize + 1;
	col = (x+a/2)/XCharSize - 17;
	sprintf(text,"2D Images Using `vsa_raster_line()'");
	vsa_write_string(row,col,100,text);
	return;
}


