unit SDOVR;
{$O+,F+,V-}

interface

uses crt;

procedure showhelp;

procedure DisplayInfo(
 bbstype: word;
 var user_first_name,user_last_name: string;
 var user_access_level: word;
 var bbs_time_left: integer;
 var com_port: byte;
 var baud_rate: word;
 var node_num: byte;
 var local: boolean;
 var graphics: byte;
 var color1: boolean;
 var color_chg: boolean;
 var board_name: string;
 var sysop_first_name: string;
 var sysop_last_name: string;
 var maxtime: word;
 var doorfilepath: string;
 var lockbaud: word);

procedure GetBBSInfo(
 bbstype: word;
 var user_first_name,user_last_name: string;
 var user_access_level: word;
 var bbs_time_left: integer;
 var com_port: byte;
 var baud_rate: word;
 var node_num: byte;
 var local: boolean;
 var graphics: byte;
 var color1: boolean;
 var color_chg: boolean;
 var board_name: string;
 var sysop_first_name: string;
 var sysop_last_name: string;
 var maxtime: word;
 var doorfilepath: string;
 var lockbaud: word);

procedure MakeInfoStrings(
 bbstype: word;
 var user_first_name,user_last_name: string;
 var user_access_level: word;
 var bbs_time_left: integer;
 var com_port: byte;
 var baud_rate: word;
 var node_num: byte;
 var local: boolean;
 var graphics: byte;
 var color1: boolean;
 var color_chg: boolean;
 var board_name: string;
 var sysop_first_name: string;
 var sysop_last_name: string;
 var maxtime: word;
 var doorfilepath: string;
 var lockbaud: word);

const
 numddovrstr=11;
type
 ddovrstrptr=^string;
 ddovrstrarray=array[1..numddovrstr] of ddovrstrptr;
var
 ddovrinfo: ddovrstrarray;

implementation

procedure GetBBSInfo(
 bbstype: word;
 var user_first_name,user_last_name: string;
 var user_access_level: word;
 var bbs_time_left: integer;
 var com_port: byte;
 var baud_rate: word;
 var node_num: byte;
 var local: boolean;
 var graphics: byte;
 var color1: boolean;
 var color_chg: boolean;
 var board_name: string;
 var sysop_first_name: string;
 var sysop_last_name: string;
 var maxtime: word;
 var doorfilepath: string;
 var lockbaud: word);

type
   char2     = array [1..2] of char;
   char8     = array [1..8] of char;
   char9     = array [1..9] of char;
   char12    = array [1..12] of char;
   char13    = array [1..13] of char;
   char25    = array [1..25] of char;

   basic_real_type = array[1..4] of char;

   pcb_sys_rec = record
      display:        char2;          {display on console?  -1 or 0}
      printer:        char2;          {print log?           -1 or 0}
      page_bell:      char2;          {bother sysop?        -1 or 0}
      alarm:          char2;          {caller alarm sound?  -1 or 0}
      sysop_next:     char2;          {force sysop on next? 'N ', 'X ' or '  '}

      baud:           array [1..4] of char;       {caller's baud rate}
      name:           char25;         {caller's name}
      xpert:          char;           {pcb/pro's own expert flag}
      nulls:          char;           {pcb/pro's own nulls flag}
      firstname:      array [1..15] of char;      {caller's first name}
      graphics:       char2;          {ansi graphics mode?   '-1', ' 0' or '7E'}
      password:       array [1..12] of char;      {caller's password (last 2 chars redef'd}
      usernum:        integer;        {record number in user file}
      time_on:        Basic_real_type;
      time_limit:     Basic_real_type;
      open_time:      Basic_real_type;
      time_logged:    array [1..5] of char;       {time the user logged on in hh:mm}
      conference:     integer;        {active conference when door opened}
      joined:         array[1..9] of integer;
                                      {0 or -1 for conferences joined}
      time_added:     integer;        {highest conference added time in mins}
      down_limit:     array[1..8] of char;
      upload_credit:  integer;        {upload time credit so far that call}

      slanguage:      array [1..4] of char;       {language version used, blank, .FRE etc}
      errcheck:       char2;          {error check/correcting modem? -1 or 0}
      nodechat:       char;           {node chat flag prior to exit to DOS}
   end;

var
 pcbsys:       pcb_sys_rec;

function wva(a: word): string;
var
 s: string;
begin;
 str(a,s);
 wva:=s;
end;

function stu(s: string): string;
var
 a: integer;
begin;
 for a:=1 to length(s) do s[a]:=upcase(s[a]);
 stu:=s;
end;

procedure DDError(s: string);
begin;
 write(^G);
 writeln('ERROR: '+s);
 write(^G);
 delay(500);
 halt;
end;

function basic_real(breal: basic_real_type): real;
type
 atmp=array[1..6] of char;
var
 dummy: real;
 x: atmp absolute dummy;
begin;
 x[1]:=breal[4];
 x[2]:=#0;
 x[3]:=#0;
 x[4]:=breal[1];
 x[5]:=breal[2];
 x[6]:=breal[3];
 basic_real:=int(dummy);
end;

procedure get_pcbsys_file;
var
   fd:  file of pcb_sys_rec;
begin
 assign(fd,doorfilepath+'PCBOARD.SYS');
 {$i-} reset(fd); {$i+}
 if ioresult <> 0 then begin;
  dderror('Can''t read system file PCBOARD.SYS');
  halt;
 end;
 read(fd,pcbsys);
 close(fd);
end;

function pcboard_time_left: byte;
var
 tl: integer;
 time_used: real;
 time_left: real;
begin;
 time_used:=basic_real(pcbsys.open_time)-basic_real(pcbsys.time_on);
 time_left:=basic_Real(pcbsys.time_limit)-(time_used);
 tl:=round(time_left/60);
 if tl>255 then tl:=255;
 pcboard_time_left:=tl;
end;

procedure GetPcb14(var fname,lname: string; var comport,baud,graphics,tleft: word);
TYPE
   BasArray        = Array[1..4] of byte;
   Ascii2          = Array[1..2] of char;
   Ascii4          = Array[1..4] of char;
   Ascii5          = Array[1..5] of char;
   Ascii8          = Array[1..8] of char;
   Ascii12         = Array[1..12] of char;
   Ascii15         = Array[1..15] of char;
   Ascii18         = Array[1..18] of char;
   Ascii25         = Array[1..25] of char;
   Ascii27         = Array[1..27] of char;
   String80        = String[80];
   FileNameType    = String[80];

   PCB14FileType   = Record
      Display,
      Printer,
      PageBell,
      CallAlarm    : Ascii2;
      SysopNext    : Char;
      ModemType    : Ascii2;
      Graphlvl,
      NodeChat     : Char;
      BaudOpen,
      BaudRate     : Ascii5;
      RecordNum    : Integer;
      FirstName    : Ascii15;
      Password     : Ascii12;
      TimeLogOn,
      TimeUsed     : Integer;
      LogOnStr     : Ascii5;
      TimeLimit,
      ByteLmtDL    : Integer;
      ConfExit     : Char;
      ConfFlags,
      ConfScan     : Ascii5;
      ConfTime,
      TimeCred     : Integer;
      Language     : Ascii4;
      Name         : Ascii25;
      TimeLeft     : Integer;
      NodeNum      : Char;
      EventTime    : Ascii5;
      EventFlag,
      EventMove    : Ascii2;
      MsgRecall    : Ascii4;
      ComPortID    : Char;
      Reserved     : Ascii2;
   end;

VAR
   pcbfile : file;
   pcb : pcb14filetype;
   qbbsout : text;
   filname : string[8];
   lastname : string[20];
   graph : integer;
   sys_name,
   sysopfirst,
   sysoplast : string[30];
   a,b : integer;

   HexData     : Array[1..128] of Byte;
   data        : string[128];
   Name        : String[25];
   GM          : String[2];
   I,J         : Integer;
   JL,MaxTime,
   TimeUsed    : LongInt;

   s: string;

Begin
 Assign(PCBFile,doorfilepath+'PCBoard.Sys');
 {$I-}
 Reset(PCBFile);
 {$I+}
 If (IOResult<>0) Then dderror('... Unable to open pcboard.sys file...');
 BlockRead(PCBFile,HexData,1);
 Close(PCBFile);
 Data:='';
 For I:=1 to 128 do Data:=Data+Chr(HexData[I]);
 move(hexdata,pcb,sizeof(pcb));
 Name:=Copy(Data,85,25);
 FName:=Copy(Data,26,15);
 LName:=Copy(Name,Pos(' ',Name)+1,Length(Name));
 If (Data[23]=' ') Then Data[23]:='.';
 Val(Copy(Data,126,1),ComPort,I);
 s:=copy(data,14,5);
 while s[length(s)]=' ' do delete(s,length(s),1);
 val(s,baud,i);
 If (baud=0) Then ComPort:=0;
 Case Data[12] of
  'Y': begin
        Graphics:=2;
       end;
  'N': begin
        Graphics:=0;
       end;
  '7': begin
        Graphics:=0;
       end;
 End; {Case}
 TLeft:=pcb.timeleft;
 while ((fname[1]=#0) or (fname[1]=#32)) and (length(fname)>1) do delete(fname,1,1);
 while ((fname[length(fname)]=#0) or (fname[length(fname)]=#32)) and (length(fname)>1) do delete(fname,length(fname),1);
 while ((lname[1]=#0) or (lname[1]=#32)) and (length(lname)>1) do delete(lname,1,1);
 while ((lname[length(lname)]=#0) or (lname[length(lname)]=#32)) and (length(lname)>1) do delete(lname,length(lname),1);
 for a:=1 to length(fname) do fname[a]:=upcase(fname[a]);
 for a:=1 to length(lname) do lname[a]:=upcase(lname[a]);
end;

procedure load_rbbs16;
var
 fd:    text;
 a,b: integer;
 s,s2: string;
begin
 assign(fd,doorfilepath+'DORINFO'+wva(node_num)+'.DEF');
 {$i-}
 reset(fd);
 {$i+}
 if ioresult <> 0 then dderror('Can''t open DORINFO'+wva(node_num)+'.DEF');
 local:=false;
 readln(fd,s);
 readln(fd,s);
 readln(fd,s);
 readln(fd,s);
 val(s[4],com_port,a);
 if com_port=0 then local:=true;
 readln(fd,s);
 s2:='';
 s:=stu(s);
 for a:=1 to pos('BAUD',s)-2 do s2:=s2+s[a];
 if s2[1]=' ' then delete(s2,1,1);
 val(s2,baud_rate,a);
 if (stu(s2)='LOCA') or (stu(s2)='LOCAL') then local:=true;
 if baud_rate=0 then local:=true;
 readln(fd,s);
 readln(fd,user_first_name);
 readln(fd,user_last_name);
 readln(fd,s);
 readln(fd,s);
 if s[1]=' ' then delete(s,1,1);
 while s[length(s)]=' ' do delete(s,length(s),1);
 val(s,graphics,a);
 graphics:=graphics+1;
 if color1 then inc(graphics);
 readln(fd,s);
 if s[1]=' ' then delete(s,1,1);
 while s[length(s)]=' ' do delete(s,length(s),1);
 val(s,user_access_level,a);
 readln(fd,s);
 if s[1]=' ' then delete(s,1,1);
 while s[length(s)]=' ' do delete(s,length(s),1);
 val(s,bbs_time_left,a);
 close(fd);
 user_first_name:=stu(user_first_name);
 user_last_name:=stu(user_last_name);
end;

procedure Load_pcboard14;
var
 tleft,com,baud,graph: word;
begin;
 getpcb14(user_first_name,user_last_name,com,baud,graph,tleft);
 com_port:=com;
 baud_rate:=baud;
 graphics:=graph;
 bbs_time_left:=tleft;
 user_access_level:=50;
 graphics:=graphics+1;
 if (baud_rate=0) or (com_port=0) then local:=true else local:=false;
end;

procedure load_pcboard;
var
 a: integer;
 b: boolean;
 ton,toff: real;
begin;
 user_access_level:=0;
 local:=false;
 get_pcbsys_file;
 b:=false;
 user_first_name:='';
 user_last_name:='';
 for a:=1 to 25 do if (pcbsys.name[a]=' ') or (pcbsys.name[a]=#0) then b:=true else if b=false then
  user_first_name:=user_first_name+pcbsys.name[a] else user_last_name:=user_last_name+pcbsys.name[a];
 baud_rate:=300;
 if (pcbsys.baud[1]='1') and (pcbsys.baud[2]='2') then baud_rate:=1200;
 if pcbsys.baud[1]='2' then baud_rate:=2400;
 if pcbsys.baud[1]='4' then baud_rate:=4800;
 if pcbsys.baud[1]='9' then baud_rate:=9600;
 if (pcbsys.baud[1]='1') and (pcbsys.baud[2]='9') then baud_rate:=19200;
 if pcbsys.baud[1]='L' then local:=true;
 if pcbsys.graphics[2]='0' then graphics:=1 else graphics:=3;
 bbs_time_left:=pcboard_time_left;
 user_first_name:=stu(user_first_name);
 user_last_name:=stu(user_last_name);
end;

procedure load_phnx;
var
 f : text;
 s : string;
 code,i: integer;
 b : boolean;
 a: integer;
begin;
 assign(f,doorfilepath+'info.bbs');
 writeln('Opening file "info.bbs"');
 {$I-}
 reset(f);
 {$I+}
 if ioresult<>0 then dderror('Error in opening "info.bbs"');
 readln(f,s);
 b:=false;
 user_first_name:='';
 user_last_name:='';
 for a:=1 to 25 do if (pcbsys.name[a]=' ') or (pcbsys.name[a]=#0) then b:=true else if b=false then
  user_first_name:=user_first_name+pcbsys.name[a] else user_last_name:=user_last_name+pcbsys.name[a];
 readln(f,s); val(s,i,code); baud_rate:=i;
 readln(f,s); val(s,i,code); com_port:=i;
 readln(f,s); val(s,i,code); user_access_level:=i;
 readln(f,s); s:=stu(s); if s='TRUE' then local:=true else local:=false;
 readln(f,s);
 readln(f,s); val(s,i,code); bbs_time_left:=i;
 readln(f,s);
 if s='TRUE' then graphics:=3 else graphics:=1;
 if s='TRUE' then color_chg:=true else color_chg:=false;
 readln(f,s);
 close(f);
end;

procedure load_WWIV;
var
 a: integer;
 b: boolean;
 f : text;
 ss,s : string;
 code,i: integer;
 sint: word;
begin;
 assign(f,doorfilepath+'chain.txt');
 writeln('Opening file "Chain.txt"');
 {$I-}
 reset(f);
 {$I+}
 if ioresult<>0 then dderror('Error in opening "Chain.txt"');
 readln(f,s);
 readln(f,s);
 user_first_name:='';
 user_last_name:='';
 b:=false;
 for a:=1 to length(s) do if s[a]=' ' then b:=true else if b then
  user_last_name:=user_last_name+s[a] else user_first_name:=user_first_name+s[a];
 for i:=1 to 9 do begin;
  readln(f,s);
 end;
 val(s,sint,code);
 user_access_level:=sint;
 readln(f,s);
 readln(f,s);
 readln(f,s);
 if s<>'0' then begin graphics:=3;color_chg:=true; end else begin;
  graphics:=1;
  color_chg:=false;
 end;
 readln(f,s);
 if s<>'0' then local:=false else local:=true;
 readln(f,s);
 while (s<>'') and (s[1]=' ') do delete(s,1,1);
 delete(s,length(s)-3,3);
 val(s,sint,code);
 bbs_time_left:=sint div 60;
 readln(f,s);
 readln(f,s);
 readln(f,s);
 readln(f,s);
 val(s,sint,code);
 baud_rate:=sint;
 readln(f,s);
 val(s,sint,code);
 com_port:=sint;
 readln(f,s);
 board_name:=s;
 readln(f,s);
 sysop_first_name:='';
 sysop_last_name:='';
 b:=false;
 for a:=1 to length(s) do if s[a]=' ' then b:=true else if b then
   sysop_last_name:=sysop_last_name+s[a] else sysop_first_name:=sysop_first_name+s[a];
 close(f);
end;

procedure load_WildCat;
var
 f : text;
 s : string;
 code,i: integer;
 sint: word;
 a: integer;
 b: boolean;
begin;
 assign(f,doorfilepath+'callinfo.bbs');
 writeln('Opening file "Callinfo.bbs".');
 {$I-}
 reset(f);
 {$I+}
 if ioresult<>0 then dderror('Error in opening "Callinfo.bbs"');
 readln(f,s);
 user_first_name:='';
 user_last_name:='';
 b:=false;
 for a:=1 to length(s) do if s[a]=' ' then b:=true else if b then
  user_last_name:=user_last_name+s[a] else user_first_name:=user_first_name+s[a];
 readln(f,s);
 readln(f,s);
 readln(f,s);
 val(s,sint,code);
 user_access_level:=sint;
 readln(f,s);
 val(s,sint,code);
 bbs_time_left:=sint;
 readln(f,s);
 if stu(s)='COLOR' then begin;
  graphics:=3;
  color_chg:=true;
 end else begin;
  graphics:=1;
  color_chg:=false;
 end;
 for i:=1 to 22 do readln(f,s);
 if stu(s)='REMOTE' then local:=false else local:=true;
 readln(f,s);
 val(s[4],sint,code);
 com_port:=sint;
 readln(f,s);
 readln(f,s);
 val(s,sint,code);
 baud_rate:=sint;
 close(f);
end;

procedure load_doorsys;
var
 b: boolean;
 a: integer;
 f: text;
 s: string;
begin;
 writeln('Opening "DOOR.SYS".');
 assign(f,doorfilepath+'DOOR.SYS');
 {$I-}
 reset(F);
 {$I+}
 if ioresult<>0 then dderror('Cannot load DOOR.SYS');

 readln(f,s); {Com Port}
 delete(s,1,3);
 delete(s,2,1);
 val(s,com_port,a);
 if com_port=0 then local:=true else local:=false;

 readln(f,s); {baud rate}
 readln(f,s); {dbits}
 readln(f,s); {node num}

 readln(f,s); {actual bbs}
 val(s,baud_rate,a);

 readln(f,s); {screen on}
 readln(f,s); {printer}
 readln(f,s); {page bell}
 readln(f,s); {caller bell}

 readln(f,s); {user name}
 s:=stu(s);
 b:=false;
 user_first_name:='';
 user_last_name:='';
 for a:=1 to length(s) do if s[a]=' ' then b:=true else if b then
  user_last_name:=user_last_name+upcase(s[a]) else user_first_name:=user_first_name+upcase(s[a]);

 readln(f,s); {city,state}
 readln(f,s); {home phone}
 readln(f,s); {work phone}
 readln(f,s); {password}

 readln(f,s); {security}
 val(s,user_access_level,a);

 readln(f,s); {times on}
 readln(f,s); {last called}
 readln(f,s); {secs left}

 readln(f,s); {time left}
 val(s,bbs_time_left,a);

 readln(f,s); {graphics code}
 if s='GR' then graphics:=3 else graphics:=1;

 close(f);
end;

procedure load_spitfire;
var
 b: boolean;
 a: integer;
 f: text;
 s: string;
begin;
 writeln('Opening "SFDOORS.DAT".');
 assign(f,doorfilepath+'SFDOORS.DAT');
 {$I-}
 reset(F);
 {$I+}
 if ioresult<>0 then dderror('Cannot load SFDOORS.DAT');

 readln(f,s);
 readln(f,s); {name}
 s:=stu(s);
 b:=false;
 user_first_name:='';
 user_last_name:='';
 for a:=1 to length(s) do if s[a]=' ' then b:=true else if b then
  user_last_name:=user_last_name+upcase(s[a]) else user_first_name:=user_first_name+upcase(s[a]);

 readln(f,s);
 readln(f,s);
 readln(f,s); {baud}
 val(s,baud_rate,a);
 if baud_rate=0 then local:=true else local:=false;

 readln(f,s); {cport}
 val(s,com_port,a);
 if com_port=0 then local:=true else local:=false;

 readln(f,s); {time left}
 val(s,bbs_time_left,a);

 readln(f,s);
 readln(f,s);
 readln(f,s); {ansi}
 if stu(s)='TRUE' then graphics:=3 else graphics:=1;

 readln(f,s); {sec}
 val(s,user_access_level,a);

 close(f);
end;

procedure Load_2am;
var
 f: text;
 s,s2: string;
 a: integer;
begin;
 local:=false;
 user_access_level:=0;
 writeln('Opening JUMPER.DAT');
 assign(f,DOORFILEPATH+'JUMPER.DAT');
 {$I-}
 reset(F);
 {$I+}
 if ioresult<>0 then dderror('Cannot open JUMPER.DAT');
 readln(f,s);
 readln(f,s);
 readln(f,s);
 readln(f,s);

 readln(f,s);
 user_first_name:=s;
 readln(f,s);
 user_last_name:=s;

 readln(f,s);

 readln(f,s);
 val(s,bbs_time_left,a);
 readln(f,s);
 val(s,com_port,a);
 if com_port=0 then local:=true;
 readln(f,s);
 val(s,baud_rate,a);
 if baud_rate=0 then local:=true;

 readln(f,s);
 readln(f,s);
 readln(f,s);
 readln(f,s);

 readln(f,s);
 readln(f,s2);
 graphics:=1;
 if (s='TRUE') and (s2='FALSE') then graphics:=2;
 if (s2='TRUE') then graphics:=3;
 close(f);
end;

procedure load_maint;
begin;
 local:=true;
 user_first_name:='SYSTEM';
 user_last_name:='MAINT';
 bbs_time_left:=120;
 graphics:=3;
end;

procedure load_local;
var
 a,b: integer;
 d: boolean;
 s: string;
begin;
 val(paramstr(1),a,b);
 if a>0 then node_num:=a;
 local:=true;
 writeln;
 writeln('                         Ŀ');
 writeln('          Local Logon          ');
 writeln('                         ');
 writeln;
 writeln('Please enter your name below (or leave blank for '+sysop_first_name+' '+sysop_last_name+'):');
 write('>');
 readln(s);
 if s='' then begin;
  user_first_name:=stu(sysop_first_name);
  user_last_name:=stu(sysop_last_name);
 end else begin;
  user_first_name:='';
  user_last_name:='';
  d:=false;
  for a:=1 to length(s) do if s[a]=' ' then d:=true else if d=false then
   user_first_name:=user_first_name+upcase(s[a])
  else
   user_last_name:=user_last_name+upcase(s[a]);
  if user_last_name='' then begin;
   writeln('Please enter your last name:');
   write('>');
   readln(user_last_name);
   user_last_name:=stu(user_last_name);
  end;
 end;
 graphics:=3;
 bbs_time_left:=120;
 user_access_level:=255;
end;

procedure load_sysop;
begin;
 user_first_name:=stu(sysop_first_name);
 user_last_name:=stu(sysop_last_name);
 writeln;
 writeln('                         Ŀ');
 writeln('        Sysop Fast Logon       ');
 writeln('                         ');
 writeln;
 writeln('Assuming user name of : ',user_first_name,' ',user_last_name);
 graphics:=3;
 bbs_time_left:=120;
 user_access_level:=255;
end;

begin;
 baud_rate:=0;
 com_port:=0;
 if bbstype=0 then load_maint;
 if bbstype=1 then load_local;
 if bbstype=2 then load_sysop;
 if bbstype=3 then load_rbbs16;
 if bbstype=4 then load_pcboard;
 if bbstype=5 then load_WWIV;
 if bbstype=7 then load_rbbs16;
 if bbstype=8 then load_phnx;
 if bbstype=9 then load_WildCat;
 if bbstype=10 then load_pcboard14;
 if bbstype=11 then load_doorsys;
 if bbstype=12 then load_spitfire;
 if bbstype=13 then load_2am;
 user_first_name:=stu(user_first_name);
 user_last_name:=stu(user_last_name);
 if node_num=0 then node_num:=1;
 if graphics>=3 then color_chg:=true else color_chg:=false;
 if bbs_time_left>maxtime then bbs_time_left:=maxtime;
end;

procedure DisplayInfo(
 bbstype: word;
 var user_first_name,user_last_name: string;
 var user_access_level: word;
 var bbs_time_left: integer;
 var com_port: byte;
 var baud_rate: word;
 var node_num: byte;
 var local: boolean;
 var graphics: byte;
 var color1: boolean;
 var color_chg: boolean;
 var board_name: string;
 var sysop_first_name: string;
 var sysop_last_name: string;
 var maxtime: word;
 var doorfilepath: string;
 var lockbaud: word);

const
 software_names: array[0..13] of string[15]=
  ('Maint',     'Local',      'Sysop',      'QBBS',       'PCBoard 12',
   'WWIV',      'n/a',        'RBBS 16+',   'Phoenix',    'Wildcat',
   'PCBoard 14','DOORSYS',    'Spitfire',   '2am-bbs');
 drop_files: array[0..13] of string[15]=
  ('n/a',        'n/a',         'n/a',         'DORINFOx.DEF',
   'PCBOARD.SYS','CHAIN.TXT',   '',            'DORINFOx.DEF',
   'INFO.BBS',   'CALLINFO.BBS','PCBOARD.SYS', 'DOOR.SYS',
   'SFDOORS.DAT','JUMPER.DAT');
var
 s: string;
 a: integer;
begin
 writeln;
 writeln('                      ĿĿ');
 writeln('  Credits (Credit is due!)   Current System Information ');
 writeln('                                            ');
 writeln('        Pascal/ASM');
 writeln('         Routines:             Baud rate: ',baud_rate);
 writeln(' Fossil - Chris Woodward       Local: ',local);
 writeln(' ANSI - Scott Baker            Graphics: ',graphics);
 writeln('           Derrick Parkhurst   Time left: ',bbs_time_left);
 writeln(' SimpleDoOr - Herb Gilliland   Com Port: ',com_port);
 writeln(' Docs - Herb Gilliland         User: ',user_first_name,' ',user_last_name);
 writeln(' BBS data file - Scott Baker   Access level: ',user_access_level);
 writeln(' Revised .CTL file format -    Node number: ',node_num);
   write('     Herb Gilliland            Locked Baud: ');
 if lockbaud=0 then writeln('Not Locked') else writeln(lockbaud);
 writeln;
 writeln('Software....: ',software_names[bbstype]);
 s:=drop_files[bbstype];
 for a:=1 to length(s) do if s[a]='x' then s[a]:=chr(node_num+ord('0'));
 writeln('Drop file...: ',s);
 writeln('Drop Path...: ',doorfilepath);
 writeln;
 delay(250);
end;

function wva(w: word): string;
var
 s: string;
begin;
 str(w,s);
 wva:=s;
end;

procedure stuffstr(n: word; s: string);
begin;
 getmem(ddovrinfo[n],length(s)+1);
 move(s,ddovrinfo[n]^,length(s)+1);
end;

procedure MakeInfoStrings(
 bbstype: word;
 var user_first_name,user_last_name: string;
 var user_access_level: word;
 var bbs_time_left: integer;
 var com_port: byte;
 var baud_rate: word;
 var node_num: byte;
 var local: boolean;
 var graphics: byte;
 var color1: boolean;
 var color_chg: boolean;
 var board_name: string;
 var sysop_first_name: string;
 var sysop_last_name: string;
 var maxtime: word;
 var doorfilepath: string;
 var lockbaud: word);

const
 software_names: array[0..13] of string[15]=
  ('Maint',     'Local',      'Sysop',      'QBBS',       'PCBoard 12',
   'WWIV',      'n/a',        'RBBS 16+',   'Phoenix',    'Wildcat',
   'PCBoard 14','DOORSYS',    'Spitfire',   '2am-bbs');
 drop_files: array[0..13] of string[15]=
  ('n/a',        'n/a',         'n/a',         'DORINFOx.DEF',
   'PCBOARD.SYS','CHAIN.TXT',   '',            'DORINFOx.DEF',
   'INFO.BBS',   'CALLINFO.BBS','PCBOARD.SYS', 'DOOR.SYS',
   'SFDOORS.DAT','JUMPER.DAT');
 istrue: array[false..true] of string[8] = ('FALSE','TRUE');
var
 s: string;
 a: integer;
begin;
 stuffstr( 1,'Baud rate: '+wva(baud_rate));
 stuffstr( 2,'    Local: '+istrue[local]);
 stuffstr( 3,' Graphics: '+wva(graphics));
 stuffstr( 4,'Time left: '+wva(bbs_time_left));
 stuffstr( 5,' Com Port: '+wva(com_port));
 stuffstr( 6,'     User: '+user_first_name+' '+user_last_name);
 stuffstr( 7,'Access lv: '+wva(user_access_level));
 stuffstr( 8,' Node num: '+wva(node_num));
 if lockbaud=0 then s:='Not Locked' else s:=wva(lockbaud);
 stuffstr( 9,'Lock Baud: '+s);
 stuffstr( 10,' Software: '+software_names[bbstype]);
 s:=drop_files[bbstype];
 for a:=1 to length(s) do if s[a]='x' then s[a]:=chr(node_num+ord('0'));
 stuffstr(11,'Drop file: '+s);
 stuffstr(12,'Drop Path: '+doorfilepath);
end;

procedure ShowHelp;
begin;
 clrscr;
 writeln('                                     Ŀ');
 writeln(' SimpleDoOr Command Parameters Help Info ');
 writeln('                                     ');
 writeln;
 writeln('This door has been compiled using the SimpleDoOr door support kit. ');
 writeln('SimpleDoOr defines the following command line options:');
 writeln;
 writeln('/L - Local mode');
 writeln('/M - Maintenance');
 writeln('/S - Sysop Fast-Logon');
 writeln;
 writeln('Switches:');
 writeln;
 writeln('/Bxxx - Specify locked baud rate (i.e. /B38400)');
 writeln('/Nx   - Specify node number');
 writeln('/Pyyy - Specify path to drop file (i.e. /Pc:\bbs');
 writeln;
 halt;
end;

end.
