unit sdovr2;

{$F+,O+,V-}

interface

uses crt;

procedure Loadconfig(
 fn: string;
 var bbs_software: byte;
 var user_first_name,user_last_name: string;
 var user_access_level: word;
 var bbs_time_left: integer;
 var com_port: byte;
 var baud_rate: word;
 var node_num: byte;
 var local: boolean;
 var graphics: byte;
 var color1: boolean;
 var color_chg: boolean;
 var board_name: string;
 var sysop_first_name: string;
var sysop_last_name: string;
 var maxtime: word;
 var quiet: boolean;
 var localcol: boolean;
 var statfore: byte;
 var statback: byte;
 var statline: boolean;
 var line43: boolean;
 var fossilio: boolean;
 var doorfilepath: string;
 var lockbaud: word;
 var nodirect: boolean);

var
 ddcfgp1,ddcfgp2,ddcfgps: string[80];
const
 DDUserConfigPtr: pointer = nil;

implementation

type
 iomodetypes=(sysop,localu,maint,remote);
var
 iomode: iomodetypes;

{$F+}
Procedure CallProc;
inline($FF/$1E/DDUserConfigPtr);
{$F-}

procedure Loadconfig(
 fn: string;
 var bbs_software: byte;
 var user_first_name,user_last_name: string;
 var user_access_level: word;
 var bbs_time_left: integer;
 var com_port: byte;
 var baud_rate: word;
 var node_num: byte;
 var local: boolean;
 var graphics: byte;
 var color1: boolean;
 var color_chg: boolean;
 var board_name: string;
 var sysop_first_name: string;
 var sysop_last_name: string;
 var maxtime: word;
 var quiet: boolean;
 var localcol: boolean;
 var statfore: byte;
 var statback: byte;
 var statline: boolean;
 var line43: boolean;
 var fossilio: boolean;
 var doorfilepath: string;
 var lockbaud: word;
 var nodirect: boolean);

function getparam(s: string; n: integer): string;
var
 a: integer;
 s2: string;
begin;
 while (length(s)>0) and (s[1]=' ') do delete(s,1,1);
 if n<>1 then begin;
  while (length(s)>0) and (s[1]<>' ') do delete(s,1,1);
  while (length(s)>0) and (s[1]=' ') do delete(s,1,1);
 end;
 if n=3 then begin;
  while (length(s)>0) and (s[1]<>' ') do delete(s,1,1);
  while (length(s)>0) and (s[1]=' ') do delete(s,1,1);
 end;
 while (pos(' ',s)<>0) do begin;
  a:=1;
  s2:='';
  while s[a]<>' ' do begin;
   s2:=s2+upcase(s[a]);
   a:=a+1;
  end;
  s:=s2;
 end;
 while (length(s)>0) and (s[length(s)]=' ') do delete(s,length(s),1);
 for a:=1 to length(s) do s[a]:=upcase(s[a]);
 getparam:=s;
end;

function getsecond(s: string): string;
var
 a: integer;
 s2: string;
begin;
 while (length(s)>0) and (s[1]=' ') do delete(s,1,1);
 while (length(s)>0) and (s[1]<>' ') do delete(s,1,1);
 while (length(s)>0) and (s[1]=' ') do delete(s,1,1);
 while (length(s)>0) and (s[length(s)]=' ') do delete(s,length(s),1);
 getsecond:=s;
end;

function numparams(s: string): integer;
var
 i: integer;
begin;
 i:=0;
 numparams:=0;
 if length(s)=0 then exit;
 if s[1]=';' then exit;
 if s[2]=';' then exit;
 if getparam(s,1)<>'' then inc(i);
 if getparam(s,2)<>'' then inc(i);
 if getparam(s,3)<>'' then inc(i);
 numparams:=i;
end;

procedure DDError(s: string);
begin;
 write(^G);
 writeln('ERROR: '+s);
 write(^G);
 delay(500);
end;

procedure BadParam(s: string);
begin;
 dderror('Invalid parameter - '+s);
 halt;
end;

procedure processcmdline;
var
 a,b: integer;
 s,s2: string;
begin;
 iomode:=remote;
 doorfilepath:='';
 for a:=1 to paramcount do begin;
  s:=paramstr(a);
  for b:=1 to length(s) do s[b]:=upcase(s[b]);
  if (s[1]='/') and (length(s)>1) then begin;
   delete(s,1,1);
   s2:=s;
   delete(s2,1,1);
   case s[1] of
    'M': iomode:=maint;
    'L': iomode:=localu;
    'S': iomode:=sysop;
    'N': val(s2,node_num,b);
    'P': begin;
          if s2[length(s2)]<>'\' then s2:=s2+'\';
          doorfilepath:=s2;
         end;
    'B': val(s2,lockbaud,b);
   end;
  end;
 end;
end;

var
 s: string;
 f: text;
 a,b,c: integer;
 ps,p1,p2,p3: string[80];
 ofm: word;
begin;
 maxtime:=999;
 quiet:=false;
 localcol:=true;
 com_port:=0;
 sysop_first_name:='Joe';
 sysop_last_name:='Sysop';
 board_name:='Some BBS';
 bbs_software:=1;
 com_port:=1;
 statfore:=0;
 statback:=7;
 statline:=true;
 nodirect:=false;
 color1:=false;
 line43:=false;
 fossilio:=true;
 lockbaud:=0;

 ofm:=filemode;
 filemode:=64;
 assign(f,fn);
 {$i-}
 reset(f);
 {$I+}
 if ioresult<>0 then dderror('Configuration file, '+fn+', is missing!') else
 begin
 while not eof(f) do begin;
  readln(f,s);
  if numparams(s)>0 then begin;
   p1:=getparam(s,1);
   p2:=getparam(s,2);
   p3:=getparam(s,3);
   ps:=getsecond(s);
   if p1='NODIRECT' then nodirect:=true else
   if p1='PATH' then doorfilepath := p2 else
   if p1='QUIET' then Quiet:=true else
   if p1='PORT' then val(p2,com_port,a) else
   if p1='LOCALCOLOR' then localcol:=true else
   if p1='MONOCHROME' then localcol:=false else
   if p1='SYSOPFIRST' then sysop_first_name:=ps else
   if p1='SYSOPLAST' then sysop_last_name:=ps else
   if p1='BBSNAME' then board_name:=ps else
   if p1='BBSTYPE' then begin;
    if p2='LOCAL' then bbs_software:=1;
    if p2='SYSOP' then bbs_software:=2;
    if p2='PCB14' then bbs_software:=10 else
    if p2='PCB12' then bbs_software:=4 else
    if p2='WWIV' then bbs_software:=5 else
    if p2='QUICK' then bbs_software:=7 else
    if p2='RBBS' then bbs_software:=7 else
    if p2='PHOENIX' then bbs_software:=8 else
    if p2='WILDCAT' then bbs_software:=9 else
    if p2='DOORSYS' then bbs_software:=11 else
    if p2='SPITFIRE' then bbs_software:=12 else
    if p2='2AM' then bbs_software:=13 else
     badparam(s);
   end else
   if p1='STATUSLINE' then begin;
    if p2='OFF' then statline:=false else
    if p2='ON' then statline:=true else
     badparam(s);
   end else
   if p1='MAXTIME' then val(p2,maxtime,a) else
   if p1='INTERNAL' then fossilio:=false else
   if p1='STATFORE' then val(p2,statfore,a) else
   if p1='STATBACK' then val(p2,statback,a) else
   if p1='COLOR1' then color1:=true else
   if p1='43LINE' then line43:=true else
   if p1='COMPORT' then val(p2,com_port,a) else
   if p1='LOCKBAUD' then val(p2,lockbaud,a) else
   begin;
    ddcfgp1:=p1;
    ddcfgp2:=p2;
    ddcfgps:=ps;
    if dduserconfigptr<>nil then callproc;
   end;

  end;
 end;
 close(f);
 end;
 filemode:=ofm;

 processcmdline;
 case iomode of
  remote: ;
  maint: bbs_software:=0;
  localu: bbs_software:=1;
  sysop: bbs_software:=2;
 end;
end;

end.
