unit simple;
{$V-}

interface
uses dos, crt, comio, extras, ansiface, sdovr,sdovr2;

type
 CharOriginType=(localchar,remotechar);
 strptr=^string;
const
 version= 'Version 2.0b - 3/3/93';
 graphics_codes: array[1..4] of string[4] = ('','.ASC','.ANS','.MUS');
 ack=#6;
 nak=#21;
 sot=#1;
var
 statusline: string;
 mintime: byte;                     {Minimum time left before user kicked off}
 PauseStr : String;                 {Pause String                            }
 PauseAnim : String;                {Pause String Animation                  }
 PauseDelay : Byte;                 {Pause Delay Timer                       }
 notime: string;                    {Out of time filename                    }
 node: byte;                        {Node number                             }
 time_credit: integer;              {Time credit +/- (arrow keys)            }
 CharOrigin: CharOrigInType;        {Where character came from               }
 fouled_up: char;                   {Internal use                            }
 localcol: boolean;                 {From .CTL file: Local color enabled     }
 ansi: boolean;                     {Process ANSI locally                    }
 time_check: boolean;               {Check time left - halt if < mintime     }
 curlinenum: integer;               {current line num - used by <more>       }
 more: boolean;                     {display <more> prompt?                  }
 CurFore: byte;                     {current foreground color                }
 CurBack: byte;                     {current background color                }
 color_chg: boolean;                {send ANSI color change sequences?       }
 default_fore: integer;             {default foreground color                }
 default_back: integer;             {default background color                }
 cdropped: boolean;                 {carrier dropped?                        }
 bbs_time_left: integer;            {from DROP FILE: time left               }
 com_port: byte;                    {from DROP FILE: com port                }
 bbs_software: byte;                {from .CTL file: bbs type                }
 baud_rate: word;                   {from DROP FILE: baud rate               }
 statfore,statback: byte;           {status line foreground                  }
 statline: boolean;                 {status line background                  }
 graphics: byte;                    {from DROP FILE: graphics code           }
 local: boolean;                    {from DROP FILE: local mode              }
 USER_ACS: word;                    {from DROP FILE: user's access level     }
 User_first: string[30];            {from DROP FILE: user's first name       }
 user_last: string[30];             {from DROP FILE: user's last name        }
 sysop_first: string[30];           {from .CTL file: sysop's first name      }
 sysop_last: string[30];            {from .CTL file: sysop's last name       }
 board_name: string[70];            {from .CTL file: board name              }
 st_hr, st_mn, st_sc: word;         {used by timer calculations              }
 quiet: boolean;                    {from .CTL file: quiet mode              }
 color1: boolean;                   {from .CTL file: color1 mode             }
 line43: boolean;                   {from .CTL file: 43 line mode            }
 badchar: string;                   {internal use                            }
 fossilIO: boolean;                 {from .CTL file: fossil I/O used         }
 maxtime: word;                     {from .CTL file: maximum time in door    }
 numlines: byte;                    {from .CTL file: number of lines/screen  }
 oldtextmode: word;                 {original text mode                      }
 lastsetfore: byte;                 {last set_foreground color               }
 setforecheck: boolean;             {check repetetive set_foreground calls?  }
 doorfilepath: string;              {from .CTL file: door file path          }
 proc_call_ptr: pointer;            {used internally                         }
 altkeys: array['A'..'Z'] of pointer;
 althelp: array['A'..'Z'] of strptr;
 nodirect: boolean;
 lockbaud: word;

procedure close_async_port;
procedure open_async_port;
function skeypressed: boolean;
Procedure Colorwrite(s : string);
procedure sendtext(s: string);
Function DS(S : String; I : Byte) : String;
procedure sgoto_xy(x,y: integer);
procedure sclrscr;
procedure pause;
procedure Cwrite(S : String);
procedure CWriteln(S : String);
procedure sclreol;
procedure swrite(s: string);
procedure swriteln(s: string);
procedure rch(var c: char);
procedure sread(var s: string);
procedure rint(var n: integer);
procedure rword(var n: word);
procedure rlong(var n: longint);
function time_left: integer;
procedure fore(f: integer);
function va2(s:string):integer;
procedure back(b: integer);
procedure color(fgc,bgc:byte);
procedure prompt(var s: string; le: integer; pc: boolean);
procedure df(f : string);
Procedure elapsed(time1_hour, time1_min, time1_sec, time2_hour, time2_min,
                  time2_sec: longint; var elap_hour, elap_min, elap_sec: word);
procedure sreadf(var ch: char);
procedure InitDoor(ConfigFileName: string);
function Time_used: integer;

Implementation

var
 buffered: boolean;
 exitsave: pointer;
 tcolor,bcolor: integer;
 firsttime: boolean;

procedure textcolor(i: integer);
begin;
 if localcol then crt.textcolor(i);
 tcolor:=i;
end;

procedure textbackground(i: integer);
begin;
 if localcol then crt.textbackground(i);
 bcolor:=i;
end;

procedure elapsed(time1_hour, time1_min, time1_sec, time2_hour, time2_min,
                  time2_sec: longint; var elap_hour, elap_min, elap_sec: word);
var
 a,b,c: longint;
begin;
 if time1_hour<time2_hour then time1_hour:=time1_hour+24;
 a:=(time1_hour*3600)+(time1_min*60)+time1_sec;
 b:=(time2_hour*3600)+(time2_min*60)+time2_sec;
 c:=a-b;
 if c>=3600 then elap_hour:=c div 3600 else elap_hour:=0;
 c:=c-((c div 3600)*3600);
 if c>=60 then elap_min:=c div 60 else elap_min:=0;
 c:=c-((c div 60)*60);
 elap_sec:=c;
end;

function time_left: integer;
var
 hour, minute, second, sec100: word;
 el_hr, el_mn, el_sc: word;
begin;
 time_left := BBS_Time_Left-Time_Used;
end;

function time_used: integer;
var
 hour, minute, second, sec100: word;
 el_hr, el_mn, el_sc: word;
begin;
 gettime(hour, minute, second, sec100);
 elapsed(hour, minute, second, st_hr, st_mn, st_sc, el_hr, el_mn, el_sc);
 time_used:=(el_hr*60)+el_mn;
end;

procedure display_status;
var

 a,b: integer;
 c,d: word;
 x,y: integer;
 hour, minute, second, sec100, el_mn, el_hr, el_sc: word;
begin;
 x:=wherex;
 y:=wherey;
 cursoroff;
 window(1,numlines,80,numlines);
 a:=tcolor;
 b:=bcolor;
 gotoxy(1,numlines);
{ clreol;}
 colorwrite(statusline);
 window(1,1,80,numlines);
 if (time_left<mintime) and (time_check) then begin;
  cursoron;
  if notime<>'' then df(notime) else cwriteln('[Out of Time]');
  swriteln('');
  halt;
 end;
 textcolor(a);
 textbackground(b);
 window(1,1,80,numlines-1);
 gotoxy(x,y);
 cursoron;
end;

FUNCTION showtime : String;
VAR
  Hour,
  Minute,
  Second,
  Sec100  : Word;
  Temp    : String;
  CurTime : String;
BEGIN
  GetTime( Hour, Minute, Second, Sec100 );
  If Hour > 12 then Str( (Hour-12), Temp ) else Str( Hour, Temp );
  If Hour < 10 then Temp := ' '+temp;
  Curtime := Temp;
  Str( Minute, Temp );
  if minute < 10 then temp := '0'+temp;
  CurTime := CurTime+':'+Temp;
  Str( Second, Temp );
  if second < 10 then temp := '0'+temp;
  CurTime := Curtime+':'+Temp;
  If Hour > 11 then CurTime := CurTime + ' pm' else Curtime := CurTime + ' am';
  showTime := CurTime;
END;

FUNCTION showDate : String;
CONST
  Months  : Array[1..12] of String[9] =
    ('Jan','Feb','Mar','Apr','May','June',
     'July','Aug','Sept','Oct','Nov','Dec');
  Days    : Array[0..6] of String[9] =
    ('Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday');
VAR
  Year,
  Month,
  Day,
  DayofWeek : Word;
  Temp      : String;
  CurDate   : String;
BEGIN
  GetDate( Year, Month, Day, DayofWeek );
  CurDate := Days[DayOfWeek];
  Str( Day, Temp );
  CurDate := CurDate + ' ' + Months[Month] + ' ' + Temp;
  Year := Year;
  Str( Year, Temp );
  CurDate := CurDate + ', ' + Temp;
  showDate := CurDate;
END;

Procedure Colorwrite(s : string);
Var X : Byte;
Begin
 if s <> '' then begin
  X := 1;
  While X <= Length(s) do Begin
   If S[X] = '^' then Begin
    Inc(X);
    If S[X] in ['0','1','2','3','4','5','6','7','8','9'] then TextColor(Va2(S[X])) else Begin
      Case S[X] of
       'A':TextColor(10);
       'B':TextColor(11);
       'C':textcolor(12);
       'D':textcolor(13);
       'E':textcolor(14);
       'F':textcolor(15);
       'T':write(showtime);
       'D':write(showdate);
       'L':write(time_left);
       '?':textcolor(Random(15)+1);
      End;
     End;
     Inc(X);
    End Else If S[X] = '~' then
     Begin
      Inc(X);
      If S[X] in ['0','1','2','3','4','5','6','7'] then TextBackground(Va2(S[X]));
      Inc(X);
     End
   Else begin
    write(S[X]);
    Inc(X);
   End;
  End;
 End;
End;

procedure SendText(s: string);
var
 a: integer;
begin;
 for a:=1 to length(s) do AsyncSendChar(s[a]);
end;

procedure CharOut(ch: char);
begin;
 AsyncSendChar(ch);
end;

function charin(var ch: char): boolean;
begin;
 if badchar<>'' then begin;
  ch:=badchar[1];
  delete(badchar,1,1);
  charin:=true;
 end else if AsyncCharPresent then begin;
  AsyncReceiveChar(ch);
  charin:=true;
 end else charin:=false;
end;

procedure done;
begin;
 if (not local) and (buffered) then begin;
  AsyncFlushOutput;
  writeln('De-initializing fossil.');
  AsyncCloseUp;
 end;
end;

procedure sclrscr;
begin;
 if not local then CharOut(#12);
 clrscr;
 curlinenum:=1;
 lastsetfore:=99;
end;

procedure sclreol;
begin;
 if not local then sendtext(#27'[K');
 clreol;
end;

procedure swrite(s: string);
var
 a: integer;
 s2: string;
begin;
 if statline then display_status;
 if hexon then hexfilt(s);
 if not local then sendtext(s);
 if quiet then begin;
  s2:='';
  for a:=1 to length(s) do if s[a]<>^g then s2:=s2+s[a];
  s:=s2;
 end;
 if ansi then begin;
  ansi_write_str(s);
 end else write(s);
end;

procedure swriteln(s: string);
var
 a: integer;
 s2: string;
begin;
 if hexon then hexfilt(s);
 if not local then sendtext(s+#13+#10);
 if quiet then begin;
  s2:='';
  for a:=1 to length(s) do if s[a]<>^g then s2:=s2+s[a];
  s:=s2;
 end;
 if ansi then begin;
  s:=s+#13+#10;
  ansi_write_str(s);
 end else writeln(s);
 inc(curlinenum);
 if (curlinenum=24) then begin;
  curlinenum:=1;
  if more then pause;
 end;
end;

Procedure Cwrite(s : string);
Var X : Byte;
Begin
 if s <> '' then begin
  X := 1;
  While X <= Length(s) do Begin
   If S[X] = '^' then Begin
    Inc(X);
    If S[X] in ['0','1','2','3','4','5','6','7','8','9'] then Fore(Va2(S[X])) else Begin
      Case S[X] of
       'A':Fore(10);
       'B':Fore(11);
       'C':Fore(12);
       'D':Fore(13);
       'E':Fore(14);
       'F':Fore(15);
       '?':Fore(Random(15)+1);
      End;
     End;
     Inc(X);
    End Else If S[X] = '~' then
     Begin
      Inc(X);
      If S[X] in ['0','1','2','3','4','5','6','7'] then Back(Va2(S[X]));
      Inc(X);
     End
   Else begin
    Swrite(S[X]);
    Inc(X);
   End;
  End;
 End;
End;

Procedure CWRITELN;
Begin
 Cwrite(S);
 Swriteln('');
End;

Procedure Pause;
Var X, YZ, ZY : Byte;
    Temp : Char;
Begin
 YZ := CurFore;
 ZY := CurBack;
 Cwrite(PauseStr);
 X := 1;
 Repeat
  Swrite(PauseAnim[X]);
  Swrite(#8);
  Inc(X);
  If X > length(pauseanim) then X := 1;
  delay(PauseDelay);
 Until SKeypressed;
 swrite(' ');
 rch(Temp);
 For X := 1 to Length(PauseStr)*2 do begin
    Swrite(#8+' '+#8);
    Inc(X);
   End;
 Color(YZ, ZY);
End;

{$F+} procedure myexit; {$F-}
begin;
 done;
 if lastmode<>oldtextmode then textmode(oldtextmode);
 cursoron;
 exitproc:=exitsave;
end;

procedure drop_dos;
begin;
 savescreen;
 if not local then AsyncCloseUp;
 swapvectors;
 exec(getenv('COMSPEC'),'');
 swapvectors;
 if not local then AsyncSelectPort(com_port);
 restorescreen;
end;      
{$F+} procedure forced_chat; {$F-}
var
 cx,cy:byte;
 ch: char;
 a: integer;
 old_origin: charorigintype;
 word: string;
 lastspace: integer;
begin;
 swriteln('');
 fore(lightred);
 swriteln('Chat mode enabled. ESC exits.');
 fore(lightblue);
 old_origin:=localchar;
 lastspace:=0;
 word:='';
 repeat;
  rch(ch);
  if charorigin<>old_origin then if charorigin=localchar then fore(lightblue) else fore(yellow);
  old_origin:=charorigin;
  swrite(ch);
  if ch=#8 then begin;
   swrite(' '+#8);
   if length(word)>0 then delete(word,1,1);
  end;
  if ch=#13 then begin;
   swrite(#10);
   lastspace:=0;
   word:='';
  end;
  if (ch<>' ') and (ch<>#8) and (ch<>#13) then word:=word+ch;
  if ch=' ' then begin;
   lastspace:=wherex;
   word:='';
  end;
  if wherex>75 then begin;
   if lastspace=0 then begin;
    swriteln('');
   end else begin;
    while wherex>lastspace do swrite(#8+' '+#8);
    swriteln('');
    swrite(word);
   end;
  end;
 until ch=#27;
 fore(default_fore);
end;

{$F+} procedure showhelp; {$F-}
var
 a: char;
 f,b: integer;
begin;
 swriteln('');
 swriteln('Please stand-by....');
 savescreen;
 clrscr;
 f:=tcolor;
 b:=bcolor;
 textcolor(yellow);
 writeln('             Ŀ');
 writeln(' Hot-Key Help Info ');
 writeln('             ');
 writeln;
 textcolor(lightcyan);
 write('UP-ARR: ');
 textcolor(7);
 writeln('Time limit + 2');
 textcolor(lightcyan);
 write('DN-ARR: ');
 textcolor(7);
 writeln('Time limit - 2');
 for ch:='A' to 'Z' do if althelp[ch]<>nil then begin;
  textcolor(lightcyan);
  write('ALT-',ch,':  ');
  textcolor(7);
  writeln(althelp[ch]^);
 end;
 gotoxy(1,20);
 textcolor(lightgreen);
 write('- Any key to continue -');
 a:=readkey;
 a:=#0;
 tcolor:=f;
 bcolor:=b;
 restorescreen;
end;

{$F+} procedure DropDos; {$F-}
begin;
 swriteln('');
 swriteln('Sysop dropping to Dos, please stand-by....');
 drop_dos;
end;

{$F+} procedure SystemInfo; {$F-}
begin;
 displayInfo(
             bbs_software,
             User_first,user_last,
             USER_ACS,
             bbs_time_left,
             com_port,
             baud_rate,
             node,
             local,
             graphics,
             color1,
             color_chg,
             board_name,
             sysop_first,
             sysop_last,
             maxtime,
             doorfilepath,
             lockbaud);
end;

{$F+}
Procedure CallProc;
inline($FF/$1E/Proc_Call_Ptr);
{$F-}

procedure processaltkeys(var ch: char);
const
 lettermap: string = '123456789012345QWERTYUIOP1234ASDFGHJKL12345ZXCVBMN';
begin;
 if ord(ch)>50 then exit;
 if altkeys[lettermap[ord(ch)]]<>nil then begin;
  proc_call_ptr:=altkeys[lettermap[ord(ch)]];
  callproc;
  ch:=#0;
 end;
end;

procedure SetupAltKeys;
var
 ch: char;
begin;
 for ch:='A' to 'Z' do begin;
  altkeys[ch]:=nil;
  althelp[ch]:=nil;
 end;
 altkeys['I']:=@systeminfo;   new(althelp['I']); althelp['I']^:='System Info';
 altkeys['C']:=@forced_chat;  new(althelp['C']); althelp['C']^:='Forced Chat';
 altkeys['D']:=@DropDos;      new(althelp['D']); althelp['D']^:='Drop To Dos';
 altkeys['H']:=@ShowHelp;     new(althelp['H']); althelp['H']^:='Help';
end;

procedure rch(var c: char);
var
 a: char;
 i,cc: integer;
begin;
 cc:=0;
 a:=chr(0);
 charorigin:=localchar;
 repeat;
  if not local then if not AsyncCarrierPresent then begin;
   writeln('');
   writeln('Carrier Dropped, returning to BBS.');
   cdropped:=true;
   halt;
  end;
  if not local then if charin(a) then charorigin:=remotechar;
  if keypressed then begin;
    a:=readkey;
   if (a=#0) and (keypressed) then begin;
    a:=readkey;
    ProcessAltKeys(a);
    if a=#72 then begin;
     time_credit:=time_credit+2;
     a:=#0;
    end;
    if a=#80 then begin;
     time_credit:=time_credit-2;
     a:=#0;
    end;
   end;
  end;
 until a<>chr(0);
 c:=a;
end;

procedure rchar(var ch: char);
var
 ch1,ch2: char;
begin;
 curlinenum:=1;
 repeat;
  repeat;
   ch:=#0;
   if fouled_up<>#0 then begin;
    ch:=fouled_up;
    fouled_up:=#0;
   end else begin;
    rch(ch1);
    delay(20);
    if (ch1=#27) and skeypressed then begin;
     rch(ch2);
     if ch2='[' then begin;
      rch(ch2);
      if (ch2 in ['1'..'9']) and (skeypressed) then rch(ch2);
      if ch2='A' then ch:=^E;
      if ch2='B' then ch:=^X;
      if ch2='C' then ch:=^D;
      if ch2='D' then ch:=^S;
     end else begin;
      ch:=ch1;
      fouled_up:=ch2;
     end;
    end else ch:=ch1;
   end;
  until ch<>#0;
 until ch<>#1;
end;

procedure sreadf(var ch: char);
begin;
 rch(ch);
 if ch in [#1..#7,#10..#12,#14..#31,#127..#255] then ch:='.';
end;       

procedure sread(var s: string);
var
 ch: char;
 hexsave: boolean;
begin;
 hexsave:=hexon;
 hexon:=false;
 curlinenum:=1;
 s:='';
 if s<>'' then swrite(s) else begin;
  repeat;
   sreadf(ch);
   if (ch<>#8) and (ch<>^M) then begin;
    s:=s+ch;
    swrite(ch);
   end;
   if (ch=chr(8)) and (length(s)>0) then begin;
    delete(s,length(s),1);
    swrite(chr(8)+' '+chr(8));
   end;
  until (ch=^M);
 end;
 swriteln('');
 hexon:=hexsave;
 if hexon then hextodec(s);
end;

Function DS(S : String; I : Byte) : String;
Var TempStr : String[80];
    L : Byte;
Begin
 L := 0;
 TempStr := S;
 If length(TempStr) < I then
      repeat
       TempStr := TempStr + ' ';
      until Length(TempStr)=I;
 If Length(TempStr) > I then Delete(TempStr, I, 255-I);
 DS := TempStr;
end;

procedure rint(var n: integer);
var
 x,y,code: integer;
 s: string;
 ch: char;
begin;
 sread(s);
 val(s,n,x);
end;

procedure rword(var n: word);
var
 x,y,code: integer;
 s: string;
 ch: char;
begin;
 sread(s);
 val(s,n,x);
end;

procedure rlong(var n: longint);
var
 x,y,code: integer;
 s: string;
 ch: char;
begin;
 sread(s);
 val(s,n,x);
end;

function va(i: integer): string;
var
 s: string;
begin;
 str(i,s);
 va:=s;
end;

function va2(s: string): integer;
var
 i,e: integer;
begin;
 val(s,i,e);
 va2:=i;
end;

procedure fore;
const
 colors: array[0..15] of integer = (30,34,32,36,31,35,33,37,130,134,132,136,131,135,133,137);
begin;
 if (not color_chg) then exit;
 if (setforecheck) and (lastsetfore=f) then exit;
 lastsetfore:=f;
 textcolor(f);
 CurFore:=f;
 if not local then begin;
  if colors[f]<100 then sendtext(#27+'[0;'+va(colors[f])+'m');
  if colors[f]>100 then sendtext(#27+'[1;'+va(colors[f]-100)+'m');
 end;
end;

procedure back;
const
 colors: array[0..7] of integer = (40,44,42,46,41,45,43,47);
begin;
 if (not color_chg) then exit;
 if b>8 then b:=b-8;
 textbackground(b);
 CurBack:=b;
 if not local then begin;
  sendtext(#27+'['+va(colors[b])+'m');
 end;
end;

procedure color(fgc,bgc:byte);
const
 colors: array[0..15] of integer = (30,34,32,36,31,35,33,37,130,134,132,136,131,135,133,137);
 colors2: array[0..7] of integer = (40,44,42,46,41,45,43,47);
begin;
 if (not color_chg) then exit;
 textcolor(fgc);
 CurFore:=fgc;
 if bgc>8 then bgc:=bgc-8;
 textbackground(bgc);
 CurBack:=bgc;
 if local then exit;
 if colors[fgc]<100 then sendtext(#27+'[0;'+va(colors[fgc])+';'+va(colors2[bgc])+'m');
 if colors[fgc]>100 then sendtext(#27+'[1;'+va(colors[fgc]-100)+';'+va(colors2[bgc])+'m');
end;

procedure prompt;
const
 promptcol1=7;
 promptcol2=1;
 promptcol3=15;
var
 fg,bg: integer;
 x,y,code: integer;
 ch: char;
 a: integer;
 hexsave: boolean;
begin;
 hexsave:=hexon;
 hexon:=false;
 fg:=CurFore;
 bg:=CurBack;
 if s<>'' then begin;
  fore(promptcol3);
  while length(s)>le do delete(s,length(s),1);
  swrite(s);
  fore(fg);
 end else begin;
  if not color_chg then pc:=false;
  if pc then begin;
   fore(promptcol1);
   back(promptcol2);
   for a:=1 to le do swrite(' ');
   for a:=1 to le do swrite(#8);
   x:=wherex;
   y:=wherey;
  end;
  s:='';
  repeat;
   sreadf(ch);                                 { read(kbd,ch);}
   if (ch<>#8) and (ch<>^M) and (length(s)<le) then begin;
    s:=s+ch;
    swrite(ch);                                    { write(ch);}
   end;
   if length(s)>200 then delete(s,1,1);
   if (ch=chr(8)) and (length(s)>0) then begin;
    delete(s,length(s),1);
    swrite(chr(8));                                { write(#8,' ',#8);}
    swrite(' ');
    swrite(#8);
   end;
  until (ch=^M) or (length(s)=999);
  if pc then begin;
   fore(promptcol3);
   back(bg);
   while wherex>x do swrite(#8);
   swrite(s);                                      { write(s);}
   while wherex<x+le do swrite(' ');               { write(' ');}
   fore(fg);
  end;
  swriteln('');                                    { writeln('');}
 end;
 hexon:=hexsave;
end;

procedure sgoto_xy;
var
 s,s2: string;
begin;
 gotoxy(x,y);
 s:=#27+'[';
 str(y,s2);
 s:=s+s2;
 str(x,s2);
 s:=s+';'+s2+'f';
 if not local then sendtext(s);
end;

function skeypressed: boolean;
var
 b: boolean;
begin;
 if statline then display_status;
 b:=false;
 if not local then b:=AsyncCharPresent;
 if not b then b:=keypressed;
 skeypressed:=b;
end;

function upstring(s : string) : string;
var i : integer;
    t : string;
begin
  i := 1;
  t := s;
  repeat
    t[i] := upcase(s[i]);
    inc(i);
  until i > length(s);
  upstring := t;
end;

Function Exists(f : string) : boolean;
Far;
Var r : file;
begin
  assign(r, f);
  {$I-}
  reset(r);
  close(r);
  {$I+}
  if ioresult <> 0 then exists := false else exists := true;
end;

function yesno(b : boolean) : string;
begin
  if b = true then yesno := 'Yes' else yesno := 'No';
end;


Procedure DF(f : string);
Var r : text;
    s : string;
    li : integer;
    stop, dfmore : boolean;
begin
  if exists(f) then begin
  dfmore := more;
  more := false;
  li := 0;
  Color(7,0);
  stop := false;
     assign(r, f);
     reset(r);
     repeat
      repeat
       readln(r, s);
       cwriteln(s);
       inc(li,1);
       if skeypressed then begin
         stop := true;
         rch(s[1]);
        end;
       if (eof(r)) then stop := true;
      until (stop) or (li > 23);
      if (dfmore) and (not stop) then pause;
      li := 0;
     until stop;
     close(r);
     more := dfmore;
   end;
end;

procedure close_async_port;
begin;
 if buffered then begin;
  buffered:=false;
  AsyncFlushOutput;
  AsyncCloseUp;
 end;
end;

procedure open_async_port;
begin;
 AsyncSelectPort(com_port);
 if lockbaud=0 then
  AsyncSetBaud(baud_rate)
 else
  AsyncSetBaud(lockbaud);
end;

procedure DoTitle;
{type
 titletype = array[1..64000] of char;
 titleptr= ^titletype;
var
 p: titleptr;
 a: word;}
begin;
 swriteln('');
 cwriteln('^9 ^BSimpleDoor Version '+Version);
 cwriteln('^BCopyright 1993 ^3- ^BHerb Gilliland ^3- ^BAll Rights Reserved.');
 cwriteln('^7ANSI-BBS driver routines installed. (C) 1988 by Scott Baker.');
 swriteln('');
end;

var
 nclastchar: char;

{$F+}

function NewCrtOutPut(var f: textrec): integer;
var
 p: integer;
begin;
 for p:=0 to f.bufpos-1 do swrite(f.bufptr^[p]);
 f.bufpos:=0;
 NewCrtOutPut:=0;
end;

function NewCrtInPut(var f: textrec): integer;
var
 p: integer;
 ch: char;
begin;
 with f do begin;
  p:=0;
  if nclastchar=#13 then begin; nclastchar:=' '; end else repeat;
   ch:=readkey;
   nclastchar:=ch;
   write(ch);
   bufptr^[p]:=ch;
   inc(p);
   if ch=#13 then write(#10);
   if ch=#8 then begin;
    write(' '#8);
    if p>0 then dec(p);
    if p>0 then dec(p);
   end;
  until (p=bufsize-1) or (ch=#13);
  bufpos:=0;
  bufend:=p;
 end;
 NewCrtInput:=0;
end;

function NewCrtIgnore(var f: textrec): integer;
begin;
 newcrtignore:=0;
end;

function NewCRTOpen(var f: textrec): integer;
begin;
 if f.mode=fmInput then begin;
  f.inoutfunc:=@NewCrtInput;
  f.flushfunc:=@NewCrtIgnore;
 end else begin;
  f.mode:=fmOutput;
  f.inoutfunc:=@NewCrtOutPut;
  f.flushfunc:=@NewCrtOutPut;
 end;
 NewCrtOpen:=0;
end;

{$F-}

procedure InitDoor(ConfigFileName: string);
Var
 i,a: byte;
 b: integer;
 junk: word;
begin;
 initddansi;
 statusline := 'BBS External';
 pausedelay := 100;
 pausestr := '^7<More>';
 pauseanim := '_ ';
 oldtextmode:=lastmode;
 lastsetfore:=99;
 setforecheck:=false;
 badchar:='';
 ansi:=false;
 numlines:=25;
 clrscr;
 window(1,1,80,numlines-1);
 node:=1;
 fouled_up:=#0;
 hexon:=false;
 buffered:=false;
 cdropped:=false;
 firsttime:=true;
 setupaltkeys;
 loadconfig( ConfigFileName,
             bbs_software,
             User_first,user_last,
             USER_ACS,
             bbs_time_left,
             com_port,
             baud_rate,
             node,
             local,
             graphics,
             color1,
             color_chg,
             board_name,
             sysop_first,
             sysop_last,
             maxtime,
             quiet,
             localcol,
             statfore,
             statback,
             statline,
             line43,
             fossilio,
             doorfilepath,
             lockbaud,
             nodirect);
 numlines:=25;
 if nodirect then directvideo:=false;
 if LINE43 then begin;
  textmode(259);
  numlines:=hi(windmax)+1;
 end;
 clrscr;
 window(1,1,80,numlines-1);
 textcolor(7);
 textbackground(0);
 default_fore:=7;
 default_back:=0;
 if (paramstr(1)='?') or (paramstr(1)='/?') then begin;
  showhelp;
  halt;
 end;
 gettime(st_hr,st_mn,st_sc,junk);
 GetBBSInfo(
             bbs_software,
             User_first,user_last,
             USER_ACS,
             bbs_time_left,
             com_port,
             baud_rate,
             node,
             local,
             graphics,
             color1,
             color_chg,
             board_name,
             sysop_first,
             sysop_last,
             maxtime,
             doorfilepath,lockbaud);
 displayInfo(
             bbs_software,
             User_first,user_last,
             USER_ACS,
             bbs_time_left,
             com_port,
             baud_rate,
             node,
             local,
             graphics,
             color1,
             color_chg,
             board_name,
             sysop_first,
             sysop_last,
             maxtime,
             doorfilepath,lockbaud);
 if not local then begin;
  if FossilIO then AsyncSelectFossil else AsyncSelectInternal;
  Open_Async_Port;
 end;
 if fossilio and (initok=false) and (not local) then begin;
  writeln('');
  writeln('Fossil was not initialized properly! You should change to INTERNAL');
  writeln('communications routines.');
 end;
 CurFore:=default_fore;
 CurBack:=default_back;
 fore(default_fore);
 back(default_back);
 more:=true;
 curlinenum:=1;
 time_check:=true;
 time_credit:=0;
 mintime:=1;
 notime:='';
 dotitle;
 User_first:=stu(User_first);
 user_last:=stu(user_last);
 if node=0 then node:=1;
end;

begin
 exitsave:=exitproc;
 exitproc:=@myexit;
end.
