
{$M 16384, 0, 72000}
Unit VGAgraph;

interface

uses crt, dos, graph;

Type TileMap = array[1..20, 1..20] of byte;
     Animation = array[1..64, 1..64] of byte;
     ColorValue = record Rvalue,Gvalue,Bvalue: byte; end;
     Palette = array [0..255] of ColorValue;
     LetterType = record
        xy : array[1..8, 1..8] of byte;
     end;
     PageType = array[1..200, 1..320] of byte;
   var
    CurPalette : Palette;
    OtherPage : ^PageType;
   Const
    HorizDir = 0;
    VertDir = 1;
    DefaultFont = 0;
    TriplexFont = 1;
    SmallFont = 2;
    SanserifFont = 3;
    GothicFont = 4;

var ErrCode : Byte;                   {Errors are passed here}
    Size : Byte;                      {Character Size}
    MaxInc : Byte;                    {Maximum Increment by FadeToBlack}
    CurColor : Byte;                  {Returned to Current Color#}
    GetMaxX, GetMaxY : Integer;
    Pages : boolean;
    activepage : byte;

procedure ClearViewPort;   {Clears Current Video Screen w/ Color 0}
function between(c, a, b : integer) : boolean;  {Sees if C is between A & B}
procedure settextstyle(font, direction, charsize : word);  {Fonts in BGI}
procedure SetColor(b : byte);  {Sets color = to b}
procedure CloseGraph;  {Closes the graphics port}
Procedure Line(X1,Y1,X2,Y2:Integer;Color:Byte);
procedure FadeToBlack(x, y, w, t : word; s : string); {Fades String black-col-black}
procedure OutXY(origx, origy : integer; s : string); {OuttextXY replacement}
procedure DownPalette;  {Downs the palette <why doesn't it work????>}
procedure UpPalette;  {Ups the palette to WHITE <not finished>}
procedure Rectangle(firstx, firsty, lastx, lasty : integer);  {Draws a rectangle}
procedure SetVGApalette(var tp: Palette);
procedure PutImage(x, y : word; fn : string);  {Places a Bitmap onscreen fm file}
procedure PutPixel(x,y:word;color:byte);  {Puts a pixel at x, y, color}
function ParamCheck(s : string) : boolean; {Checks if s was a paramter}
function Upstring(s : string) : string; {UPCASES a string}
function exists(f : string) : boolean; {See if file exists}
procedure Initialize_Graphics; {Inits MCGA 13h screen}
procedure ShowPage;
function getpixel(x,y:word) : byte; {Gets a pixel from x, y}
procedure PageFlip;
procedure Initpages;
Procedure GrayScale(Start,Finish:Integer);

implementation

Procedure GrayScale(Start,Finish:Integer);
var
  I : byte;
  Gray        :  Byte;
begin
  For I := Start to Finish do begin
    Gray := Round ((0.30 * Curpalette[I].Rvalue) + (0.59 * Curpalette[I].GValue) + (0.11 * Curpalette[I].Bvalue));
    CurPalette[i].Rvalue := Gray;
    CurPalette[i].Gvalue := Gray;
    CurPalette[i].Bvalue := Gray;
    end;
  SetVGAPalette(CurPalette);
end;

Procedure Line (X1,Y1,X2,Y2:Integer;Color:Byte);
var
  I,
  YIncr,
  D,DX,DY,
  AIncr,BIncr :  Integer;
  Ofs         :  Word;
begin                                  { uses Bresenham's algorithm for }
  If X1 > X2 then begin
    D  := X1;
    X1 := X2;
    X2 := D;
    D  := Y1;
    Y1 := Y2;
    Y2 := D;
    end;
  If Y2 > Y1 then YIncr :=  320
             else YIncr := -320;
  DX := X2 - X1;
  DY := Abs (Y2-Y1);
  D := 2 * DY - DX;
  AIncr := 2 * (DY - DX);
  BIncr := 2 * DY;
  Ofs := Word(Y1) * 320 + Word(X1);
  Mem [$A000:Ofs] := Color;
  For I := X1 + 1 to X2 do begin
    If D >= 0 then begin
      Inc (Ofs,YIncr);
      Inc (D,AIncr);
      end
    Else Inc (D,BIncr);
    Inc (Ofs);
    Mem [$A000:Ofs] := Color;
    end;
end;

function exists (f : string) : boolean;
var fi : file;
begin
 assign(fi, f);
 {$I-} reset(fi); {$I+}
 if ioresult<>0 then exists:=false else
   begin
    exists:=true;
    close(fi);
   end;
end;

function between(c, a, b : integer) : boolean;
begin
  if (c > a) and (c < b) then between := true;
end;


Procedure DownPalette;
var p : palette;
    i : byte;
begin
  i := 0;
  repeat
  repeat
   with p[i] do begin
    rvalue := rvalue - 3;
    if rvalue <= 0 then rvalue := 1;
    gvalue := gvalue - 3;
    if gvalue <= 0 then gvalue := 1;
    bvalue := bvalue - 3;
    if bvalue <= 0 then bvalue := 1;
   end;
   inc(i);
   until i > 255;
  until p[6].rvalue = 1;
  setvgapalette(p);
end;

Procedure UpPalette;
var p : palette;
    i : byte;
begin
  i := 0;
  repeat
  repeat
   with p[i] do begin
    rvalue := rvalue + 3;
    if rvalue >= 63 then rvalue := 63;
    gvalue := gvalue - 3;
    if gvalue >= 63 then gvalue := 63;
    bvalue := bvalue - 3;
    if bvalue >= 63 then bvalue := 63;
   end;
   inc(i);
   until i > 255;
  until p[6].rvalue = 63;
  setvgapalette(p);
end;

function upstring(s : string) : string;
var i : byte;
begin
  i := 1;
  repeat
    s[i] := upcase(s[i]);
    inc(i);
  until i > length(s);
  upstring := s;
end;

Procedure InitPages;
var i, j : integer;
begin
 new(OtherPage);
 i := 1;
 j := 1;
 pages := true;
 repeat
   repeat
     OtherPage^[i, j] := 0;
     Inc(I);
   until i > 200;
   i := 1;
   inc(j);
 until j > 320;
end;

function paramcheck(s : string) : boolean;
var i : integer;
    pcheck : boolean;
begin
  pcheck := false;
	i := 0;
  if paramcount <> 0 then
  repeat
    if upstring(s) = upstring(paramstr(i)) then pcheck := true;
    inc(i);
  until i > paramcount;
  paramcheck := pcheck;
end;

procedure PutImage(x, y : word; fn : string);
var image : file;
begin
   Assign(image, fn);
   Reset(image,1);
   ErrCode:=ioResult;
   repeat
    BlockRead(image,OtherPage^,sizeof(image));
   until eof(image);
   Close(image);
end;

procedure PageFlip;
Var TempPage : ^PageType;
begin
 if pages then begin
  New(TempPage);
  move(mem[$a000:0], temppage^, sizeof(temppage^));
  move(otherpage^, mem[$a000:0], sizeof(otherpage^));
  move(temppage^, otherpage^, sizeof(temppage^));
  dispose(TempPage);
 end;
end;

procedure WaitForVerticalRetrace; assembler;
label
  l1, l2;
asm
    cli
    mov dx,3DAh
l1:
    in al,dx
    and al,08h
    jnz l1
l2:
    in al,dx
    and al,08h
    jz  l2
    sti
end;

procedure SetVGApalette(var tp: Palette);
    var regs: Registers;
  begin { procedure SetVGApalette }
   WaitForVerticalRetrace;
    with regs do
      begin
        AX:=$1012;
        BX:=0; { first register to set }
        CX:=256; { number of registers to set }
        ES:=Seg(tp); DX:=Ofs(tp);
      end;
    Intr($10,regs);
  end; { procedure SetVGApalette }

procedure SetMode (Mode : word);
begin
  asm
    mov ax,Mode;
    int 10h
  end;
end;

procedure LoadCOL (FileName : string);
var
  Fil : file of Palette;
  I : integer;
  Regs : Registers;
begin
  assign (Fil, FileName);
  reset (Fil);
  read (Fil, CurPalette);
  close (Fil);
  WaitForVerticalRetrace;
  for I := 0 to 255 do begin
    with Regs do begin
      AX := $1010;
      BX := I;
      DH := CurPalette[I].rvalue;
      CH := CurPalette[I].gvalue;
      CL := CurPalette[I].bvalue;
    end;
    Intr ($10, Regs);
  end;
end;

procedure ShowPage; assembler;
 asm
      push ds
      push es
      xor  si,si
      xor  di,di
      cld
      mov  ax,word(OtherPage+2)
      mov  ds,ax
      mov  ax,0A000h
      mov  es,ax
      mov  cx,7D00h
      rep  movsw
      pop  es
      pop  ds
end;

Procedure Initialize_Graphics;
begin
 SetMode($13);
 GetMaxX := 320;
 GetMaxY := 200;
end;

procedure OutXY(origx, origy : integer; s : string);
begin
 outtextxy(origx, origy, s);
end;

procedure PutPixel(x,y:word;color:byte);
begin
 if activepage = 1 then otherpage^[x, y] := color else mem[$a000:y*320+x]:=color;
end;

Function GetPixel(x,y:word) : byte;
begin
   if activepage <> 0 then getpixel := otherpage^[x, y] else getpixel := mem[$a000:y*320+x];
end;

procedure Rectangle(firstx, firsty, lastx, lasty : integer);
begin
  line(firstx, lasty, firstx, firsty, curcolor);
  line(lastx, firsty, firstx, firsty, curcolor);
  line(lastx, lasty, lastx, firsty, curcolor);
  line(firstx, lasty, lastx, lasty, curcolor);
end;

Procedure ClearViewPort;
begin
  WaitForVerticalRetrace;
  vgagraph.closegraph;
  initialize_graphics;
  setvgapalette(curpalette);
end;

Procedure SetColor(b : byte);
begin
  curcolor := b;
  graph.setcolor(b);
end;

procedure SetTextStyle(Font, Direction, CharSize : Word);
begin
   graph.settextstyle(Font, Direction, CharSize);
end;

Procedure FadeToBlack(x, y, w, t : word; s : string);
var d : byte;
    incit : boolean;
    i : integer;
begin
  incit := true;
  d := t;
  i := 1;
  repeat
    setcolor(d);
    OutTextXY(x, y, s);
    repeat
      if incit then inc(d) else dec(d);
      inc(i);
    until i > maxinc;    
    if d > t+19 then begin
       d := t+19;
       incit := false;
       delay(w);
      end;
  until (d < t) or (keypressed);
  setcolor(99);
end;

Procedure CloseGraph;
begin
  TextMode(LastMode);
end;

begin
  activepage := 0;
  pages := false;
  maxinc := 1;
  Size := 1;
end.
