Program ZincLandEditor;

Uses SPX_VGA, SPX_IMG, Crt, Dos, Mouse, SPX_TXT, SPX_FNC;

Const
  MaxMap = 200;
  MaxTile = 5;
  XMax = 64;
  YMax = 40;
  MaxTiles = 20;
  MapColors : Array[1..MaxTiles] of Byte = (70, 67, 249, 185, 157, 67, 148, 216, 216, 216,
       216, 216, 216, 216, 216, 69, 154, 154, 154, 210);

Type
  MapType = Array[1..MaxMap,1..MaxMap] of Byte;
  Tilelist = Array[1..MaxTiles] of Pointer;
  LandType = Record
    Map : MapType;
  End;

Var Land : ^LandType;
  Tiles : Array[1..MaxTiles] of Pointer;
  Marker, MapMark : Pointer;
  CurrTile : Integer;
  Key : Char;
  H, V, ButtonPressed : Integer;
  CX, CY : Byte;

Procedure ShowEntireMap;

Var X, Y : Byte;

Begin
  MouseOff;
  For X := 1 to MaxMap do
    For Y := 1 to MaxMap do
      PSet(X-1, Y-1, MapColors[Land^.Map[X,Y]]);
  MouseOn;
End;

Procedure Put(X, Y, OX, OY : Integer; Tile : Pointer);

Begin
  FtPut(OX+(X-1)*MaxTile,OY+(Y-1)*MaxTile,Tile^,False);
End;

Procedure ShowBigMap(TilesX, TilesY, AX, AY : Integer);

Var X, Y : Integer;

Begin
  MouseOff;
  For X := 1 to TilesX do
    For Y := 1 to TilesY do
      Put(X, Y, 200, 0, Tiles[Land^.Map[AX+X,AY+Y]]);
  MouseOn;
End;

Procedure ShowCurrTile;

Begin
  Put( (CurrTile - 1) Mod XMax + 1, (CurrTile - 1) div  XMax + 1, 0, 0, Marker);
End;

Procedure SetTilePage;

Var T : Byte;

Begin
  SetPageActive(2);
  CurrTile := 1;
  MouseOff;
  For T := 0 to MaxTiles - 1 do
    Put(T Mod XMax + 1, T Div XMax + 1, 0, 0, Tiles[T + 1]);
  ShowCurrTile;
  MouseOn;
  SetPageActive(1);
End;

Procedure CloseUp;

Var N : Integer;

Begin
  MouseOff;
  CloseMode;
  For N := 1 to MaxTiles do
    Dispose(Tiles[N]);
  Dispose(Land);
  Dispose(Marker);
End;

Procedure InitLand(N : Byte);

Var X, Y : Byte;

Begin
  For X := 1 to MaxMap do
    For Y := 1 to MaxMap do
      Land^.Map[X,Y] := N;
End;

Procedure LoadInitStuff;

Begin
  OpenMode(3);
  LoadColors('GamePal.Pal',RGB256,256);
  FSetColors(RGB256);
  MouseReset;
  SetDefPtr;
  MouseOn;
  Randomize;
  New(Land);
  InitLand(1);
  LoadVSP('These.VSP',Tiles);
  LoadVSP('Marker.VSP',Marker);
  LoadVSP('MapMark.VSP',MapMark);
  SetTilePage;
  CX := 0;
  CY := 0;
End;

Procedure GetTile;

Begin
  Delay(100);
  MouseOff;
  CopyRect(CX, CY, CX + 23, CY + 39, Pages[3]^, Pages[1]^);
  FPCopy(Pages[1]^,Pages[3]^);
  FPCopy(Pages[2]^,Pages[1]^);
  MouseOn;
  Repeat
    Repeat
      GetMouse(ButtonPressed, H, V);
      H := H div 2;
    Until (KeyPressed) or (ButtonPressed > 0);
    If KeyPressed Then Key := ReadKey Else Key := #0;
      If ButtonPressed = 1 Then Begin
      H := H div 5;
      V := V div 5;
      MouseOff;
      Put((CurrTile-1) Mod XMax + 1, (CurrTile-1) Div XMax + 1, 0, 0, Tiles[CurrTile]);
      CurrTile := H + V * XMax + 1;
      Ifix(CurrTile,1,MaxTiles);
      ShowCurrTile;
      MouseOn;
    End;
  Until (Key in ['G','g']) or (ButtonPressed = 2);
  MouseOff;
  FPCopy(Pages[1]^,Pages[2]^);
  FPCopy(Pages[3]^,Pages[1]^);
  FtPut(CX, CY, MapMark^, False);
  MouseOn;
  Delay(100);
End;


Begin
  LoadInitStuff;
  ShowEntireMap;
  MouseOff;
  FPCopy(Pages[1]^,Pages[3]^);
  MouseOn;
  FtPut(CX, CY, MapMark^, False);
  ShowBigMap(24, 40, CX, CY);
  Repeat
    Repeat
      GetMouse(ButtonPressed, H, V);
      H := H div 2;
    Until KeyPressed or (ButtonPressed > 0);
    If KeyPressed Then Key := ReadKey Else Key := #0;
    If (Key in ['G','g']) or (ButtonPressed = 2) Then
      GetTile;
    If ButtonPressed = 1 Then
      Begin
        If (H < 200) Then
          Begin
            Ifix(H, 0, 176);
            Ifix(V, 0, 160);
            MouseOff;
            CopyRect(CX, CY, CX + 23, CY + 39, Pages[3]^, Pages[1]^);
            CX := H;
            CY := V;
            FtPut(CX, CY, MapMark^, False);
            ShowBigMap(24,40,CX,CY);
            MouseOn;
          End
        Else
          Begin
            H := (H - 200) div 5 + CX + 1;
            V := V div 5 + CY + 1;
            Land^.Map[H, V] := CurrTile;
            MouseOff;
            SetPageActive(3);
            PSet(H - 1, V - 1, MapColors[CurrTile]);
            SetPageActive(1);
            PSet(H - 1, V - 1, MapColors[CurrTile]);
            Put(H - CX, V - CY, 200, 0, Tiles[CurrTile]);
            MouseOn;
          End;
      End;
  Until Key in ['Q','q'];
  CloseUp;
End.