

Procedure Showcommands(S : String);
Var F : String;
Begin
  Writeln;
 If CountParams(S) = 1 then Begin
  Cwriteln('List of Commands, type Help <Command> for individual help');
  Writeln;
  Cwriteln('OPEN        CLOSE       HELP        GET     DROP');
  Cwriteln('INVENTORY   NORTH       SOUTH       EAST    WEST');
  Cwriteln('NORTHEAST   NORTHWEST   SOUTHEAST   QUIT    !');
  Cwriteln('SOUTHWEST   UP          DOWN        SCORE   TITLE');
  Cwriteln('WEAR        REMOVE      WIELD       USE     HOLD');
 End Else
  Begin
   F := Upstring(Split(S,2));
   If (F = 'OPEN') then
    Begin
     Cwriteln('OPEN - Usage');
     Cwriteln('OPEN <direction>');
     Cwriteln('The OPEN command opens a door at a direction.');
     Cwriteln('Ex.  OPEN SOUTHEAST');
    End else
   If (F = 'CLOSE') then
    Begin
     Cwriteln('CLOSE - Usage');
     Cwriteln('CLOSE <direction>');
     Cwriteln('The CLOSE command closes a door at a direction.');
     Cwriteln('Ex.  CLOSE SOUTHEAST');
    End else
   If dir(f) <> 0 then
    Begin
     Cwriteln('Direction Command');
     Cwriteln('Entering N,S,E,W,EAST,WEST,NORTH,SOUTH,NORTHWEST,');
     Cwriteln('NORTHEAST,SOUTHWEST,SOUTHEAST,SE,SW,NE,U,UP,DOWN,D or NW');
     Cwriteln('will attempt your character to move if the specified');
     Cwriteln('path is unrestricted.');
    End else
   If (F = 'QUIT') then Cwriteln('The QUIT command QUITs the mud!') else
   If (F = 'GET') then
    Begin
     Cwriteln('GET - Usage');
     Cwriteln('GET <object>');
     Cwriteln('GET transfers an object from the current room to your');
     Cwriteln('Inventory.  If you wish to attempt to get everything in');
     Cwriteln('the room, you may type GET ALL.  Or if you want a certain');
     Cwriteln('type of object, GET ALL <objectname>.  Or if you want a');
     Cwriteln('certain object, you may type GET 2 <objectname>.');
     Cwriteln('Ex. GET SWORD   GET ALL WAND   GET 2 RING');
    End else
   If (F = 'DROP') then
    Begin
     Cwriteln('DROP - Usage');
     Cwriteln('DROP <object>');
     Cwriteln('DROP transfers an object from your inventory to the');
     Cwriteln('current room.  If you wish to drop everything in your');
     Cwriteln('inventory that is not being worn or used, you may type');
     Cwriteln('DROP ALL.  Or if you want a certain object or set of');
     Cwriteln('types of objects, DROP ALL <objectname>.  Or if you want a');
     Cwriteln('certain object, you may type DROP 2 <objectname>.');
     Cwriteln('Ex. DROP HELMET   DROP ALL WAND   DROP 2 RING');
    End else
   If (F = 'SCORE') then
    Begin
     Cwriteln('SCORE displays your statistics, age, health and weight');
     Cwriteln('information.  Short command: SC');
    End else
   If (F = 'TITLE') then
    Begin
     Cwriteln('TITLE - Usage');
     Cwriteln('TITLE <new title SUCCEEDING YOUR NAME>');
     Cwriteln('The TITLE command modifies your character''s title.');
     Cwriteln('Short Command: TIT');
     Cwriteln('Ex. TITLE the Foolish Argyle Maker');
    End else
   If (F = '!') then Cwriteln('! repeats the last command') else
   if (F = 'WEAR') then
    Begin
     Cwriteln('WEAR - Usage');
     Cwriteln('WEAR <objectname>');
     Cwriteln('WEAR will begin using an object.  When an object is in your');
     Cwriteln('inventory, it cannot add its multipliers to your abilities.');
     Cwriteln('If you want to take advantage (or disadavantage) then you');
     Cwriteln('must WEAR, USE or HOLD an item, or WIELD a weapon.');
     Cwriteln('YOU *MUST* BE CARRYING THE ITEM TO WEAR IT!');
     Cwriteln('Ex. WEAR HELM   WEAR 2 BRACER   WEAR ALL');
    End else
   If (F = 'REMOVE') then
   Begin
    Cwriteln('REMOVE - Usage');
    Cwriteln('REMOVE <objectname>');
    Cwriteln('REMOVE takes an item off of your person.  It does NOT remove');
    Cwriteln('Lights, Weapons or items that are Held.  If you wish to stop');
    Cwriteln('using an item, due to its ill effects or if you should happen');
    Cwriteln('upon a better item, then REMOVE will place it back into your');
    Cwriteln('inventory.  Short Command: REM');
    Cwriteln('Ex. REM PONCHO   REM 2 BRACELET   REM ALL');
   End else
   If (F = 'LOOK') then
    Begin
     Cwriteln('LOOK - Usage');
     Cwriteln('LOOK <objectname, direction .. AROUND,ROOM>');
     Cwriteln('If you type LOOK and then an object''s name, the object will');
     Cwriteln('be described.  If look has no parameters, it will show the');
     Cwriteln('room description followed by any objects that are in the room.');
     Cwriteln('If you type LOOK AROUND or LOOK ROOM it will describe only');
     Cwriteln('the room, with no individual objects.  Short Command: L');
     Cwriteln('Ex. LOOK SWORD   LOOK AROUND   L NORTHEAST   L S');
    End else
   If (F = 'INVENTORY') then
    Begin
     Cwriteln('The INVENTORY command lists the current supplies and');
     Cwriteln('items in your posession NOT in containers (NYI).');
     Cwriteln('Short command: I');
    End else
   If (F = 'HELP') then Cwriteln('HELP - what the hell do you THINK this command does?!')
   else Cwriteln('Unknown command '''+Upstring(F)+''', type HELP for a list.');
  End;
  Writeln;
End;
