Function Modifier(T : Byte) : Integer;
Var T2 : Integer;
Begin
 Case T of
     0:T2 := -4;
  1..2:T2 := -3;
  3..6:T2 := -2;
   7,8:T2 := -1;
 9..11:T2 := 0;
12..14:T2 := 1;
 15,16:T2 := 2;
 17,18:T2 := 3;
    19:T2 := 4;
20..22:T2 := 5;
23..25:T2 := 6;
    Else T2 := 7;
   End;
 Modifier := T2;
End;

Function AnyPhys(E : APtypeset; Z : Ptypeset) : Boolean;
Var X : Integer;
    Temp : Boolean;
Begin
 Temp := False;
 For X := 1 to 4 do if e[x] = z then Temp := True;
 AnyPhys := Temp;
End;

Function AnyMods(E : ATypeset; Z : ModTypeSet; Var I : Integer) : Boolean;
Var X : Integer;
    Temp : Boolean;
Begin
 Temp := False;
 For X := 1 to 4 do if e[x].settype = z then
  Begin
   Temp := true;
   I := e[x].Num1;
  End;
 AnyMods := Temp;
End;

Function AnyEffects(E : AEtypeset; Z : ETypeset) : Boolean;
Var X : Integer;
    Temp : Boolean;
Begin
 Temp := False;
 For X := 1 to 4 do if e[x] = z then Temp := true;
 AnyEffects := Temp;
End;

Function CountItems(U : UserType) : Byte;
Var X, Y : Integer;
Begin
 Y := 0;
 With U do For X := 1 to 25 do If I[X].ObjNum < 0 then Inc(Y);
 CountItems := 25-Y;
End;

Function CountWeight(U : UserType) : Integer;
Var X, Y : Integer;
Begin
 Y := 0;
 With U do For X := 1 to 25 do IF I[X].ObjNum <> -1 then Inc(Y,O[I[X].ObjNum]^.Weight);
 CountWeight := Y;
End;

Procedure Inventory(U : UserType);
Var X : Integer;
    NE : boolean;
Begin
 Cwriteln('You are carrying:');
 NE := False;
 With U do
  For X := 1 to 25 do
    If I[X].ObjNum > 0 then With O[I[X].ObjNum]^ do
     Begin
      NE := True;
      Cwrite(Name);
      If AnyEffects(effects,GLOW) then cwrite('.. it has a faint glowing aura!');
      If AnyEffects(effects,MAGIC) then cwrite('.. it hums rhythmically!');
      Writeln;
      If X = 15 then Pause;
     End;
 If not NE then cwriteln('nothing');
End;

Procedure ShowWield(U : UserType);
Var X : Integer;
Begin
 Writeln;
 Cwriteln('You are wearing/using:');
 Writeln;
 With U do
  For X := 1 to 13 do if W[X].ObjNum <> -1 then
   Begin
    Case X of
        1:Cwrite('<worn on head>         ');
        2:Cwrite('<worn on arms>         ');
        3:Cwrite('<worn on legs>         ');
      4,5:Cwrite('<worn on finger>       ');
        6:Cwrite('<worn on body>         ');
        7:Cwrite('<worn around waist>    ');
        8:Cwrite('<worn over shoulders>  ');
        9:Cwrite('<worn on hands>        ');
    10,11:Cwrite('<worn on wrist>        ');
       12:Cwrite('<used for light>       ');
       13:Cwrite('<held to use>          ');
     End;
    Cwriteln(o[W[X].ObjNum]^.Name);
   End;
End;

Procedure ResetUserStats(Var U : UserType);
Begin
 With U do
  Begin
   STR := BSTR;
   INT := BINT;
   WIS := BWIS;
   DEX := BDEX;
   CON := BCON;
   Age := BAge;
   Sex := BSex;
   Alignment := Balign;
   HitRoll := 0;
   DamRoll := 0;
   Armor := 100;
  End;
End;

Procedure SetChange(Obj : ObjectType; Var U : UserType);
Var X : Integer;
Begin
 With OBJ do
  Begin
   If Not AnyMods(Types,NOTHING,X) then
   If AnyMods(Types,HITROLL,X) then U.Hitroll := U.Hitroll + X;
   If AnyMods(Types,DAMROLL,X) then U.Damroll := U.Damroll + X;
   If AnyMods(Types,STRENGTH,X) then U.STR := U.STR + X;
   If AnyMods(Types,INTELLIGENCE,X) then U.INT := U.INT + X;
   If AnyMods(Types,DEXTERITY,X) then U.DEX := U.DEX + X;
   If AnyMods(Types,SEX,X) then U.SEX := not U.SEX;
   If AnyMods(Types,CONSTITUTION,X) then U.CON := U.CON + X;
   If AnyMods(Types,WISDOM,X) then U.WIS := U.WIS + X;
   If AnyMods(Types,ALIGN,X) then U.Alignment := U.Alignment + X;
   If AnyMods(Types,ARMR,X) then U.Armor := U.Armor + X;
   If AnyMods(Types,AGE,X) then U.Age := U.Age + X;
   If AnyMods(Types,HITS,X) then U.Hp := U.Hp + X;
   If AnyMods(Types,MANA,X) then U.M := U.M + X;
   If AnyMods(Types,MOVEMENT,X) then U.Mv := U.Mv + X;
   If Not AnyEffects(Effects,NONE) then
   If AnyEffects(Effects,INVIS) then ;
   If AnyEffects(Effects,SANCT) then ;
   If AnyEffects(Effects,SNEAK) then ;
   If AnyEffects(Effects,SLEEP) then ;
   If AnyEffects(Effects,WAKE) then ;
   If AnyEffects(Effects,NOSPEAK) then ;
   If AnyEffects(Effects,BLIND) then ;
   If AnyEffects(Effects,INFRA) then ;
   If AnyEffects(Effects,DETECTINVIS) then ;
   If AnyEffects(Effects,DETECTEVIL) then ;
   If AnyEffects(Effects,KNOWALIGN) then ;
   U.Armor := U.Armor + Ac;
  End;
  If U.Armor < -100 then U.Armor := -100 else
   If U.Armor > 100 then U.Armor := 100;
  If U.Alignment < -100 then U.Alignment := -100 else
   If U.Alignment > 100 then U.Alignment := 100;
  If U.Age > 220 then U.Age := 0 else
   If U.Age > 200 then U.Age := 200;
  If U.STR > 50 then U.STR := 0 else
   If U.STR > 30 then U.STR := 30;
  If U.INT > 50 then U.INT := 0 else
   If U.INT > 30 then U.INT := 30;
  If U.DEX > 50 then U.DEX := 0 else
   If U.DEX > 30 then U.DEX := 30;
  If U.WIS > 50 then U.WIS := 0 else
   If U.WIS > 30 then U.WIS := 30;
  If U.CON > 50 then U.CON := 0 else
   If U.CON > 30 then U.CON := 30;
  If U.Hitroll > 85 then U.Hitroll := 0 else
   If U.Hitroll > 75 then U.Hitroll := 75;
  If U.Damroll > 85 then U.Damroll := 0 else
   If U.Damroll > 75 then U.Damroll := 75;
End;

Procedure CalcStats(Var U : UserType);
Var X : Integer;
Begin
  ResetUserStats(U);
  For X := 1 to 13 do if u.W[X].ObjNum <> -1 then SetChange(o[u.W[X].ObjNum]^,U);
  U.Armor := U.Armor - (2*Modifier(U.DEX));
  U.Hitroll := U.Hitroll + Modifier(U.DEX);
  U.Damroll := U.Damroll + Modifier(U.STR);
End;

Procedure Score(Var U : Usertype);
Begin
 CalcStats(U);
 Writeln;
 with u do begin
  Cwriteln('You are '+ss(age)+' years old at level '+ss(level)+'.');
  Cwriteln('Hit points: '+ss(hp)+'/'+ss(hpmax)+'  Mana: '+ss(m)+'/'+ss(mmax)+'  Movement: '+ss(mv)+'/'+ss(mvmax));
  Cwriteln('Stats:  STR: '+ss(str)+' INT: '+ss(int)+' WIS: '+ss(wis)+' DEX: '+ss(dex)+' CON: '+ss(con));
  If Level >= 20 then Cwriteln('Hitroll: '+ss(Hitroll)+'     Damroll: '+ss(DamRoll));
  If Level >= 15 then Cwriteln('Armor: '+ss(armor)) else
   Cwriteln('You are '+EstimateArmor(Armor)+'.');
  If Level >= 25 then Cwriteln('Alignment : '+ss(alignment)) else Cwriteln('You are '+EstimateAlign(Alignment)+'.');
  Cwriteln('You are holding '+ss(countitems(U))+'/25 items totalling '+ss(countweight(U))+'/'+ss((str)*25)+' in weight.');
  Cwriteln('You have moved '+ss(movetotal)+' times and survived N/A ticks.');
  Cwriteln('Your current rank is '''+sdesc+''' ('+charname+' a.k.a. '+username+')');
  Cwrite('You are a ');
  if not sex then cwrite('male ') else cwrite('female ');
  if class = thief then cwriteln('thief.') else
   if class = warrior then cwriteln('warrior.') else
    if class = mage then cwriteln('mage.') else
     if class = cleric then cwriteln('cleric.');
 end;
End;
