/***************************************************************************/
/*																		   */
/*								  ZFONT.H							       */
/*																		   */
/***************************************************************************/
/*		(c) 1995 Zephyr Software, Stephen L. Balkum and Daniel A. Sill	   */
/***************************************************************************/
/*                                                                         */
/*                     NON-EXCLUSIVE LICENSE FOR USE                       */
/* This SOFTWARE is provided under a license and may only be used in       */
/* accordance with that license.  This SOFTWARE or any copies may not be   */
/* distributed by any means, electronic or otherwise, to any third         */
/* individual or party.  The title and ownership of this SOFTWARE remains  */
/* with Zephyr Software, Stephen L. Balkum and Daniel A. Sill.  This file  */
/* may change without notice and there is no commitment of support by      */
/* Zephyr Software, Stephen L. Balkum and Daniel A. Sill.                  */
/* The content of this file is confidential.                               */
/*                                                                         */
/*                     NO WARRANTIES AND NO LIABILITY                      */
/* Stephen L. Balkum and Daniel A. Sill provide no warranties, either      */
/* expressed or implied, of merchantability, or fitness, for a particular  */
/* use or purpose of this SOFTWARE and documentation.  In no event shall   */
/* Stephen L. Balkum or Daniel A. Sill be held liable for any damages      */
/* resulting from the use or misuse of the SOFTWARE and documentation.     */
/*                                                                         */
/*                    U.S. GOVERNMENT RESTRICTED RIGHTS                    */
/* Use, duplication, or disclosure of the SOFTWARE and documentation by    */
/* the U.S. Government is subject to the restictions as set forth in       */
/* subparagraph (c)(1)(ii) of the Rights in Technical Data and Computer    */
/* Software clause at DFARS 252.227-7013.  Contractor/manufacturer is      */
/* Stephen L. Balkum and Daniel A. Sill, P.O. Box 7704, Austin, Texas      */
/* 78713-7704.                                                             */
/*                                                                         */
/* The copyright information found in this code must remain intact and may */
/* not be commented out or otherwise removed from the compiling process.   */
/*                                                                         */
/* By using this SOFTWARE or documentation, you agree to the above terms   */
/* and conditions.                                                         */
/***************************************************************************/

/*--------------------------------------------------------------------------\
| This file contains the structure definitions and function prototypes for a
| scalable font system.
|
| Revision History:
|
| Feb ??, 1995: Completed and passed initial coding tests.
| Apr 03, 1995: Changed to use XMS for glyph storage.  Initial tests pass.
| Apr 04, 1995: Incorporated custom file access for memory model and
|               compiler independence.  Final tests pass.
\--------------------------------------------------------------------------*/


#ifndef ZFONT_H
#define ZFONT_H


/*---------------------------------------------------------------------------
| zFont
|
| This structure defines the data stored in conventional memory.  The data
| for individual glyph is store in extended memory.
*/
typedef struct tag_zFont {
    unsigned long _GlyphOffset[256];
    unsigned long _GlyphLength[256];
    short _XMSHandle;
} zFont;


#ifdef __cplusplus
extern "C"
{
#endif


/*---------------------------------------------------------------------------
| zFontInitialize()
|
| This function establishes the temporary working buffers for this module.
| The internal buffer of the svgaxx library is used to provide three 12K
| work areas.  For this reason the whichvga function must be called first as
| it establishes the svgaxx internal buffers.  Calling this function out of
| order will probably crash the system.
|
| Inputs: none
|
| Return: none
*/
extern void far zFontInitialize(void);


/*---------------------------------------------------------------------------
| zFontLoad()
|
| This function loads a font from disk, defines the values in the zFont
| structure and stores the data in extended memory.  This requires that the
| whichxms function be called first successfully.
|
| Inputs: fontname = pointer to filename for font data
|         destfont = pointer to zFont structure for this font
|
| Return: 1 for success, 0 for XMS error (see xmserror()), -1 for file error
|         (see errno)
*/
extern int far zFontLoad(const char far *fontname, zFont far* destfont);


/*---------------------------------------------------------------------------
| zFontSet()
|
| This function assigns the hidden variable _zFontCurrent.
|
| Inputs: destfont = pointer to font to make active
|
| Return: none
*/
extern void far zFontSet(zFont far* newfont);


/*---------------------------------------------------------------------------
| zFontDraw()
|
| This is the heart of the zFont module.  This function draws the given
| string on the screen in the font pointed to by _zFontCurrent.  The quality
| of the curves, location and orientation, and color are all options.
|
| Inputs: fcolr   = fill color for the string
|         angle   = orientation angle of string in degrees
|         height  = the desired pixel height of the character bounding box
|         quality = determines number of points calculated in curves (see
|                   _zQuadSpline)
|         strng   = the text to be drawn
|         x, y    = the location to draw the bottom, left corner of the first
|                   character
|
| Return: none
*/
extern void far zFontDraw(int fcolr, int angle, int height, byte quality, const char far *strng, int x, int y);


/*---------------------------------------------------------------------------
| zFontUnload()
|
| This function merely frees the extended memory used by the font.  It serves
| as a reminder that this is required before exiting a program.
|
| Inputs: destfont = pointer to zFont structure for font to unload
|
| Return: none
*/
extern void far zFontUnload(zFont far* font);


#ifdef __cplusplus
}
#endif


#endif /* ZFONT_H */
