/***************************************************************************/
/*																		   */
/*								ZFONTEST.CPP							   */
/*																		   */
/***************************************************************************/
/*		(c) 1995 Zephyr Software, Stephen L. Balkum and Daniel A. Sill	   */
/***************************************************************************/
/*                                                                         */
/*                     NON-EXCLUSIVE LICENSE FOR USE                       */
/* This SOFTWARE is provided under a license and may only be used in       */
/* accordance with that license.  This SOFTWARE or any copies may not be   */
/* distributed by any means, electronic or otherwise, to any third         */
/* individual or party.  The title and ownership of this SOFTWARE remains  */
/* with Zephyr Software, Stephen L. Balkum and Daniel A. Sill.  This file  */
/* may change without notice and there is no commitment of support by      */
/* Zephyr Software, Stephen L. Balkum and Daniel A. Sill.                  */
/* The content of this file is confidential.                               */
/*                                                                         */
/*                     NO WARRANTIES AND NO LIABILITY                      */
/* Stephen L. Balkum and Daniel A. Sill provide no warranties, either      */
/* expressed or implied, of merchantability, or fitness, for a particular  */
/* use or purpose of this SOFTWARE and documentation.  In no event shall   */
/* Stephen L. Balkum or Daniel A. Sill be held liable for any damages      */
/* resulting from the use or misuse of the SOFTWARE and documentation.     */
/*                                                                         */
/*                    U.S. GOVERNMENT RESTRICTED RIGHTS                    */
/* Use, duplication, or disclosure of the SOFTWARE and documentation by    */
/* the U.S. Government is subject to the restictions as set forth in       */
/* subparagraph (c)(1)(ii) of the Rights in Technical Data and Computer    */
/* Software clause at DFARS 252.227-7013.  Contractor/manufacturer is      */
/* Stephen L. Balkum and Daniel A. Sill, P.O. Box 7704, Austin, Texas      */
/* 78713-7704.                                                             */
/*                                                                         */
/* The copyright information found in this code must remain intact and may */
/* not be commented out or otherwise removed from the compiling process.   */
/*                                                                         */
/* By using this SOFTWARE or documentation, you agree to the above terms   */
/* and conditions.                                                         */
/***************************************************************************/

/*--------------------------------------------------------------------------\
| This file contains the testbed program for the zFont module.
|
| Revision History:
|
| Feb ??, 1995: Completed and passed initial coding tests.
| Apr 03, 1995: Changed to use XMS for glyph storage.  Initial tests pass.
| Apr 04, 1995: Final tests pass.
\--------------------------------------------------------------------------*/


#include <conio.h>
#include <dos.h>
#include <io.h>
#include <malloc.h>
#include <math.h>
#include <memory.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "svgacc.h"
#include "zfont.h"


void main(int argc, char *argv[])
{
    zFont* font;
    long fontsize;
	int i, j;
	char z[] = "Zephyr Software";
	char *s;
	byte quality;
	
	if(argc < 4) {
		printf("Usage: %s fontname quality(0-3) \"string\" [\"2nd string\"]\n",argv[0]);
		printf("If 1st string is a single character, 2nd string used as a size test.\n");
		exit(0);
	}

    /* place font structure in heap since it consumes 2K */
    font = (zFont*)malloc(sizeof(zFont));
    if(!font)
    {
        printf("memory alloc failed\n");
        exit(1);
    }

    if(!whichxms((unsigned int *)&i, (unsigned int *)&j))
    {
        printf("no xms\n");
        exit(1);
    }

    if(!whichvga()) {
		printf("no id vga\n");
		exit(1);
    }

    // Initialize zFont subsystem
    zFontInitialize();

    // Load in a sample font
    i = zFontLoad(argv[1], font);
    if(i != 1)
    {
        printf("zFontLoad failed: %d\n",i);
        exit(1);
    }

    // Declare the font active
    zFontSet(font);

    res640();
	fillscreen(0);
	
	quality = *argv[2] - '0';
	
	if(strlen(argv[3]) != 1) {

        // fill screen with some random lines
		for(i=0;i<200;i++)
			drwline(SET,(rand()%15)+1,rand()%640,rand()%480,rand()%640,rand()%480);

        // draw strings at a range of orientations
		for(i=0;i<=90;i+=5)
		{
            zFontDraw(((i/5)&7)+8, 90-i, 48+i/3, quality, argv[3], 10, 60);
			if(argc == 5)
                zFontDraw(((i/5)&7)+8, 270-i, 48+i/3, quality, argv[4], 630, 420);
		}

        // draw shadowed string
        zFontDraw(0, 0, 60, quality, z, 102, 242);
        zFontDraw(14, 0, 60, quality, z, 100, 240);
	} else {
        // give sample of scaling.  note poor quality at very low heights

		if(argc == 5)
			s = argv[4];
		else
			s = z;
			
		drwstring(SET, 7, 0, "8", 0, 16);
		drwstring(SET, 7, 0, "16", 0, 32);
		drwstring(SET, 7, 0, "24", 320, 32);
		drwstring(SET, 7, 0, "32", 0, 64);
		drwstring(SET, 7, 0, "64", 0, 128);
		drwstring(SET, 7, 0, "128", 0, 256);
		drwstring(SET, 7, 0, "192", 0, 448);
        zFontDraw(14, 0,   8, quality, s, 10, 16);
        zFontDraw(14, 0,  16, quality, s, 10, 32);
        zFontDraw(14, 0,  24, quality, s, 330, 32);
        zFontDraw(14, 0,  32, quality, s, 10, 64);
        zFontDraw(14, 0,  64, quality, s, 10, 128);
        zFontDraw(14, 0, 128, quality, s, 10, 256);
        zFontDraw(14, 0, 192, quality, s, 10, 448);
	}

    while(!kbhit())
    	;
	getch();
	
	restext();

    // Unload the font
    zFontUnload(font);
}
