/***************************************************************
* File:     VIDPRIM.H
* Date:     February 1991
* Purpose:  Header file for primitive video functions.
* Authors:  Craig Miller, George Spofford.
*
* Source code may be used freely provided that
* authorship/publication is acknowledged.
****************************************************************/

#if ! defined (_PASCAL)
#if ! defined (DOS_386)
#define _PASCAL pascal
#define _CDECL cdecl
#else
#define _PASCAL
#define _CDECL
#endif
#endif

#if __TURBOC__
#define _CDECL
#endif

#if ! defined (VIDPRIM_INC)

typedef short color_t;  /* hide type of IBM display attibutes */

#define N_DIM  2        /* # of screen dimensions */
#define DOWN   0        /* vector array offsets -vertical */
#define ACROSS 1        /* vector array offsets -horizontal */

typedef int vec_t[N_DIM];  /* basic vector */

typedef struct {        /* basic bounding box */
        vec_t o;        /* upper-left cormer */
        vec_t n;        /* # of units */
} bbox_t;

/*------------------  VIDSTATE functions  --------------------*/
#undef DEF
#ifndef VIDPRIM_SRC
#define DEF extern
#else
#define DEF
#endif

DEF void  _PASCAL InitDisplay (int mode, int rows);
DEF void         ClearScreen (void );
DEF void         ClearBox (bbox_t *bbp);
DEF void         SetCurBox (bbox_t *bbp);
DEF void         CursorOff (void);
DEF void _PASCAL SetTextCursor (int r, int c);
        /* next function returns old attribute */
DEF color_t      SetCurAttrib (color_t attr);
DEF void _PASCAL ScrollBox (bbox_t *bbp, int nd, int na);
DEF int  _PASCAL x_outtext (int r, int c, char *str);
DEF int  _PASCAL x_outch (int r, int c, char ch);
DEF int  _CDECL  xput_string (int r, int c, char *fmt,...);
#undef DEF

/* handy bbox-setting macro */
#define BBSET( b, od, oa, nd, na) \
{(b).o[DOWN]=od; (b).o[ACROSS]=oa; \
(b).n[DOWN]=nd; (b).n[ACROSS]=na;}

/* Video and font control codes */
#define EGA_setvideomode(m)   VideoBios2((m),0,0)

#define SCAN400         0x02
#define SCAN350         0x01
#define SCAN200         0x00
#define SETSCANLINES    0x12
#define VGA_400lines() \
        VideoBios1 (SCAN400, SETSCANLINES, 0x30, 0)
#define EGA_350lines() \
        VideoBios1 (SCAN350, SETSCANLINES, 0x30, 0)
#define VGA_350lines() \
        VideoBios1 (SCAN350, SETSCANLINES, 0x30, 0)
#define EGA_200lines() \
        VideoBios1 (SCAN200, SETSCANLINES, 0x30, 0)

#define SETFONT         0x11
#define FONT8X8NORESET  0x12
#define FONT8X16NORESET 0x14
#define EGA_SetFont(f)  VideoBios1 (f, SETFONT, 0, 0)

/* handy color constants */

#define MK_ATTR(b,f) (((b) << 4) + (f))

#define CGA_BLACK     0x00
#define CGA_BLUE      0x01
#define CGA_GREEN     0x02
#define CGA_CYAN      0x03
#define CGA_RED       0x04
#define CGA_MAGENTA   0x05
#define CGA_BROWN     0x06
#define CGA_WHITE     0x07
#define CGA_GREY      0x08
#define CGA_LTBLUE    0x09
#define CGA_LTGREEN   0x0A
#define CGA_LTCYAN    0x0B
#define CGA_LTRED     0x0C
#define CGA_LTMAGENTA 0x0D
#define CGA_YELLOW    0x0E
#define CGA_LTWHITE   0x0F

#define VIDPRIM_INC
#endif

/* END OF VIDPRIM.H */