/*---------------------------------------------------------------------------
 * BIN2ASM.C - a utility to convert .SCR raw pics to a variable size ASM
 * or C data file.
 *
 * Needs: a VGA viewer, and VGACAP.COM
 *
 * This is a simple util that I use to cut up pictures for use in my work.
 * I have some other preprocessing deals to make them unchained mode, but
 * these will get you going on putting pics in your loaders. All you need
 * to do is run a viewer (this archive should have come with SVGA.EXE) and
 * screen capture using VGACAP.COM, and then use this to convert it. This
 * is very rudimentary, but it fits my needs and I dont feel the need to
 * increase it... Also, some basic color reduction is done. (Empty colors
 * are removed.) I was going to remove duplicates, but I decided to wait
 * until I had a good algorithm for overall color reduction. Works for me,
 * but you're welcome to modify it to your needs, as long as you greet me
 * or Shadow Faction. :)
 *
 * -Friar Tuck/Shadow Faction (sparkss@snyalfva.cc.alfredtech.edu)
 *
 *--------------------------------------------------------------------------*/
#include <io.h>
#include <mem.h>
#include <alloc.h>
#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <process.h>
#include "vidstuff.c"
#include "mouse.h"

#define C_DATA      1
#define ASM_DATA    2

// color flags
#define USED        1
#define FIXED       2

unsigned char colorflags[256];
unsigned char far *screen;
unsigned char far *video = (char far *)0xA0000000;
unsigned char far *pal;
unsigned char temppal[768];
char output_type = ASM_DATA;
int colors = 0;

void compress_image(int x1, int y1, int x2, int y2)
    {
    unsigned int x,y,p;
    unsigned int px,py;
    unsigned char pc;
    unsigned int cc1=0,cc2=0;

    colors=0;
    for(x=0;x<255;x++) colorflags[x]=0;

    // First, count the number of colors in the section
    for(y=y1;y<=y2;y++)
        for (x=x1;x<=x2;x++)
            {
            p=y*320+x;
            pc=screen[p];
            if(!colorflags[pc]) {
                colors++;
                colorflags[pc]=1;
                }
            }
    printf("%d colors used -",colors);
    // Then, begin compressing...
    // cc1 = current color optimized
    // cc2 = swapcolor
    for (cc1=0;cc1<256;cc1++)
        {
        // Do we need to move this color?
        if(colorflags[cc1])
            {
            if(cc1!=cc2) {
             // Update the actual palette entries...
             pal[(cc2*3)]=pal[(cc1*3)];
             pal[(cc2*3)+1]=pal[(cc1*3)+1];
             pal[(cc2*3)+2]=pal[(cc1*3)+2];
             pal[(cc1*3)]=0;
             pal[(cc1*3)+1]=0;
             pal[(cc1*3)+2]=0;
             // Update the picture
             for (x=x1;x<=x2;x++)
                 for(y=y1;y<=y2;y++)
                     {
                     p=y*320+x;
                     pc=screen[p];
                     if(pc==cc1) screen[p]=cc2;
                     }
             cc2++;
             }
            switch(cc2%4) {
                case 0: printf("\b/");
                        break;
                case 1: printf("\b-");
                        break;
                case 2: printf("\b\\");
                        break;
                case 3: printf("\b|");
                        break;
                }
            }
        }
    }

int F_WriteAsmImage(int x1, int y1, int x2, int y2, char *filename)
    {
    int tmp,t2,x,y;
    FILE *outfile;

    if(x1>x2) { tmp=x1;x1=x2;x2=tmp; }
    if(y1>y2) { tmp=y1;y1=y2;y2=tmp; }


    printf("Compressing image...");
    compress_image(x1,y1,x2,y2);
    printf("\b- Done.\nWriting image...");
    outfile=fopen(filename,"w");
    if (outfile==NULL) {
        tmode();
        printf("Error opening to %s\n",filename);
        exit(0);
        }
    fprintf(outfile,"\t;---------------------------------------;\n");
    fprintf(outfile,"\t; BIN2ASM Friar Tuck/Shadow Faction     ;\n");
    fprintf(outfile,"\t; Filename: %13s\t\t;\n",filename);
    fprintf(outfile,"XSIZE equ %d\n",x2-x1+1);
    fprintf(outfile,"YSIZE equ %d\n",y2-y1+1);
    fprintf(outfile,"TOTALBYTES equ %d\n",(x2-x1+1)*(y2-y1+1));
    fprintf(outfile,"COLORS equ %d\n\n",colors);

    fprintf(outfile,"BA_PAL label byte\n\tdb\t");
    for(x=0;x<colors*3;x++)
        {
        fprintf(outfile,"%3d",pal[x]);
        if(x%12==11) {
            fprintf(outfile,"\n\tdb\t");
            }
        else fprintf(outfile,",");
        }

    fprintf(outfile,"0\n\nBA_SCR label byte\n\tdb\t");
    for(y=y1;y<=y2;y++) {
        tmp=0;
        for(x=x1;x<=x2;x++) {
            t2 = y*320+x;
            fprintf(outfile,"%3d",screen[t2]);
            if(tmp%16==15&&x!=x2)
                fprintf(outfile,"\n\tdb\t");
            else if(x!=x2)
                fprintf(outfile,",");
            tmp++;
            }
        if(y!=y2) fprintf(outfile,"\n\n\tdb\t");
        else fprintf(outfile,"\n\n\t; END RUN\n");
        }
    fclose(outfile);
    return(0);
    }

int F_WriteCImage(int x1, int y1, int x2, int y2, char *filename)
    {
    int tmp,t2,x,y;
    FILE *outfile;

    if(x1>x2) { tmp=x1;x1=x2;x2=tmp; }
    if(y1>y2) { tmp=y1;y1=y2;y2=tmp; }


    printf("Compressing image...");
    compress_image(x1,y1,x2,y2);
    printf("\b- Done.\nWriting image...");
    outfile=fopen(filename,"w");
    if (outfile==NULL) {
        tmode();
        printf("Error opening to %s\n",filename);
        exit(0);
        }
    fprintf(outfile,"\t//--------------------------------------\n");
    fprintf(outfile,"\t// BIN2ASM Friar Tuck/Shadow Faction    \n");
    fprintf(outfile,"\t// Filename: %13s\n",filename);
    fprintf(outfile,"#define XSIZE %d\n",x2-x1+1);
    fprintf(outfile,"#define YSIZE %d\n",y2-y1+1);
    fprintf(outfile,"#define TOTALBYTES %d\n",(x2-x1+1)*(y2-y1+1));
    fprintf(outfile,"#define COLORS %d\n\n",colors);

    fprintf(outfile,"unsigned char ba_pal[]={\n\t");
    for(x=0;x<colors*3;x++)
        {
        fprintf(outfile,"%3d",pal[x]);
        if(x%12==11) {
            fprintf(outfile,",\n\t");
            }
        else fprintf(outfile,",");
        }

    fprintf(outfile,"0 }\n\nunsigned char ba_scr[]={\n\t");
    for(y=y1;y<=y2;y++) {
        tmp=0;
        for(x=x1;x<=x2;x++) {
            t2 = y*320+x;
            fprintf(outfile,"%3d",screen[t2]);
            if(tmp%16==15&&x!=x2)
                fprintf(outfile,",\n\t");
            else if(x!=x2)
                fprintf(outfile,",");
            tmp++;
            }
        if(y!=y2) fprintf(outfile,",\n\n\t");
        else fprintf(outfile,"\n\t}\n\t// END RUN\n");
        }
    fclose(outfile);
    return(0);
    }

int ox1=1,ox2=1,oy1=1,oy2=1;

void V_BoxOn(int x1,int y1, int x2, int y2)
    {
    int x,y,p1,p2;

    if(x1>x2) { p1=x1;x1=x2;x2=p1; }
    if(y1>y2) { p1=y1;y1=y2;y2=p1; }

    p1=y1*320+x1;
    p2=y2*320+x1;
    for(x=x1;x<=x2;x++)
        {
        video[p1]=15;
        video[p2]=15;
        p1++;
        p2++;
        }
    p1=y1*320+x1;
    p2=y1*320+x2;
    for(y=y1;y<=y2;y++)
        {
        video[p1]=15;
        video[p2]=15;
        p1+=320;
        p2+=320;
        }
    ox1=x1;
    ox2=x2;
    oy1=y1;
    oy2=y2;
    }

void V_BoxOff(void)
    {
    int x,y,p1,p2;

    p1=oy1*320+ox1;
    p2=oy2*320+ox1;
    for(x=ox1;x<=ox2;x++)
        {
        video[p1]=screen[p1];
        video[p2]=screen[p2];
        p1++;
        p2++;
        }
    p1=oy1*320+ox1;
    p2=oy1*320+ox2;
    for(y=oy1;y<=oy2;y++)
        {
        video[p1]=screen[p1];
        video[p2]=screen[p2];
        p1+=320;
        p2+=320;
        }
    }

int V_blockarea(char *outname)
    {
    int x1,y1,x2,y2,restart;

    M_Init();
    M_ShowCursor();

    restart=1;
    while(restart!=0) {
        restart=0;
        M_GetButtonPress(LEFT_BUTTON);
        x1=M_CurX/2;
        y1=M_CurY;
        while(M_CurButtons&LEFT_BUTTON)
            M_GetCurPos();

        while(!M_CurButtons) {
            M_GetCurPos();
            waitvrt();
            M_HideCursor();
            V_BoxOff();
            x2=M_CurX/2;
            y2=M_CurY;
            M_ShowCursor();
            V_BoxOn(x1,y1,x2,y2);
            if(M_CurButtons&RIGHT_BUTTON) restart=1;
            }
        if(restart) V_BoxOff();
        }
    M_Init();
    tmode();
    if(output_type==ASM_DATA) F_WriteAsmImage(x1,y1,x2,y2,outname);
    else F_WriteCImage(x1,y1,x2,y2,outname);
    return(0);
    }


int F_Loadraw(char *fname)
    {
    int fh;

    fh=_open(fname,O_RDONLY);
    if(fh==NULL) return(-1);

    screen=farmalloc(64000);
    if(screen==NULL) return(-1);
    pal=farmalloc(768);
    if(pal==NULL) return(-1);

    _read(fh,pal,768);
    _read(fh,screen,64000);
    return(0);
    }

int V_Drawscreen(void)
    {
    int x;

    grmode();

    asm {
        mov dx,03C8h
        xor ax,ax
        out dx,al
        inc dx
        }
    for(x=0;x<768;x++)
        {
        _AL=pal[x];
        asm out dx,al
        }
    _fmemcpy(video,screen,64000);
    return(0);
    }

void main(int argc,char **argv)
    {
    if(argc<3) {
        printf("BIN2ASM, (c) 1994 Friar Tuck/Shadow Faction\n");
        printf("\nUsage: BIN2ASM infile.SCR outfile.??? [C]\n");
        printf(" the 'C' flag creates a C header file. Default is Assembly\n");
        printf(" format.\n");
        printf("\n");
        exit(0);
        }
    if(!strcmpi(argv[3],"C")) output_type=C_DATA;
    if(F_Loadraw(argv[1])==-1) exit(0);
    V_Drawscreen();
    V_blockarea(argv[2]);
    }

