
/* crctab calculated by Mark G. Mendel, Network Systems Corporation */
unsigned short crctab[256] = {
0x0000u,  0x1021u,  0x2042u,  0x3063u,  0x4084u,  0x50a5u,  0x60c6u,
0x70e7u,
0x8108u,  0x9129u,  0xa14au,  0xb16bu,  0xc18cu,  0xd1adu,  0xe1ceu,
0xf1efu,
0x1231u,  0x0210u,  0x3273u,  0x2252u,  0x52b5u,  0x4294u,  0x72f7u,
0x62d6u,
0x9339u,  0x8318u,  0xb37bu,  0xa35au,  0xd3bdu,  0xc39cu,  0xf3ffu,
0xe3deu,
0x2462u,  0x3443u,  0x0420u,  0x1401u,  0x64e6u,  0x74c7u,  0x44a4u,
0x5485u,
0xa56au,  0xb54bu,  0x8528u,  0x9509u,  0xe5eeu,  0xf5cfu,  0xc5acu,
0xd58du,
0x3653u,  0x2672u,  0x1611u,  0x0630u,  0x76d7u,  0x66f6u,  0x5695u,
0x46b4u,
0xb75bu,  0xa77au,  0x9719u,  0x8738u,  0xf7dfu,  0xe7feu,  0xd79du,
0xc7bcu,
0x48c4u,  0x58e5u,  0x6886u,  0x78a7u,  0x0840u,  0x1861u,  0x2802u,
0x3823u,
0xc9ccu,  0xd9edu,  0xe98eu,  0xf9afu,  0x8948u,  0x9969u,  0xa90au,
0xb92bu,
0x5af5u,  0x4ad4u,  0x7ab7u,  0x6a96u,  0x1a71u,  0x0a50u,  0x3a33u,
0x2a12u,
0xdbfdu,  0xcbdcu,  0xfbbfu,  0xeb9eu,  0x9b79u,  0x8b58u,  0xbb3bu,
0xab1au,
0x6ca6u,  0x7c87u,  0x4ce4u,  0x5cc5u,  0x2c22u,  0x3c03u,  0x0c60u,
0x1c41u,
0xedaeu,  0xfd8fu,  0xcdecu,  0xddcdu,  0xad2au,  0xbd0bu,  0x8d68u,
0x9d49u,
0x7e97u,  0x6eb6u,  0x5ed5u,  0x4ef4u,  0x3e13u,  0x2e32u,  0x1e51u,
0x0e70u,
0xff9fu,  0xefbeu,  0xdfddu,  0xcffcu,  0xbf1bu,  0xaf3au,  0x9f59u,
0x8f78u,
0x9188u,  0x81a9u,  0xb1cau,  0xa1ebu,  0xd10cu,  0xc12du,  0xf14eu,
0xe16fu,
0x1080u,  0x00a1u,  0x30c2u,  0x20e3u,  0x5004u,  0x4025u,  0x7046u,
0x6067u,
0x83b9u,  0x9398u,  0xa3fbu,  0xb3dau,  0xc33du,  0xd31cu,  0xe37fu,
0xf35eu,
0x02b1u,  0x1290u,  0x22f3u,  0x32d2u,  0x4235u,  0x5214u,  0x6277u,
0x7256u,
0xb5eau,  0xa5cbu,  0x95a8u,  0x8589u,  0xf56eu,  0xe54fu,  0xd52cu,
0xc50du,
0x34e2u,  0x24c3u,  0x14a0u,  0x0481u,  0x7466u,  0x6447u,  0x5424u,
0x4405u,
0xa7dbu,  0xb7fau,  0x8799u,  0x97b8u,  0xe75fu,  0xf77eu,  0xc71du,
0xd73cu,
0x26d3u,  0x36f2u,  0x0691u,  0x16b0u,  0x6657u,  0x7676u,  0x4615u,
0x5634u,
0xd94cu,  0xc96du,  0xf90eu,  0xe92fu,  0x99c8u,  0x89e9u,  0xb98au,
0xa9abu,
0x5844u,  0x4865u,  0x7806u,  0x6827u,  0x18c0u,  0x08e1u,  0x3882u,
0x28a3u,
0xcb7du,  0xdb5cu,  0xeb3fu,  0xfb1eu,  0x8bf9u,  0x9bd8u,  0xabbbu,
0xbb9au,
0x4a75u,  0x5a54u,  0x6a37u,  0x7a16u,  0x0af1u,  0x1ad0u,  0x2ab3u,
0x3a92u,
0xfd2eu,  0xed0fu,  0xdd6cu,  0xcd4du,  0xbdaau,  0xad8bu,  0x9de8u,
0x8dc9u,
0x7c26u,  0x6c07u,  0x5c64u,  0x4c45u,  0x3ca2u,  0x2c83u,  0x1ce0u,
0x0cc1u,
0xef1fu,  0xff3eu,  0xcf5du,  0xdf7cu,  0xaf9bu,  0xbfbau,  0x8fd9u,
0x9ff8u,
0x6e17u,  0x7e36u,  0x4e55u,  0x5e74u,  0x2e93u,  0x3eb2u,  0x0ed1u,
0x1ef0u
};



unsigned long cr3tab[] = { /* CRC polynomial 0xedb88320 */
0x00000000ul, 0x77073096ul, 0xee0e612cul, 0x990951baul, 0x076dc419ul,
0x706af48ful, 0xe963a535ul, 0x9e6495a3ul,
0x0edb8832ul, 0x79dcb8a4ul, 0xe0d5e91eul, 0x97d2d988ul, 0x09b64c2bul,
0x7eb17cbdul, 0xe7b82d07ul, 0x90bf1d91ul,
0x1db71064ul, 0x6ab020f2ul, 0xf3b97148ul, 0x84be41deul, 0x1adad47dul,
0x6ddde4ebul, 0xf4d4b551ul, 0x83d385c7ul,
0x136c9856ul, 0x646ba8c0ul, 0xfd62f97aul, 0x8a65c9ecul, 0x14015c4ful,
0x63066cd9ul, 0xfa0f3d63ul, 0x8d080df5ul,
0x3b6e20c8ul, 0x4c69105eul, 0xd56041e4ul, 0xa2677172ul, 0x3c03e4d1ul,
0x4b04d447ul, 0xd20d85fdul, 0xa50ab56bul,
0x35b5a8faul, 0x42b2986cul, 0xdbbbc9d6ul, 0xacbcf940ul, 0x32d86ce3ul,
0x45df5c75ul, 0xdcd60dcful, 0xabd13d59ul,
0x26d930acul, 0x51de003aul, 0xc8d75180ul, 0xbfd06116ul, 0x21b4f4b5ul,
0x56b3c423ul, 0xcfba9599ul, 0xb8bda50ful,
0x2802b89eul, 0x5f058808ul, 0xc60cd9b2ul, 0xb10be924ul, 0x2f6f7c87ul,
0x58684c11ul, 0xc1611dabul, 0xb6662d3dul,
0x76dc4190ul, 0x01db7106ul, 0x98d220bcul, 0xefd5102aul, 0x71b18589ul,
0x06b6b51ful, 0x9fbfe4a5ul, 0xe8b8d433ul,
0x7807c9a2ul, 0x0f00f934ul, 0x9609a88eul, 0xe10e9818ul, 0x7f6a0dbbul,
0x086d3d2dul, 0x91646c97ul, 0xe6635c01ul,
0x6b6b51f4ul, 0x1c6c6162ul, 0x856530d8ul, 0xf262004eul, 0x6c0695edul,
0x1b01a57bul, 0x8208f4c1ul, 0xf50fc457ul,
0x65b0d9c6ul, 0x12b7e950ul, 0x8bbeb8eaul, 0xfcb9887cul, 0x62dd1ddful,
0x15da2d49ul, 0x8cd37cf3ul, 0xfbd44c65ul,
0x4db26158ul, 0x3ab551ceul, 0xa3bc0074ul, 0xd4bb30e2ul, 0x4adfa541ul,
0x3dd895d7ul, 0xa4d1c46dul, 0xd3d6f4fbul,
0x4369e96aul, 0x346ed9fcul, 0xad678846ul, 0xda60b8d0ul, 0x44042d73ul,
0x33031de5ul, 0xaa0a4c5ful, 0xdd0d7cc9ul,
0x5005713cul, 0x270241aaul, 0xbe0b1010ul, 0xc90c2086ul, 0x5768b525ul,
0x206f85b3ul, 0xb966d409ul, 0xce61e49ful,
0x5edef90eul, 0x29d9c998ul, 0xb0d09822ul, 0xc7d7a8b4ul, 0x59b33d17ul,
0x2eb40d81ul, 0xb7bd5c3bul, 0xc0ba6cadul,
0xedb88320ul, 0x9abfb3b6ul, 0x03b6e20cul, 0x74b1d29aul, 0xead54739ul,
0x9dd277aful, 0x04db2615ul, 0x73dc1683ul,
0xe3630b12ul, 0x94643b84ul, 0x0d6d6a3eul, 0x7a6a5aa8ul, 0xe40ecf0bul,
0x9309ff9dul, 0x0a00ae27ul, 0x7d079eb1ul,
0xf00f9344ul, 0x8708a3d2ul, 0x1e01f268ul, 0x6906c2feul, 0xf762575dul,
0x806567cbul, 0x196c3671ul, 0x6e6b06e7ul,
0xfed41b76ul, 0x89d32be0ul, 0x10da7a5aul, 0x67dd4accul, 0xf9b9df6ful,
0x8ebeeff9ul, 0x17b7be43ul, 0x60b08ed5ul,
0xd6d6a3e8ul, 0xa1d1937eul, 0x38d8c2c4ul, 0x4fdff252ul, 0xd1bb67f1ul,
0xa6bc5767ul, 0x3fb506ddul, 0x48b2364bul,
0xd80d2bdaul, 0xaf0a1b4cul, 0x36034af6ul, 0x41047a60ul, 0xdf60efc3ul,
0xa867df55ul, 0x316e8eeful, 0x4669be79ul,
0xcb61b38cul, 0xbc66831aul, 0x256fd2a0ul, 0x5268e236ul, 0xcc0c7795ul,
0xbb0b4703ul, 0x220216b9ul, 0x5505262ful,
0xc5ba3bbeul, 0xb2bd0b28ul, 0x2bb45a92ul, 0x5cb36a04ul, 0xc2d7ffa7ul,
0xb5d0cf31ul, 0x2cd99e8bul, 0x5bdeae1dul,
0x9b64c2b0ul, 0xec63f226ul, 0x756aa39cul, 0x026d930aul, 0x9c0906a9ul,
0xeb0e363ful, 0x72076785ul, 0x05005713ul,
0x95bf4a82ul, 0xe2b87a14ul, 0x7bb12baeul, 0x0cb61b38ul, 0x92d28e9bul,
0xe5d5be0dul, 0x7cdcefb7ul, 0x0bdbdf21ul,
0x86d3d2d4ul, 0xf1d4e242ul, 0x68ddb3f8ul, 0x1fda836eul, 0x81be16cdul,
0xf6b9265bul, 0x6fb077e1ul, 0x18b74777ul,
0x88085ae6ul, 0xff0f6a70ul, 0x66063bcaul, 0x11010b5cul, 0x8f659efful,
0xf862ae69ul, 0x616bffd3ul, 0x166ccf45ul,
0xa00ae278ul, 0xd70dd2eeul, 0x4e048354ul, 0x3903b3c2ul, 0xa7672661ul,
0xd06016f7ul, 0x4969474dul, 0x3e6e77dbul,
0xaed16a4aul, 0xd9d65adcul, 0x40df0b66ul, 0x37d83bf0ul, 0xa9bcae53ul,
0xdebb9ec5ul, 0x47b2cf7ful, 0x30b5ffe9ul,
0xbdbdf21cul, 0xcabac28aul, 0x53b39330ul, 0x24b4a3a6ul, 0xbad03605ul,
0xcdd70693ul, 0x54de5729ul, 0x23d967bful,
0xb3667a2eul, 0xc4614ab8ul, 0x5d681b02ul, 0x2a6f2b94ul, 0xb40bbe37ul,
0xc30c8ea1ul, 0x5a05df1bul, 0x2d02ef8dul
};

/*
 * updcrc macro derived from article Copyright (C) 1986 Stephen Satchell. 
 *  NOTE: First argument must be in range 0 to 255.
 *        Second argument is referenced twice.
 * 
 * Programmers may incorporate any or all code into their programs, 
 * giving proper credit within the source. Publication of the 
 * source routines is permitted so long as proper credit is given 
 * to Stephen Satchell, Satchell Evaluations and Chuck Forsberg, 
 * Omen Technology.
*/

extern unsigned short crctab[256];
#define updcrc(cp, crc) ( crctab[((crc >> 8) & 255)] ^ (crc << 8) ^ cp)

extern unsigned long cr3tab[]; /* CRC polynomial 0xedb88320 */
#define UPDC32(b, c) (cr3tab[((int)c^b) & 0xffu]^((c >> 8) & 0x00FFFFFFul))

/* -------------------- calc_crc16() ------------------- January 10,1996 */
unsigned short calc_crc16(char *s, unsigned int len)
{
   unsigned short crc=0;

   while ( len )
      {
		crc=updcrc((0377 & *s), crc);
      s++;
      len--;
      }

   return crc;
   
}


/* --------------------- calc_crc32() ------------------- January 10,1996 */
unsigned long calc_crc32(char *s, unsigned int len)
{
   unsigned long crc=0;

   while ( len )
      {
		crc=UPDC32((0377 & *s), crc);
      s++;
      len--;
      }

   return crc;
   
}
