/*

  Alec Russell 1995

  A simple example of scanning down through a directory tree.

*/

#include <stdio.h>
#include <stdlib.h>
#include <dir.h>
#include <dos.h>


/* ---------------------- scan_files() --------------- September 20,1993 */
void scan_files(char *path)
{
   struct ffblk fb;
   char start_path[90];

   getcwd(start_path, 90);
   if ( chdir(path) )
      {
      printf("ERROR changing to %s\n", path);
      exit(1);
      }

   memset((char *)&fb, 0, sizeof(fb));

   // recursively scan down thru the directory tree
   if ( !findfirst("*.*", &fb, FA_DIREC) )
      {
      do
         {
         if ( *fb.ff_name != '.'  )
            {
            if ( (fb.ff_attrib & FA_DIREC) )
               scan_files(fb.ff_name);
            else
               {
               printf("File: %-15.15s", fb.ff_name);
               }
            }

         }
      while ( !findnext(&fb) );
      }

   chdir(start_path);
}

