#if 0
In article <1995Dec8.143155.4386@nedcu0>, N S GHAI <ghai@imt.unine.ch> wrote:

> I have data from an image which is 80Kbytes. So by allocating the memory
> using farmalloc()  I am able to fill the memory array, but when I try to
> access it, the data is not accessable after 64Kbyte.(Because of
> segmentation) .The outline of the code is here:
> 
> char far *mydata;
> main()
> {
> long SIZE=80000;
> char data;
> if((mydata=(char far *)farmalloc(SIZE*sizeof(char))==NULL)
> cout<<"MEMROY ALLOCATION ERROR";
> Imagecopy(image,&mydata); //A function to copy the imagedata to                                
!!! why &mydata?

AJR:
I bet Imagecopy is defines as 
Imagecopy(char far *src, char far *dest);
in which case the & isn't needed.

> //mydata
> for(long i=0; i < SIZE ;i++ )                                                        
>    data=mydata[i];                 //To acess the data from the array
>                                 //Here data remains valid till 'i'
reaches                                      //65000  after
>                                 //that it is not better.
[snip]

In a Microsoft environment, "far" pointers only use 16 bit address
arithmetic on the offset, causing the pointer to wrap at 64K. A "huge"
pointer (not the same as huge memory model) uses 32 bit address
arithmetic.

AJR writes:
huge pointer will work, but be horribly slow.
The compiler will re-normalize the pointer everytime you access it.

char huge *mydata;
char huge *src;


// slow using huge pointers, but adequate with todays fast cpu's
Imagecopy(char huge *image, char huge *mydata, long size)
{
   while ( size )
      {
      *mydata++=*src++;
      size--;
      }
}


void foo(void)
{
   mydata=(char huge *)farmalloc(SIZE);
   if ( mydata )
      {
      // src magiclly set somewhere else
      Imagecopy(src, mydata, SIZE);
      }
   else
      {
      printf("rats! out of mem\n");
      }
}

#endif

// Now if we want the speed of far pointers we have to do the pointer
// normalization ourselfs.


#include <stdio.h>
#include <malloc.h>
#include <dos.h>
#include <string.h>

#define SIZE 80000lu
#define LESS64K 64000u
// we don't use 65536u because a normalized pointer doesn't 
// have an offset of zero very often

char far *mydata;
char far *src;

/*
_fmemcpy(unsigned char far *, unsigned char far *, unsigned int size);

If in a far memmodel you can just use plain memcpy(), but if in a near mem
model must use a far version of memcpy()

in most compilers this is implemented with a rep movs so it is faster than the
c loop used above.

*/


/* alter a far pointer so that the offset is zero,
   handy if the data is actualy > 64k long */
/* ---------------------- normalize() -------------------- March 26,1993 */
char far *normalize(char far *p)
{

   unsigned short seg,off;

	seg = FP_SEG(p);
	off = FP_OFF(p);
	seg += (off>>4);
	off &= 0x000f;
	p = MK_FP(seg,off);

   return(p);
}

// NOT tested! probably works, but its just to show the technique
// faster using far pointers
void Imagecopy(char far *src, char far *mydata, long size)
{
   unsigned int i;
   while ( size )
      {
      // normalize src and mydata
      src=normalize(src);
      mydata=normalize(mydata);

      i=LESS64K;
      if ( size > i )
         {
         // copy 65000
         _fmemcpy(src, mydata, LESS64K);
         src+=LESS64K;
         mydata+=LESS64K;
         size-=LESS64K;
         }
      else
         {
         // copy remainder
         _fmemcpy(src, mydata, size);
         size=0;
         }

      }
}


void foo(void)
{
   mydata=(char far *)farmalloc(SIZE);
   if ( mydata )
      {
      // src magiclly set somewhere else
      Imagecopy(src, mydata, SIZE);
      }
   else
      {
      printf("rats! out of mem\n");
      }
}
