/*

    joy.c

    Internet: alexad3@icebox.iceonline.com


   a C fragment containing (ick!) in-line assembly code
   to read joystick 1, and its buttons


   You will also need code to calibrate the joystick, but that's
   trivial.

*/


/* note!!!! buttons are pressed when b0, b1 is zero (0)

   Also, the values returned by this routine will vary widely
   on machines that run at different speeds for joy_x and y

   reads joy1 only

   if joystick is not plugged in the joy_x and joy_y will both
   be 1023

   generaly you read the joystick at fixed intervals because
   it is a slow process, and the buttons more frequently.

*/

short joy_x, joy_y;
BYTE b0, b1;


/* sets the global vars b1, and b0 */
/* ---------------------- read_joy_buttons() -------------- June 10,1993 */
void read_joy_buttons(void)
{
   asm {

               mov    dx,201h
               xor    ax, ax
               in     al,dx

               mov    bl, al
               and    bl, 010h
               mov    b0, bl

               and    al, 020h
               mov    b1, al
       }
}


/* sets the global vars joy_x, joy_y, b0, b1 - SLOW!!! */
/* this is slow compared to just checking the buttons.
   in many projects I only check the joystick once/(certain time)
   and the buttons more frequently.
*/
   
/* ---------------------- read_joy() --------------------- March 29,1993 */
void read_joy(void)
{
   asm {
               push   si

               xor    ax,ax
/* joystick port */
               mov    dx,201h
               mov    cx,ax
               mov    bx,ax
               mov    si, 1024   /* this number may have to be LARGER on
                                  FAST machines */

               cli    /* disable interupts so that our timing loop isn't
                         interupted */

/* begin digitize, prime joy port */
               out    dx,al
       }
jlp:           
   asm {
               dec    si
               jz     abt          /* timeout */
/* read port */
               in     al,dx
               test   al,1
               jz     nox
/* increment x counter if bit 0 high */
               inc    bx
       }
nox:           
   asm {
               test   al,2
               jz     noy
/* increment y counter if bit 1 high */
               inc    cx
       }
noy:           
   asm {
               test   al,3
/* keep going until both x and y done */
               jnz    jlp
       }
abt:           
   asm {
               sti    /* enable interupts */

/* store x and y coordinates, and button stats */

               mov    joy_y, cx
               mov    joy_x, bx

               mov    bl, al
               and    bl, 010h
               mov    b0, bl

               and    al, 020h
               mov    b1, al

               pop    si
       }

}
