/*

    led.c

    Internet: alexad3@icebox.iceonline.com
    Copyright 1995, January 15 by Alec Russell, NO rights reserved

    Created - 1995/1/15

    History:
        New file

   code fragments to turn on the LED lights.
   Your program would have to track the status of all lights
   and send the correct bits instead of just CAPLOCK

   ONLY use this code in an int 9 replacement.
   If the BIOS keyboard handler is running,
   just set the bit mask in BIOS data area.

*/




/* keyboard controller and LED lights stuff */
#define KEYSTATUS 0x64
#define KEYDATA  0x60
#define LEDUPDATE 0xed
#define OB_FULL 1
#define IB_FULL 2
#define KEY_ACK 0xfa

/* bit masks to be sent */
#define SCROLLOCK 1
#define NUMLOCK 2
#define CAPLOCK 4


/* ---------------------- send_keycontrol() ------------ January 15,1995 */
short send_keycontrol(BYTE v)
{
   short count, err=1;
   BYTE c;

   for ( count=0; count < 3; count++ )
      {
      do
         {
         c=inportb(KEYSTATUS);
         }
      while ( c & IB_FULL );

      outportb(KEYDATA, v);
      do
         {
         c=inportb(KEYSTATUS);
         }
      while ( c & OB_FULL);

      c=inportb(KEYDATA);
      if ( c == KEY_ACK )
         {
         err=0;
         break;
         }
      }

   return err;
}



/* ---------------------- cap_light_on() --------------- January 15,1995 */
void cap_light_on(void)
{
   if ( !send_keycontrol(LEDUPDATE) ) /* tell keyboard next byte is led bitmask */
      send_keycontrol(CAPLOCK);       /* the led bitmask */
}
