/*


    pr2: copyright 1992, Alec Russell, all rights reserved

    Author: Alec Russell

    direct MDA output routines

    usefull for debugging


   Created: March 2, 1992


   Tested in Medium mem model (near data, far code)

   Borland C++ 3.1 used.
   _f....() are far only versions of the functions

*/



#include <stdio.h>
#include <dos.h>
#include <string.h>
#include <stdarg.h>
#include <conio.h>



/* set to zero to skip the main() so you can link with other stuff */
#define TEST 1

#pragma inline

unsigned int mda_segment=0xB000;  /* mda */
/* unsigned int mda_segment=0xB800; */   /* cga/ega/vga */

/* to use the CGA/EGA/VGA text screen, change
  mda_segment to 0xB800

*/


/* a C version of pr2_low that is memory model independent */
/* ---------------------- pr2_lowc() ------------------- January 27,1994 */
void pr2_lowc(unsigned char attr, int x, int y, char *s)
{
   int off;
   unsigned char far *mda_p;

   if ( *s )
      {
      off=160*y + (x<<1);
      mda_p=MK_FP(mda_segment, off);
      while ( *s )
         {
         *mda_p++=*s++;
         *mda_p++=attr;
         }

      }

}


/* This code ASSUMES s is a NEAR pointer !!! */
/* for a far s use     lds di, s,
   del mov di, s
   and pop and push ds
*/
/* attr:text */
/* ----------------------- pr2_low() ---------------------- March 11,1991 */
void pr2_low(unsigned char attr, int x, int y, char *s)
{
   int len, off;

   len=strlen(s);
   if ( len )
      {
      off=160*y + (x<<1);

      asm      {
                  push di
                  push si

                  mov ah, attr
                  mov di, s
                  mov es, mda_segment
                  mov si, off
                  mov cx, len
                  }
         start:
      asm      {
                  mov al, [di]
                  mov es:si, ax
                  inc di
                  inc si
                  inc si

                  loop start

                  pop si
                  pop di
         }
      }
}


int gb_pr2_y=0;

/* ---------------------- pr2() ----------------------- February 29,1992 */
void pr2(char *s, ...)
{
static char out[256];
    va_list arg_ptr;

    va_start(arg_ptr, s);
    vsprintf(out, s, arg_ptr);
    va_end(arg_ptr);


    pr2_low(0x03, 0, gb_pr2_y, out);
    ++gb_pr2_y;
    if ( gb_pr2_y > 24 )
        {
        /* scroll screen */
        asm {
            push ds

            mov es, mda_segment
            mov di, 0

            mov ds, mda_segment
            mov si, 160
            cld
            }

        start:
        asm {
            mov cx, 3840
            rep movsb

            mov ax, 0
            mov cx, 160
            rep stosb

            pop ds
            }

        gb_pr2_y=24;
        }

}

/* ---------------------- clear_pr2() ----------------- February 29,1992 */
void clear_pr2(void)
{

    /* init mda ?? */
    /* outportb(0x3b8, 8);   this disables the blinking */

    gb_pr2_y=0;

    /* clear mda */
    asm {
        push ds

        mov bx, 25
        mov si, 0

        mov di, 0
        mov es, mda_segment
        mov ax, 0
        cld
        }

    start:
    asm {
        mov cx, 160
        rep stosb

        add di, si
        dec bx
        jnz start

        pop ds
        }
}


/* ---------------------- clear_pr2c() ----------------- January 14,1995 */
void clear_pr2c(void)
{
   unsigned char far *mda_p;


   /* outportb(0x3b8, 8);   this disables the blinking  */

   gb_pr2_y=0;
   mda_p=MK_FP(mda_segment, 0);

   _fmemset(mda_p, 0, 80*2*25); /* 80 chars, 2 bytes per char, 25 lines */

}



/* ---------------------- pr2c() ----------------------- February 29,1992 */
void pr2c(char *s, ...)
{
   static char out[256];
   unsigned char far *mda_p1, far *mda_p2;
   va_list arg_ptr;

    va_start(arg_ptr, s);
    vsprintf(out, s, arg_ptr);
    va_end(arg_ptr);


    pr2_lowc(0x03, 0, gb_pr2_y, out);
    ++gb_pr2_y;
    if ( gb_pr2_y > 24 )
        {
        /* scroll screen */
         mda_p1=MK_FP(mda_segment, 0);
         mda_p2=MK_FP(mda_segment, 160);
         _fmemmove(mda_p1, mda_p2, 3840); /* 2*80*24 */

         /* clear last line */
         mda_p1=MK_FP(mda_segment, 3840);
         _fmemset(mda_p1, 0, 160);
        gb_pr2_y=24;
        }

}


#if TEST

/* for testing */

/* ---------------------- main() -------------------------- March 1,1992 */
void main(void)
{
   int i;
   char temp[90];


   printf("Testing clearc and lowc, press a key\n");

   clear_pr2c();

   getch();

   for ( i=1; i < 20; i++ )
      {
      sprintf(temp, ">line %d ---<", i);
      puts(temp);
      pr2_lowc(3, 1, i, temp);
      }

   puts("Press a key");
   getch();

   printf("The asm versions, press a key\n");
   clear_pr2();
   getch();

   for ( i=0; i < 70; i++ )
      {
      sprintf(temp, ">line %d ---<", i);
      puts(temp);
      pr2(temp);
      if ( i == 20 )
         getch();
      }

   puts("Press a key");
   getch();
}

#endif



/* ------------------- end of file ----------------------------- */
