#include <stdio.h>
#include <io.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <alloc.h>
#include <mem.h>
#include <dos.h>
#include <errno.h>

#include "vidlib.h"
#include "pcxlib.h"

/*/////////////////////////////////////////////////////////////////////////
// fread4PCX
//          expects destination to be organized as 1 byte per pixel
///////////////////////////////////////////////////////////////////////////*/
int   fread4PCX(char *d, unsigned dw, unsigned dl, unsigned dx, unsigned dy,
                unsigned x0, unsigned y0, unsigned x1, unsigned y1, PCXF *p)
{
    int h,m,k;
    char r,g,b,i,nibbles, tpal[3];
    char *Plane0, *Plane1, *Plane2, *Plane3, *dest;

    if (pcxdebug) {
       fprintf(pcxdebug,
               "fread4PCX(%Fp, %u, %u,  %u, %u,  %u, %u,  %u, %u,  %Fp\n",
               d, dw, dl, dx, dy, x0, y0, x1, y1, p);
    }
    /* Allocate memory for the scan line buffers */
    Plane0=(char *)malloc(p->h->bytesline*4);
    if (Plane0 == NULL) {
       PCXerror=ENOMEM; return(-1);
    }
    Plane1=Plane0+p->h->bytesline;
    Plane2=Plane1+p->h->bytesline;
    Plane3=Plane2+p->h->bytesline;

    dest=(char *)normalize(d + dy*dw + dx);
    /* 16 color PCX files interleve scanlines for each color    */
    for (h=y0; h<y1+1; h++)  {
        _read_pcx_line(p,Plane0, x0, x1);
        _read_pcx_line(p,Plane1, x0, x1);
        _read_pcx_line(p,Plane2, x0, x1);
        _read_pcx_line(p,Plane3, x0, x1);
        /* 16 color bitmaps have 4 bits per pixel               */
        for ( m=0; m < p->h->bytesline; ++m) {
            r = Plane0[m];
            g = Plane1[m];
            b = Plane2[m];
            i = Plane3[m];
            /* Combine a bit from each 4 scan lines into a 4-bit nibble */
            nibbles = 0;
            for ( k=0; k<4; ++k) {
                nibbles = 0;
                /* If the most significant bit is set... */
                /* Set the appropriate bit in the higher order nibble */
                if (r & '\x80') nibbles |= 0x10;
                if (g & '\x80') nibbles |= 0x20;
                if (b & '\x80') nibbles |= 0x40;
                if (i & '\x80') nibbles |= 0x80;
                r<<=1; g<<=1; b<<=1; i<<=1;
                /* Repeat for the lower order nibble */
                if (r & '\x80') nibbles |= 0x01;
                if (g & '\x80') nibbles |= 0x02;
                if (b & '\x80') nibbles |= 0x04;
                if (i & '\x80') nibbles |= 0x08;
                r<<=1; g<<=1; b<<=1; i<<=1;
                *dest++ = nibbles;
            }
        }
        dest=(char *)normalize(d + (h-y0+dy)*dw + dx);
    }
    free(Plane0);
    return(h-y0);
}

/*/////////////////////////////////////////////////////////////////////////
// fdisp4PCX
///////////////////////////////////////////////////////////////////////////*/
int   fdisp4PCX(unsigned dx, unsigned dy,
                unsigned x0, unsigned y0, unsigned x1, unsigned y1, PCXF *p)
{
    int h,m,k,wmode,wplanes;
    char r,g,b,i,nibbles, tpal[3];
    char *dest;

    wmode=What_Wmode(); wplanes=What_WPlanes;
    Select_Wmode(0);
    if (pcxdebug) {
       fprintf(pcxdebug,
               "fdisp4PCX(%u, %u,  %u, %u,  %u, %u,  %Fp\n",
               dx, dy, x0, y0, x1, y1, p);
    }

    dest=(char *)normalize(_screen_start + dy*_screen_width + dx);
    /* 16 color PCX files interleve scanlines for each color    */
    for (h=y0; h<y1+1; h++)  {
        Select_WPlane(1);
        _read_pcx_line(p,dest, x0, x1);
        Select_WPlane(2);
        _read_pcx_line(p,dest, x0, x1);
        Select_WPlane(4);
        _read_pcx_line(p,dest, x0, x1);
        Select_WPlane(8);
        _read_pcx_line(p,dest, x0, x1);
        dest=(char *)normalize(dest + _screen_width);
    }
    Select_Wmode(wmode); Select_WPlane(wplanes);
    return(h);
}

