/* pcxlib.c  : A .PCX file decoder */
#include <stdio.h>
#include <io.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <alloc.h>
#include <mem.h>
#include <dos.h>
#include <errno.h>

#include "vidlib.h"   /* used in fdisp8PCX() */
#include "vesa.h"
#include "pcxlib.h"

/*/////////////////////////////////////////////////////////////////////////
//  int =fdisp8PCX       uses extern symbols _screen_start, _screen_width,
//    -1 on exit       _screen_length and _memory_length defined in vidlib.h
///////////////////////////////////////////////////////////////////////////*/
int   fdisp8PCX(unsigned dx, unsigned dy,
                unsigned x0, unsigned y0, unsigned x1, unsigned y1, PCXF *p)
{
   unsigned int vdy,lastdy;
   char *dest;

   if (pcxdebug) {
      fprintf(pcxdebug,"fdisp8PCX(%u, %u,  %u, %u,  %u, %u, %Fp). PCXerror=%i\n",
                       dx,dy,x0,y0, x1, y1, p, PCXerror);
   }
   if ( BIOScrtmode == 0x13 ) {
      return(fread8PCX( _screen_start, _screen_width, _memory_length,
                        dx,dy,x0,y0,x1,y1,p));
   } else { /* must be VESA mode, use buffers */
      lastdy=y1-y0+dy;
      while (y0 < y1+1) {
	 VESAsetpage(VESAwhat_page(dy,dx));
	 dest=(char *)normalize((char *)(0xA0000000L+VESApage_offset(dy,dx)));
         /* vdy=number of lines to do */
	 if (lastdy > Vnext_break_row)
	    vdy=Vnext_break_row-dy;
         else
            vdy=lastdy-dy;
         if (fread8PCX( dest, _screen_width, vdy, 0, 0,  x0, y0,
                    x1, y0+vdy-1, p) < 1) {
            return(-1);
         }
         y0+=vdy; dy+=vdy;
         if ( y0 < y1+1 ) {
            if (fread8PCX(p->buffer, _screen_width, 1, 0, 0, x0, y0,
                           x1, y0, p) < 1) {
                return(-1);
            }
            VESAdisp256(dx, dy, p->buffer, _screen_width, 16,
                                0, 0, x1-x0+1, 1,1);
            if (pcxdebug)
               fprintf(pcxdebug,"VESAdisp256(dx=%u, dy=%u, p->b=%Fp, _s_w=%u,"
                                " 16, 0, 0, sdx=%u, 1, 1)\n",
                                dx, dy, p->buffer,_screen_width, x1-x0+1);
            y0++; dy++;
         }
      } /* end while VESA loop */
   }
   return(1);
}

/*/////////////////////////////////////////////////////////////////////////
//  int =fread8PCX
//    -1 on error
///////////////////////////////////////////////////////////////////////////*/
int   fread8PCX(char *d, unsigned dw, unsigned dl, unsigned dx, unsigned dy,
                unsigned x0, unsigned y0, unsigned x1, unsigned y1, PCXF *p)
{
    int s;
    char *dest;

    if (pcxdebug) {
        fprintf(pcxdebug,"fread8PCX(%Fp, %u, %u,  %u, %u, "
                      " %u, %u,  %u, %u,  %Fp).\n",
                      d, dw, dl, dx, dy, x0, y0, x1, y1, p);
    }
    if ( (y1-y0+1 > dl-dy) || (x1-x0+1 > dw-dx) ||
       (dy > dl-1) || (dx > dw-1) ||
         (x0 > x1) || (x1+1 > p->w) ||
         (y0 > y1) || (y1+1 > p->l) ) {
       PCXerror=EINVAL;
       return(-1);
    }

    /* seek to first scan line to be read */
    if (fseekPCX(p, y0) == -1) {
       PCXerror=EINVDAT;
       return(-1);
    }

    if (pcxdebug) {
       fprintf(pcxdebug,"   fseekPCX(p,%u) -> ftell(p)=%li\n",
                        y0, ftell(p->fp));
    }
    /* there! */
    dest=(char *)normalize(d + dy*dw + dx);
    for ( s=y0; s <= y1; s++) {
        if ( ((s%16) == 0) && (s > 15))
           *(p->marks + (s/16-1))=ftell(p->fp);
        _read_pcx_line( p, dest, x0, x1);
	dest=(char *)normalize(dest+dw);
    }
    return( s );  /* return next scan line to read */
}

