/*  pcx.c  : a .PCX file viewer */

#include <stdio.h>
#include "pcxlib.h"

void PCXprint_header(PCXH *h);

void do_help(void)
{
  printf("pcxhdr will print the value in the pcx header"
         " block of file specified.\n");

}

void main(int argc, char *argv[])
{
    PCXH  pcx;
    FILE *fp;
    int i;

    if (argc < 2) { do_help(); exit(1); }
    if (!(fp=fopen(argv[1],"rb"))) {
       printf("Error opening \"%s\".\n", argv[1]);
       exit(2);
    }
    if ( fread(&pcx,sizeof(PCXH),1,fp) < 1 ) {
       printf("Error reading header from \"%s\".\n", argv[1]);
       exit(3);
    }
    PCXprint_header(&pcx);
}

/****************************************************************************
//    PCXprint_header
****************************************************************************/
void PCXprint_header(PCXH *pcx)
{
    int i;
    printf("Magic code    : %02x\n", pcx->MagicId);
    printf("Version       : %02x\n", pcx->Version);
    printf("Encoding      : %02x\n", pcx->Encoding);
    printf("Bits per Pixel: %02x\n", pcx->BitsPixel);
    printf("X min         : %u\n",   pcx->Xmin);
    printf("Y min         : %u\n",   pcx->Ymin);
    printf("X max         : %u\n",   pcx->Xmax);
    printf("Y max         : %u\n",   pcx->Ymax);
    printf("H res         : %u\n",   pcx->Hres);
    printf("V res         : %u\n",   pcx->Vres);
    if (pcx->BitsPixel < 5 ) {
	for (i=0; i<16; i++)
	    printf("Palette #%02u   : r %02x g %02x b %02x\n", i,
	       pcx->Palette[i].r, pcx->Palette[i].g, pcx->Palette[i].b);
    }
    printf("Planes        : %u\n",   pcx->Planes);
    printf("Bytes per Line: %u\n",   pcx->bytesline);
    printf("Palette Info  : %04x\n", pcx->PaletteInfo);
    return;
}


