/*  showpal.c */

#include <stdio.h>
#include "vidlib.h"
#include "pcxlib.h"

PCXF *pf1;
void palette_check(void);
char s[100];
char name[80];

void main(int argc, char *argv[])
{
    int i,c;

    sprintf(s,"PCXLIB v%s Showpal     by Dave Boynton\n", PCXLIB_VERSION);

    if (argc < 2) {
       puts(s);
       printf("You must specify an input .pcx file.\n");
       exit(1);
    }
    strncpy(name,argv[1],79); name[79]='0';

   /* Open debugging file */
   #ifdef DEBUG
   Start_pcxdebug("showpal.dbg");            /* start debugging */
   fprintf(pcxdebug,"\nMAIN: arguments are: 0=%s 1=%s\n", argv[0], name);
   fprintf(pcxdebug,"   sizeof(PCXF)=%u %xh, sizeof(PCXH)=%u %xh\n",
                    sizeof(PCXF), sizeof(PCXF), sizeof(PCXH), sizeof(PCXH));
   #endif
   /* Open pcx file */
   pf1=fopenPCXr(name); /* also reads header */
   if (pf1->type != PCX256colors ) {
      printf("Wrong pcx file, expected a 256 color file.\n");
      exit(1);
   }
   Vinit();

   VGAmode(0x13, pf1->palette);
   palette_check();
   Vgotoxy(0,0);
   putstty(s,0x1f);
   Vgotoxy(0,1);
   name[40]='0'; /* no more than 40 characters in a mode 0x13 line */
   putstty(name,0x1f);
   getch();

   Vclose();
   if (pcxdebug) fprintf(pcxdebug,"PCXerror=%i\n", PCXerror);
   fclosePCX(pf1);
   Close_pcxdebug();
   exit(0);
}

void palette_check(void)
{
   int i,j,c;
   Vfill256(0,0,320,200,0); /* clear screen */
   for (i=c=0; i<16; i++) {
       for (j=0; j<16; j++) {
           Vfill256(j*20,i*11+21,19,10,c);
           c++;
       }
   }
}


