#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <alloc.h>
#include <string.h>
#include <conio.h>
#include <errno.h>

#include "scancode.h"  /* used in the get_command() function */
#include "pcxlib.h"
#include "vidlib.h"  /* uses Vinit(), VGAmode(), and Vclose() */
#include "vesa.h"

/* Uncomment the next line to use VESA mode 0x101, if needed
   (it makes my screen jitter, so I don't use it) */
/* #define VESA101 */

int fx=0, fy=0, changed=1, quitflag=0; /* fx,fy = new from coordinates */
int tx, ty, dx, dy;
PCXF *pf;

void get_command(void);
void Check_PCXerror(void);  /* if an error, print msg and exit */
char fname[80];
char s[100];

/*///////////////////////////////////////////////////////////////////////////
//            m a i n                                                      //
///////////////////////////////////////////////////////////////////////////*/
void main(int argc, char *argv[])
{
   int   ofx, ofy; /* old coordinates. needed to detect a change */
   int  mode=0;

   sprintf(s,"PCXLIB v%s Showpcx    by Dave Boynton\n", PCXLIB_VERSION);

   /*********************************/
   /*   Initialization              */
   /*********************************/
   /* Sanity check */
   if ((argc < 2)||(*argv[1] == '/')||(*argv[1] == '-')){
      printf("%s\nYou must specify a filename to show.\n",s);
      printf("Once shown, use ESC to quit and clear the screen, \n"
             "or 'r' to quit without clearing. For large files, \n"
             "use the arrows, PGUP, PGDN, Home, and End keys to move.\n");
      exit(1);
   }
   strncpy(fname,argv[1],80); fname[79]='\0';

   /* Open debugging file */
   #ifdef DEBUG
   Start_pcxdebug("showpcx.dbg");
   if (pcxdebug) {
      fprintf(pcxdebug,"\nMAIN: arguments are: 0=%s 1=%s\n", argv[0], argv[1]);
      fprintf(pcxdebug,"   sizeof(PCXF)=%u %xh, sizeof(PCXH)=%u %xh\n",
                    sizeof(PCXF), sizeof(PCXF), sizeof(PCXH), sizeof(PCXH));
   }
   #endif

   /* Open pcx file */
   pf=fopenPCXr(fname); /* also reads header */
   Check_PCXerror();
   if (pf->type != PCX256colors ) {
      printf("Wrong pcx file, expected a 256 color file.\n");
      exit(1);
   }

   /* Ready VGA display mode 13h or VESA modes 100h or 101h */
   if ( !isVGA() ) {
      printf("This test program is for VGAs and VESAs only.\n");
      fclosePCX(pf);
      exit(1);
   }

   Vinit();
   #ifdef VESA101
   if ( isVESA() && (pf->l > 400) ) {
      if (VESAmode(0x101,pf->palette) != 0)
         mode=0x101;
   }
   #endif
   if ( !mode && isVESA() /* && ((pf->l > 200) || (pf->w > 320)) */ ) {
      if (VESAmode(0x100,pf->palette) != 0)
         mode=0x100;
   }
   if ( !mode ) {
      if (VGAmode(0x13,pf->palette) == 0) {
         printf("VGA mode change failed.\n");
         fclosePCX(pf);
         exit(2);
      }
      mode=0x13;
   }
   /* any other functions which set the modes, update the _screen_start,
     _screen_width, and _screen_length variables would work */

   /* setup initial values */
   fy=0; fx=0;
   if ( pf->l < _screen_length ) {
      dy=(_screen_length- pf->l)/2;
      ty=fy+pf->l-1;
   } else {
      dy=0;
      ty=_screen_length-1;
   }
   if ( pf->w < _screen_width ) {
      dx=(_screen_width - pf->w)/2;
      tx=fx+pf->w-1;
   } else {
      dx=0;
      tx=_screen_width-1;
   }

   Vgotoxy(0,BIOScrtrows-1);
   putstty(s,0x1f);
   Vgotoxy(0,BIOScrtrows);
   putstty(fname,0x1f);
   Vgotoxy(0,0);
   /*********************************/
   /* End intialization, main loop: */
   /* loop until unknown key is hit */
   /*********************************/
   while (!quitflag) {
      if (changed) {   /* if our coordinates have changed, redisplay */
         if (pcxdebug) {
            fprintf(pcxdebug,
                "_s_w=%u, _s_l=%u, dx=%u, dy=%u, fx=%u, fy=%u, "
                "tx=%u, ty=%u, PCXerror=%i\n",
                 _screen_width, _screen_length, dx, dy, fx, fy, tx, ty,
                 PCXerror);
         }
         if (fdisp8PCX( dx, dy, fx, fy, tx, ty, pf) == -1) {
            quitflag=1;
            break; /* return == -1 indicates an error, break out */
         } else { /* everything's fine, continue loop */
            changed=0;
         }
      } /* end if changed */
      ofx=fx; ofy=fy;
      get_command();
      if ( (fx != ofx) || (fy != ofy) ) changed=1;
   } /* end while(!quitflag) */

   /*********************************/
   /* end of program                */
   /*********************************/
   if (quitflag == 1) {  /* if quitflag == 2 , don't reset mode! */
      Vclose(); /* resets original mode */
   }
   fclosePCX(pf); Close_pcxdebug();
   Check_PCXerror();
   exit(0);
}
/************************************************************************/
/************************************************************************/

void Check_PCXerror(void)
{
   if (PCXerror) {
      errno=PCXerror;
      perror(fname);
      exit(errno);
   }
}


/*//////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////*/
void get_command(void)
{
      int inkey;

      inkey=getch();
      if (inkey) {      /* if regular, non-function, non-arrow, key */
         switch(inkey) {
            case 'r' :
            case 'R' : quitflag=2;  /* == don't reset mode on exit */
                       break;
            case ESC : quitflag=1;
                       break;
            default  : /* ignore any other ascii key */
                       break;
         } /* end switch(inkey) */
      } else { /* special key: next character is scan code */
         inkey=getch();
         switch(inkey) {
            case HOME:
                       fy=0; fx=0;
                       if ( pf->l < _screen_length ) {
                          dy=(_screen_length- pf->l)/2;
                          ty=fy+pf->l-1;
                       } else {
                          dy=0;
                          ty=_screen_length-1;
                       }
                       if ( pf->w < _screen_width ) {
                          dx=(_screen_width - pf->w)/2;
                          tx=fx+pf->w-1;
                       } else {
                          dx=0;
                          tx=_screen_width-1;
                       }
                       break;
            case END :
                       fx=0;
                       if ( pf->w < _screen_width ) {
                          dx=(_screen_width - pf->w)/2;
                          tx=fx+pf->w-1;
                       } else {
                          dx=0;
                          tx=_screen_width-1;
                       }
                       if ( pf->l < _screen_length ) {
                          fy=0;
                          dy=(_screen_length- pf->l)/2;
                          ty=fy+pf->l-1;
                       } else {
                          dy=0;
                          fy= pf->l - _screen_length;
                          ty= fy + _screen_length -1;
                       }
                       break;
            case PGUP:
                       if ( pf->w < _screen_width ) {
                          fx=0;
                          dx=(_screen_width - pf->w)/2;
                          tx=fx+pf->w-1;
                       } else {
                          dx=0;
                          fx= pf->w - _screen_width;
                          tx= pf->w - 1;
                       }
                       fy=0;
                       if ( pf->l < _screen_length ) {
                          dy=(_screen_length- pf->l)/2;
                          ty=fy+pf->l-1;
                       } else {
                          dy= 0;
                          ty= fy+_screen_length-1;
                       }
                       break;
            case PGDN:
                       if ( pf->w < _screen_width ) {
                          fx=0;
                          dx=(_screen_width - pf->w)/2;
                          tx=fx+pf->w-1;
                       } else {
                          dx=0;
                          fx= pf->w-_screen_width;
                          tx= fx+_screen_width-1;
                       }
                       if ( pf->l < _screen_length ) {
                          fy=0;
                          dy=(_screen_length- pf->l)/2;
                          ty=fy+pf->l-1;
                       } else {
                          dy=0;
                          fy= pf->l-_screen_length;
                          ty= fy+_screen_length-1;
                       }
                       break;
            case FWD : if ( pf->w > _screen_width ) {
                          dx=0;
                          fx=fx+_screen_width;
                          fx=( fx < pf->w-_screen_width-1) ?
                                    fx : pf->w-_screen_width-1;
                          tx=fx+_screen_width-1;
                       }
                       break;
            case BACK: if ( pf->w > _screen_width ) {
                          dx=0;
                          fx=fx-_screen_width;
                          fx=( fx > 0 ) ? fx : 0;
                          tx=fx+pf->w-1;
                       }
                       break;
            case UP  : if ( pf->l > _screen_length ) {
                          dy=0;
                          fy=fy-_screen_length;
                          fy=(fy > 0 ) ? fy : 0;
                          ty=fy+_screen_length-1;
                       }
                       break;
            case DN  : if ( pf->l > _screen_length ) {
                          dy=0;
                          fy=fy+_screen_length;
                          fy=(fy < pf->l-_screen_length-1) ?
                                               fy : pf->l-_screen_length-1;
                          ty=fy+_screen_length-1;
                       }
                       break;
            case 27 :  quitflag=1;  /* escape? */
                       break;
            default :  quitflag=1;  /* exit on unknown key */
                       break;
         } /* end switch(inkey) */
      } /* end if getch()'s else */
}


