/*  testpcx.c  : test read/write pcx functions by writing an inverted  copy
    of the input file */

#include <stdio.h>
#include "pcxlib.h"

PCXF *pf1, *pf2, *pf3;
char buffer[2000];
#define FILLV   0x18


void main(int argc, char *argv[])
{
    int i,ci, co;

    printf("PCXLIB v%s Testpcx.\n", PCXLIB_VERSION);

    if (argc < 2) {
       printf("You must specify an input .pcx file.\n");
       exit(1);
    }

   /* Open debugging file */
   #ifdef DEBUG
   Start_pcxdebug("testpcx.dbg");            /* start debugging */
   fprintf(pcxdebug,"\nMAIN: arguments are: 0=%s 1=%s\n", argv[0], argv[1]);
   fprintf(pcxdebug,"   sizeof(PCXF)=%u %xh, sizeof(PCXH)=%u %xh\n",
                    sizeof(PCXF), sizeof(PCXF), sizeof(PCXH), sizeof(PCXH));
   #endif

   /* Open pcx file */
   pf1=fopenPCXr(argv[1]); /* also reads header */
   if (pf1->type != PCX256colors ) {
      printf("Wrong pcx file, expected a 256 color file.\n");
      exit(1);
   }
   printf("\nWe will be testing our ability to read and write pcx files by\n"
            "reading the file you specify and producing two outputs:\n"
            "   test1.pcx     : (hopefully) an exact copy of the input file\n"
            "   test2.pcx     : a copy of the input file turned upside down\n"
            "\n(hit any key to continue)\n\n");
   getch();
   pf2=fopenPCXw("test1.pcx",pf1->h,pf1->palette);
   pf3=fopenPCXw("test2.pcx",pf1->h,pf1->palette);

   fseekPCX(pf1,0);
   fseekPCX(pf2,0);
   printf("Starting output to test1.pcx\n");
   for (i=0; i<(pf1->l); i++) {
       #ifdef DEBUG
       fprintf(pcxdebug,"i=%i, ftell(pf1)=%li, ftell(pf2)=%li\n",
                        i, ftell(pf1->fp), ftell(pf2->fp));
       #endif
       if ( ((i%16) == 0) && (i > 15))
          *(pf1->marks + (i/16-1))=ftell(pf1->fp);
       _read_pcx_line(pf1, buffer, 0, pf1->w-1);
       _write_pcx_line(pf2, buffer, 0, pf2->w-1, FILLV);
   }
   fseekPCX(pf3,0);
   _write_pcx_palette(pf2);
   printf("Completed test1.pcx, starting test2.pcx (this will take a while).\n");

   if (pcxdebug) {
      for (i=0; i<pf1->num_marks; i++) {
          fprintf(pcxdebug,"mark[%i]=%li\n", i, *(pf1->marks+i));
      }
   }

   for (i=pf1->l-1; i> -1; i--) {
       fseekPCX(pf1,i);
       #ifdef DEBUG
       fprintf(pcxdebug,"i=%i, ftell(pf1)=%li, ftell(pf3)=%li\n",
                        i, ftell(pf1->fp), ftell(pf3->fp));
       #endif
       _read_pcx_line(pf1, buffer, 0, pf1->w-1);
       _write_pcx_line(pf3, buffer, 0, pf3->w-1, FILLV);
   }
   printf("Completed test2.pcx.  Use showpcx to view the output files\n");

   _write_pcx_palette(pf3);
   if (pcxdebug) fprintf(pcxdebug,"PCXerror=%i\n", PCXerror);
   fclosePCX(pf1); fclosePCX(pf2); fclosePCX(pf3);
   Close_pcxdebug();
   exit(0);
}



