/* pcxlib.h */
#if !defined(__LARGE__) && !defined(__HUGE__)
#error Wrong memory model
#endif

#ifndef PCX_H                      /* don't do more than once */
#define PCX_H

#define PCXLIB_VERSION         "1.5"

#define ALIGN_DWORD(x) (((x)+3)/4 * 4)
#define What_WPlanes    (SQread_reg(2))

#define PCXUNK             -1        /* unknown/invalid */
#define PCXMONO             0
#define PCX4colors          1
#define PCX16colors         2
#define PCX256colors        3

struct PCXRGB {
       unsigned char r, g, b;
};

typedef struct {
        char               MagicId;
        char               Version;
        char               Encoding;
        char               BitsPixel;
        int                Xmin, Ymin;
        int                Xmax, Ymax;
        int                Hres, Vres;
        struct PCXRGB      Palette[16];   /* used only on 16 color pcx's */
        char               Reserved;
        char               Planes;
        unsigned int       bytesline;
        int                PaletteInfo;
        char               Filler[58];
} PCXH;

#define  MAXAREA          65520L       /* 64k - 16 bytes (for malloc) */

typedef struct {
       char              *name;
       FILE              *fp;
       PCXH              *h;
       unsigned char     *palette; /* for 256 color pcx's w/palette */
       long              *marks;   /* set to NULL when marks not set */
       unsigned char     *buffer;  /* scan line buffer */
       int               next_scan,buffer_scan;

       int               type;    /* PCXUNK= -1 =unknown/invalid
                                     PCXMONO= 0 =mono
                                     PCX4colors     1 =4  color
                                     PCX16colors=   2 =16 color seg/line
                                     PCX256colors=  3 =256 color  */
       unsigned          w, l;
       char              cw, cl;
       long              image_size;
       int               read_or_write;  /* 0 = readonly, 1 = writeonly */
       unsigned          num_marks; /* set to 0 initially */
} PCXF;

#ifdef _cplusplus
extern "C" {
#endif

PCXF  *        fopenPCXr(char *name);
PCXF  *        fopenPCXw(char *name, PCXH *h, char *palette);
int            fseekPCX(PCXF *pcxfile, unsigned y); /* seek scan line y */
int            fclosePCX(PCXF *pcxfile);

int   fread8PCX(char *d, unsigned dw, unsigned dl,
                unsigned dx, unsigned dy,
                unsigned x0, unsigned y0, unsigned x1, unsigned y1, PCXF *p);

/* fdisp8PCX may be used in VESA modes with no additional work 		*/
/* (other than  setting the mode) !! 			   		*/
int   fdisp8PCX(unsigned dx, unsigned dy,
                unsigned x0, unsigned y0, unsigned x1, unsigned y1, PCXF *p);

/* fread4PCX reads and converts pixels into a 1 pixel/1 byte format, suitable
   for conversion to a different format */
int   fread4PCX(char *d, unsigned dw, unsigned dl,
                unsigned dx, unsigned dy,
                unsigned x0, unsigned y0, unsigned x1, unsigned y1, PCXF *p);
/* fdisp4PCX reads and displays in a VGA planar format */
int   fdisp4PCX(unsigned dx, unsigned dy,
                unsigned x0, unsigned y0, unsigned x1, unsigned y1, PCXF *p);

/* This function for monochrome .pcx files is untested!  I don't have     */
/* any mono pcx files to test it with (I'm not interested in mono files). */
int   fread1PCX(char *d, unsigned dw, unsigned dl, unsigned dx, unsigned dy,
                unsigned x0, unsigned y0, unsigned x1, unsigned y1, PCXF *p);


/* low-level read/write */
unsigned       _read_pcx_line(PCXF *pointer, char * linebuffer,
                              unsigned x0, unsigned x1);
unsigned       _write_pcx_line(PCXF *pointer, char * linebuffer,
                               unsigned x0, unsigned x1,
                               unsigned char fill);

void           _write_pcx_palette(PCXF *pointer);
void           _read_palette(PCXF *p);


void           Start_pcxdebug(char *path);
void           Close_pcxdebug(void);

#ifdef _cplusplus
}
#endif

#ifdef   PCX_LIB
                int  PCXerror=0;
                FILE *pcxdebug;
                int  debugtimeson=0;
#else
         extern int  PCXerror;
         extern FILE *pcxdebug;
         extern int  debugtimeson;
#endif

#endif   /* PCX_lib */



