/* vesa.h */
#ifndef __VESALIB__
#define __VESALIB__

#ifndef __VIDLIB__
      unsigned int  _screen_width;
      unsigned int  _screen_length;
	  char *_screen_start;
#endif

struct	vesainfo {
	char	signature[4];   /* shoud be "VESA" */
        int     version;
	char *OEMinfo;
	char	capabilities[4];
	int *modeptr;
	char	Reserved[246];
};


struct	vesamodeinfo {
	int	modeattr;
	char	WindowAattr;
	char	WindowBattr;
	int	granularity;
	int	size;
	int	Asegment;
	int	Bsegment;
	void    (*Windowsetptr)();
	int	bytesperline;

	/* optional information (when bit 1 of modeattr is set)	*/

	int	XPixels;
	int	YPixels;
	char	charwidth;
	char	charlength;
	char	planes;
	char	bits;
	char	banks;
	char	memorymodel;
	char	banksize;               /* in k bytes */
	char	Reserved[246];
};

#ifdef VESA
struct          vesainfo   Vinfo;
struct      vesamodeinfo   Vminfo;
            unsigned int   vesapage=0;
	    unsigned int   Vnext_break_row;
	    unsigned int   Vnext_break_col;
	    unsigned long  _window_size;
#else
extern   struct vesainfo   Vinfo;
extern struct vesamodeinfo Vminfo;
extern        unsigned int vesapage;
extern        unsigned int Vnext_break_row;
extern        unsigned int Vnext_break_col;
extern       unsigned long _window_size;
#endif

/* included for compatibility with previous version of this library */
#define VESAfirst_page(r,c)     (VESAwhat_page(r,c))
#define VESApage_offset(r,c)	(VESAwhat_offset(r,c))
#define Vnext_break		(Vnext_break_row)
#define Vnext_break_offset	(Vnext_break_offset)

#define Vabsolute_offset(r,c) \
 (((long)(r)*(long)Vminfo.bytesperline)+(c))
#define VESAwhat_page(r,c)   \
 ((unsigned int)(Vabsolute_offset(r,c)/_window_size))
#define VESAwhat_offset(r,c) \
 ((unsigned int)(Vabsolute_offset(r,c)%_window_size))


/* If compiling under TurboC++, make sure it knows how to link. */
#ifdef _cplusplus
extern "C" {
#endif

int              VESAmode(unsigned int mode, char *palette);
int              isVESA(void);           /* 1=VESA ok., 0=no VESA */
int              isVESAmode(int mode);   /* see if a VESA mode is valid */
struct vesainfo *getVESAinfo(int mode);

void             VESAnext_break(void);
/* used by setpages to set Vnext_break_row and Vnext_break_col variables */

int              VESAsetpage(unsigned page);
int              VESAsetpagew(char window, unsigned page);
int              VESAsetpagewbios(char window, unsigned page);

int              VESAfill256(unsigned dx, unsigned dy,
			     unsigned sdx, unsigned sdy,
			     unsigned color);
		 /* video to video copy */
int              VESAcopy256(unsigned dx, unsigned dy,
			     unsigned sx, unsigned sy,
			     unsigned sdx, unsigned sdy);
int              VESAcopy16(unsigned dx, unsigned dy,
			    unsigned sx, unsigned sy,
			    unsigned sdx, unsigned sdy);

		 /* System memory to video copy */
int              VESAdisp256(unsigned dx, unsigned dy,
			     char *s, unsigned sw, unsigned sl,
			     unsigned sx, unsigned sy,
			     unsigned sdx, unsigned sdy, int direction);
int              VESAdisp16(unsigned dx, unsigned dy,
			    char *s, unsigned sw, unsigned sl,
			    unsigned sx, unsigned sy,
			    unsigned sdx, unsigned sdy);

		 /* Video to System memory copy */
int              VESAcapt256(char *d, unsigned dw, unsigned dl,
			     unsigned dx, unsigned dy,
			     unsigned sx, unsigned sy,
			     unsigned sdx, unsigned sdy, int direction);

int              VESAcapt16(char *d, unsigned dw, unsigned dl,
			    unsigned dx, unsigned dy,
			    unsigned sx, unsigned sy,
			    unsigned sdx, unsigned sdy);

#ifdef _cplusplus
}
#endif



#endif
