#include <stdlib.h>
#include <stdio.h>
#include <dos.h>
#include <string.h>
#include "vesa.h"

char    *header0 = "VESAINFO v2.0a\n";
char    *header1 = "The following VESA modes are supported: ";

void main(void)
{
	int     i;
	char ts[2];

        printf("%s%s",header0,header1);

        /* Check if VESA BIOS is present        */
        if (isVESA() == 0) {
           printf("\n...Error: Cannot locate VESA BIOS\n");
           exit(1);
        }

        /* Loop over modes, displaying info for each                    */
        for (i = 0; Vinfo.modeptr[i] != EOF; i++) {
            /* Display mode number                                  */
            printf("\n    %4Xh",Vinfo.modeptr[i]);
            printf(" (%s):", Vinfo.modeptr[i] & 0x0100 ? "VESA" : " OEM");
            if (getVESAinfo(Vinfo.modeptr[i]) == NULL) {
                printf("\nOops. Couldn't retrieve mode info.\n");
                exit(2);
            }

            /* Display mode type (text or graphics)                 */
            printf(" %s ",(Vminfo.modeattr & 0x0010) ? "Graph":"Text ");
            switch (Vminfo.WindowAattr) {
               case 0 : strcpy(ts,"NA"); break;
               case 3 : strcpy(ts,"RO"); break;
               case 5 : strcpy(ts,"WO"); break;
               case 7 : strcpy(ts,"RW"); break;
               default: strcpy(ts,"??"); break;
            }
            printf("WA:%s ",ts);
            switch (Vminfo.WindowBattr) {
               case 0 : strcpy(ts,"NA"); break;
               case 3 : strcpy(ts,"RO"); break;
               case 5 : strcpy(ts,"WO"); break;
               case 7 : strcpy(ts,"RW"); break;
               default: strcpy(ts,"??"); break;
            }
            printf("WB:%s ",ts);
            printf("Gran: %ik  Size: %ik", Vminfo.granularity, Vminfo.size);

            /* Display mode resolution                              */
            if (Vminfo.modeattr & 0x0002) {
               printf(" %4d x%4d ", Vminfo.XPixels, Vminfo.YPixels);

               /* Display number of colors                             */
               if (Vminfo.modeattr & 0x0008)
                  printf(" %3d Colors", 0x0001 << (Vminfo.bits));
               else
                  printf(" Mono");
            } else
               printf(" N/A\n");
        }

        exit(0);
}