#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <mem.h>
#include "vidlib.h"


int Vfill256(unsigned dx, unsigned dy, unsigned sdx, unsigned sdy,
                unsigned color)
{
   char *dest;

   dest=(char *)normalize(_screen_start + (dy*_screen_width) +dx);
   if (vgadebug) {
       fprintf(vgadebug,"\nVfill256(dx=%u, %u, sdx=%u, sdy=%u, color=%u)\n",
                        dx,dy,sdx,sdy,color);
       fflush(vgadebug);
   }
   while (sdy>0) {
       setmem(dest, sdx, color);
       dy++; sdy--;
       dest=(char *)normalize(dest+_screen_width);
   }
   return(1);
}

/* video to video copy */
int Vcopy256( unsigned dx, unsigned dy,
              unsigned sx, unsigned sy, unsigned sdx, unsigned sdy)
{
   char *dest;
   char *src;
   unsigned int yo;

   /* check parameters */
   if ( (long)(sdx * sdy) > 0xFFFFL ) return(0);
   if ( vgadebug != NULL ) {
      sprintf(tdbg,"Vc256: dx=%u, dy=%u, sx=%u, sy=%u, sdx=%u, sdy=%u\n",
          dx, dy, sx, sy, sdx, sdy);
      fputs(tdbg,vgadebug);
   }

   dest=(char *)normalize( _screen_start + dy*_screen_width + dx);
   src= (char *)normalize( _screen_start + sy*_screen_width + sx);
   if ( vgadebug != NULL ) {
      sprintf(tdbg,"     : dest=%Fp, src=%Fp\n", dest, src);
      fputs(tdbg,vgadebug);
   }
   for (yo=0; yo < sdy; yo++) {
       memcpy(dest, src, sdx);
       dest=(char *)normalize( dest + _screen_width);
       src= (char *)normalize( src  + _screen_width);
   }
   return(1);
}

/* memory to video copy */
int Vdisp256(unsigned dx, unsigned dy,
             char *s, unsigned sw, unsigned sl,
             unsigned sx, unsigned sy, unsigned sdx, unsigned sdy)
{
   char *dest;
   char *src;
   unsigned int yo;

   /* check parameters */
   if ( (sx + sdx > _screen_width) || ( sy + sdy > _memory_length) ||
        (sx + sdx > sw) || ( sy + sdy > sl) ||
        ((long)(sdx * sdy) > 0xFFFFL)) {
       printf("Parameter error.\n");
       return(0);
   }
   if ( vgadebug != NULL ) {
     sprintf(tdbg,"Vd256: dx=%u, dy=%u\n",
                 dx, dy);
     fputs(tdbg,vgadebug);
     sprintf(tdbg,"       s=%Fp, sw=%u, sl=%u, sx=%u, sy=%u, sdx=%u, sdy=%u\n",
                 s, sw, sl, sx, sy, sdx, sdy);
     fputs(tdbg,vgadebug);
   }

   if ( BIOScrtmode > 0x13 ) {
      printf("VESA not yet fully implemented.\n");
      return(0);
   }

   dest=(char *)normalize( _screen_start + dy*_screen_width + dx);
   src= (char *)normalize( s + sy*sw + sx);
   if ( vgadebug != NULL ) {
     sprintf(tdbg,"     : dest=%Fp, src=%Fp\n",
                 dest, src);
     fputs(tdbg,vgadebug);
   }
   for (yo=0; yo < sdy; yo++) {
       memcpy(dest, src, sdx);
       dest=(char *)normalize( dest + _screen_width);
       src= (char *)normalize( src  + sw);
   }
   return(1);
}

/* video to memory copy */
int Vcapt256(char *d, unsigned dw, unsigned dl,
                      unsigned dx, unsigned dy,
                      unsigned sx, unsigned sy, unsigned sdx, unsigned sdy)
{
   char *dest;
   char *src;
   unsigned int yo;

   /* check parameters */
   if ( (sx + sdx > _screen_width) || ( sy + sdy > _memory_length) ||
        (sx + sdx > dw) || ( sy + sdy > dl) ||
        ((long)(sdx * sdy) > 0xFFFFL)) {
       printf("Parameter error.\n");
       return(0);
   }
   if ( vgadebug != NULL ) {
     sprintf(tdbg,"Vct256: dx=%u, dy=%u\n",
                 dx, dy);
     fputs(tdbg,vgadebug);
     sprintf(tdbg,"       d=%Fp, dw=%u, dl=%u, sx=%u, sy=%u, sdx=%u, sdy=%u\n",
                 d, dw, dl, sx, sy, sdx, sdy);
     fputs(tdbg,vgadebug);
   }

   if ( BIOScrtmode > 0x13 ) {
      printf("VESA not yet fully implemented.\n");
      return(0);
   }

   dest=(char *)normalize( d + dy*dw + dx);
   src= (char *)normalize( _screen_start + sy*_screen_width + sx);
   if ( vgadebug != NULL ) {
     sprintf(tdbg,"     : dest=%Fp, src=%Fp\n",
                 dest, src);
     fputs(tdbg,vgadebug);
   }
   for (yo=0; yo < sdy; yo++) {
       memcpy(dest, src, sdx);
       dest=(char *)normalize( dest + dw);
       src= (char *)normalize( src  + _screen_width);
   }
   return(1);
}


