/********************************************************************
 FILENAME: TRIG.HPP
 AUTHOR  : JAKE HILL
 DATE    : 12/1/94

 Copyright (c) 1994 by Jake Hill:
 If you use any part of this code in your own project, please credit
 me in your documentation and source code.  Thanks.
********************************************************************/

#ifndef TRIG_HPP
#define TRIG_HPP

#define SIN(X)   sin_table[ X & 0x3FF ]
#define TAN(X)   tan_table[ X & 0x3FF ]
#define COS(X)   cos_table[ X & 0x3FF ]
#define ICOS(X)  inv_cos_table[ X & 0x3FF ]

#define sine(x)        SIN( x >> 6 )
#define cosine(x)      COS( x >> 6 )
#define tangent(x)     TAN( x >> 6 )
#define invcosine(x)   ICOS( x >> 6 )
#define invdistance(x) inv_dist_table[x]

extern long sin_table[1024];
extern long tan_table[1024];
extern long cos_table[1024];
extern long inv_cos_table[1024];
extern long far inv_dist_table[10000];

short xSinA( short, unsigned short );
short xCosA( short, unsigned short );
void  GenInvDistTable(long);
void  InitTrig(void);

#endif
