/*	          Written by Eric Praetzel (C)  [usenet: praetzel@sunee.waterloo.edu]
 *   Feel free to change this but if you feel its a usefull addition please
 *    tell me so that I can include it for general distribution.
 *
 *   This allows the user to pick a video card and test any supported mode.
 *
 *   The S/W will default to the dvpeg.cfg file or the autodetected card if
 *     the file does not exist.
 *   The user can set defaults for the viewing program here.  The defaults
 *    can be changed in dvpeg but can not be saved.
 *
 *   last changed:  August 3, 1992
 */

/* text screen is: a title on the top line
						 a video card list (columns 1 to 24)
						 a video mode list in the upper right corner (rows 2 to 12)
						 a selected mode list in the lower right (rows 13 to 24)
		--> if the lists ever exceed the ranges scroll bars will have to be added

  - added custom video mode setup
  - added default setting/changing thru view_defaults int in the dvpeg.cfg file

  problems
  - a bad mode number will lock the card in some wierd mode - I don't know how to reset short of the reset key
  - if print onto last line (ie mode list, user mode list) then last line is doubled
  - plotting border has problems on the last char because it causes a CR/LF !!
  - loading the mask string needs a \n termination but this will be added the next time its
		saved (ie you have 2 then 3 then 4 ...  -> so search the string and clip them out - done during loading
*/

#include "jvsetup.h"
#include "conio.h"
#include "stdio.h"

#include "viewer.h"		/* variables for dvpeg, vidsetup */

int		gr_row,		/* variables for drawing points */
			gr_col,
			color_out;

void borders(int hi_light);
void test_video(int sel_card, int sel_mode);
void help_msg(int which_screen);
void open_window(int width, int height);
void insert_in_list(int card, int mode);


/* draw the dividers on the screen for the text mode video selection
	 hi_light is the flag to draw a bright border around (active area)
  */

void test_video(int sel_card, int sel_mode)
{
static int i,
			range,		/* range of colors ie 5 bits for hi_color, 6 for Super VGA */
			x, y,
			x_size,
			y_size;

x_size = video_cards[sel_card].vid_mode[sel_mode].x_size;
y_size = video_cards[sel_card].vid_mode[sel_mode].y_size;

forcevga(sel_card);
svgamode(video_cards[sel_card].vid_mode[sel_mode].mode_number, x_size);

if (hi_color == 0)
	range = 64;
else
	range = 32;

for (i=0; i<256; i++){
	palbuf[i][0] = range - (i % range);		/* invert to start with red */
	palbuf[i][1] = (i / 2) % range;
	palbuf[i][2] = (i / 4) % range;
	}

if (hi_color == 0)
	setmany(palbuf,0,256);

for (x=0; x < x_size; x++){
	i = x & 0xff;		/* ie % 256;*/
	for(y=0; y < y_size; y++)
		if (hi_color)
			if (sel_card == start_hi_color){		/* ATI hi_color card */
				point_wide(2*x, y,
					(palbuf[i][0] << 10) + (palbuf[i][1] << 5) + palbuf[i][2]);
				x++;		/* remember to make x inc. twice as fast */
				}
			else
				point_hi(x,y,
					palbuf[i][2]+(palbuf[i][1]<<5) + (palbuf[i][0] << 10));
		else
			point(x, y, i);
	}
getch();
textmode(C80);
}


/* put a window up in the center of the screen
	- ask about panning, video mode ....
	- don't worry what is under it because the image will be drawn */

void open_window(int width, int height)
{
char char_is;
struct text_info ti;
int i;

window(12, 4, 12 + width, 4 + height);
clrscr();

 /*  border */

gettextinfo(&ti);

textcolor(WHITE);
char_is = 219;			/* solid block */

for (i=1; i <= (ti.winright-ti.winleft); i++){		/* should go 1 count more */
	gotoxy(i, 1);
	putch(char_is);
	gotoxy(i, ti.winbottom - ti.wintop + 1);
	putch(char_is);
	}
for (i=2; i <= (ti.winbottom-ti.wintop); i++){
	gotoxy(1, i);
	putch(char_is);
	gotoxy(ti.winright - ti.winleft, i);		/* had to sub +1 */
	putch(char_is);
	}
window(14, 6, 10 + width, 2 + height);
}



void help_msg(int which_screen)
{
int length;
char text[80];

window(5, 1, 75, 3);		/* print help stuff */
switch(which_screen){
	case 0:
				strcpy(text, "        delete (del), ESC           ");
				break;
	case 1:
				strcpy(text, "test (space), add (insert), ESC, RTN");
				break;
	case 2:
				strcpy(text, "      choose (RTN), exit (ESC)      ");
				break;
	}
length = strlen(text);
gotoxy(40 - length / 2, 1);
textcolor(LIGHTRED);
cprintf("%s", text);
textcolor(WHITE);
}



void borders(int hi_light)
{
int i;
char char_is;
struct text_info ti;

gettextinfo(&ti);

if (hi_light){
	textcolor(WHITE);
	char_is = 219;			/* solid block */
	}
else{
	textcolor(LIGHTGRAY);
	char_is = 177;			/* 1/2 dense block */
	}

for (i=1; i <= (ti.winright-ti.winleft); i++){		/* should go 1 count more */
	gotoxy(i, 1);
	putch(char_is);
	gotoxy(i, ti.winbottom - ti.wintop + 1);
	putch(char_is);
	}
for (i=2; i <= (ti.winbottom-ti.wintop); i++){
	gotoxy(1, i);
	putch(char_is);
	gotoxy(ti.winright - ti.winleft, i);		/* had to sub +1 */
	putch(char_is);
	}
}



int main(int argc, char *argv[])
{
static int i,
			temp,					/* temp var for things */
			erase_screen,		/* flag screen erase before redraw */
			exit_now,			/* exit flag for main loop */
			sel_card,			/* pointer into array for selected video card */
			sel_mode,			/* pointer into array for selected mode */
			sel_mode_list,		/* currently item in selected mode list pointed to */
			some,					/* a check to make sure that the user mode list is not empty - otherwise the prog locs! */
			update_file,		/* flag that cfg info has change */
			card_mode_oklist;		/* flag for oklist (0) or card (2) or mode (1) in selection*/
static int cmd;
static struct text_info ti;
static char temp_char[20];

FILE *config_file;

for (i = 0; i <= number_modes_in_list; i++)
	ok_mode[i].card_ID = -1;					/* set to not filled */

/* set up name for config file (dvpeg.cfg) and assume its in the same dir as vidsetup.exe */
strcpy(config_name, argv[0]);
/* change vidsetup.exe to dvpeg.exe */
for (i=strlen(config_name); i >= 0 && config_name[i] != '\\'; i--);
config_name[i+1] = 0;					/* knock off file and add dvpeg.cfg to path in load_config*/


/* does the dvpeg.cfg file exist? if not do auto detect*/
if ( !load_config() )
	if ( config_video() )	/* is there super VGA ?? */
		update_file = 1;
	else
		{
		card_id = 0;				/* let the user guess what it is but assume 320 * 200 mode (first in all of them) */
		ok_mode[0].card_ID = 0;		/* make sure that there is one item in the selected list */
		ok_mode[0].which_mode = 0;      	/*  this will always be 320 * 200 */
		}

sel_card = card_id;
sel_mode = sel_mode_list = 0;			/* default to lowest resolution, card detected*/

textmode(C80);

gettextinfo(&ti);

card_mode_oklist = 2;		/* start with card menu*/

erase_screen = 0;
clrscr();
textcolor(YELLOW);
gotoxy(1,1);
cprintf("Video Setup (F1 - help)                                             Dvpeg");

/* select a video card and mode then test it or update the user mode list */
/* note right side has to be wider to prevent CR/LF on plotting char 1! */

do{
	_setcursortype(_NOCURSOR);			/* hide the cursor*/
	help_msg(card_mode_oklist);
	window(1, 2, 24, 25);
	if (erase_screen){
		clrscr();
		erase_screen = 0;
		}
/* setup the borders on the screen with video card hi_light */
	borders(card_mode_oklist == 2);
	window(2, 3, 23, 24);
	gotoxy(1,1);
	textcolor(YELLOW);
	cprintf("  Video cards\n\r");
	textcolor(WHITE);
	for (i=0; i < number_VGA_cards; i++){
		if (i == sel_card)
			if (card_mode_oklist == 2)	textcolor(LIGHTMAGENTA);
			else	textcolor(MAGENTA);
			cprintf(" %s\r\n", video_cards[i].name);
		textcolor(WHITE);
		}

	window(25, 2, 80, 11);		/* plot video mode available */
	borders(card_mode_oklist == 1);
	window(26, 3, 78, 10);
	clrscr();
	gotoxy(1,1);
	textcolor(YELLOW);
	cprintf("   Video Modes\r\n");
	textcolor(WHITE);
	cprintf(" X size, Y size, mode #     X size, Y size, mode #\n\r");
	for (i=0; i < number_modes_supported; i++)
		if (video_cards[sel_card].vid_mode[i].mode_number != 0){
			if (i == sel_mode)
				if (card_mode_oklist == 1)	textcolor(LIGHTMAGENTA);
				else	textcolor(MAGENTA);
			cprintf(" %4i   %5i   %4i",video_cards[sel_card].vid_mode[i].x_size,video_cards[sel_card].vid_mode[i].y_size, video_cards[sel_card].vid_mode[i].mode_number);
			if ((i % 2) == 0) cprintf("       ");
			else					cprintf("\r\n");
			textcolor(WHITE);
			}

	window(25, 12, 80, 25);		/* plot video mode list as selected */
	borders(card_mode_oklist == 0);
	window(26, 13, 78, 24);
	clrscr();
	gotoxy(1,1);
	textcolor(YELLOW);
	cprintf("         Selected Video Modes\n\r");
	textcolor(WHITE);
	cprintf(" Video Card,          X size, Y size, mode #\n\r");
	any_hi_color = 0;
	for (i=0; i < number_modes_in_list; i++)
		if (ok_mode[i].card_ID >= 0){
/* check for any hi_color modes and set flag */
			if (!is_it_vga(ok_mode[i].card_ID, ok_mode[i].which_mode))
				any_hi_color = 1;
			if (i == sel_mode_list)
				if (card_mode_oklist == 0)	textcolor(LIGHTMAGENTA);
				else	textcolor(MAGENTA);

				/* temp for card # */
			cmd = ok_mode[i].card_ID;
				/* temp for real card / mode # if its custom */
			temp = video_cards[cmd].vid_mode[ok_mode[i].which_mode].mode_number;
			if (cmd == last_card)		/* fix it if its a custom mode */
				cprintf("Cust: %12s    %4i   %5i   %4i\r\n",video_cards[temp & 0x00ff].name,
					video_cards[last_card].vid_mode[ok_mode[i].which_mode].x_size,
					video_cards[last_card].vid_mode[ok_mode[i].which_mode].y_size,
					temp >> 8);
			else
				cprintf(" %17s    %4i   %5i   %4i\r\n",video_cards[cmd].name,
					video_cards[cmd].vid_mode[ok_mode[i].which_mode].x_size,video_cards[ok_mode[i].card_ID].vid_mode[ok_mode[i].which_mode].y_size,
					temp);
			textcolor(WHITE);
			}

	cmd = get_key();
	if (cmd == escape){
		if (card_mode_oklist == 2) exit_now = 1;
		else card_mode_oklist++;					/* RTN selects mode and/or exit */
		cmd = 0;
		}
	if (cmd == RTN){
		card_mode_oklist--;		/* ESC hops to card select */
		cmd = 0;						/* only change menu, don't act on cmd */
		}
	if (cmd == F1){		/* help screen */
		open_window(55, 14);
		cprintf("Enter - hop in one level\r\n");
		cprintf("ESC - hop out one level\r\n");
		cprintf("arrows - move around (usually up/down)\r\n");
		cprintf("C - custom video using selected mfg. card\r\n");
		cprintf("F1 - help screen\r\n");
		cprintf("F3 - change viewing defaults\r\n");
		cprintf("F4 - change file mask\r\n");
		cprintf("F5 - change sort method\r\n");
		cprintf("F6 - change defalt file path\r\n");
		erase_screen = 1;
		cmd = 0;
		getch();
		}
	if (cmd == 'c' || cmd == 'C'){		/* create a special mode using the current card */
		open_window(40,10);

		/* cmd points to the next available spot or the top */
		for (cmd = i = number_modes_in_list-1; i >= 0; i--)
			if (video_cards[last_card].vid_mode[i].x_size == 0)
				cmd = i;

		/* insert at index "cmd" */

		gotoxy(1,1);
		cprintf("What is the X size:");
		gotoxy(1,2);
		scanf("%i", &video_cards[last_card].vid_mode[cmd].x_size);

		gotoxy(1,3);
		cprintf("Y size:");
		gotoxy(1,4);
		scanf("%i", &video_cards[last_card].vid_mode[cmd].y_size);

		gotoxy(1,5);
		cprintf("mode number (decimal):");
		gotoxy(1,6);
		scanf("%i", &i);
		video_cards[last_card].vid_mode[cmd].mode_number = (i << 8) + sel_card;

		insert_in_list(last_card, cmd);
		update_file = 1;
		erase_screen = 1;
		cmd = 0;
		}
	if (cmd == F3){		/* lets change the defaults */
		do{
			open_window(40,15);
			show_defaults(1);
			}while (	change_defaults(getch()) );
		cmd = 0;
		update_file = 1;
		erase_screen = 1;
		}
	if (cmd == F4){		/* F4 - change file mask */
		open_window(40, 10);
		cprintf("The file mask is: %15s\r\n\n", file_mask);
		cprintf("What is the new mask?\r\n");
		if (get_line(&temp_char)){
			strcpy(file_mask, temp_char);
			update_file = 1;
			}
		erase_screen = 1;
		cmd = 0;
		}
	if (cmd == F5){
		open_window(40,10);
		cprintf("Sort order is: ");
			switch (sort_mode){
				case NONE:
								cprintf("unsorted");
								break;
				case FF_NAME:
								cprintf("by name");
								break;
				case FF_SIZE:
								cprintf("by size");
								break;
				case FF_DATE:
								cprintf("by date");
								break;
				}
		cprintf("\r\nchoose: Unsorted, Name, Size, Date\r\n");
		i = getch();
		switch (i){
			case 'N':
			case 'n':   sort_mode = FF_NAME;
							break;
			case 'U':
			case 'u':
							sort_mode = NONE;
							break;
			case 'S':
			case 's':
							sort_mode = FF_SIZE;
							break;
			case 'D':
			case 'd':
							sort_mode = FF_DATE;
							break;
			}
		erase_screen = 1;
		update_file = 1;
		cmd = 0;
		}
	if (cmd == F6){		/* F6 - change default file path */
		open_window(50, 10);
		cprintf("The file path is: %25s\r\n\n", default_path);
		cprintf("What is the new path (rtn = clear)?\r\n");
		if (get_line(&temp_char)){
			if (strlen(temp_char) <= 1)	/* 1 char can mean nothing so assume empty */
				strcpy(default_path, "");
			else
				strcpy(default_path, temp_char);
			update_file = 1;
			}
		erase_screen = 1;
		cmd = 0;
		}
	if (card_mode_oklist < 0) card_mode_oklist = 0;
	switch (card_mode_oklist){
		case 0:			/* ok mode list ie select for delete */
			for (some = 0, i=0; i< number_modes_in_list; i++)		/* check for an empty list which would hang the S/W */
				if (ok_mode[i].card_ID >= 0)
					some = 1;

			switch (cmd){
				case arrow_up:
					do{
						if (sel_mode_list > 0) sel_mode_list -=1;
						else sel_mode_list = number_modes_in_list - 1;
						} while (ok_mode[sel_mode_list].card_ID < 0 && some);
					break;
				case arrow_down:
					do{
						if (sel_mode_list < number_modes_in_list-1) sel_mode_list += 1;
						else sel_mode_list = 0;
						} while (ok_mode[sel_mode_list].card_ID < 0 && some);
					break;
				case delete:
					if (ok_mode[sel_mode_list].card_ID == last_card){
					/* now convert from sel_mode_list to index # */
						i = ok_mode[sel_mode_list].which_mode;
						video_cards[last_card].vid_mode[i].mode_number = 0;
						video_cards[last_card].vid_mode[i].x_size = 0;
						}

					/* now delete the normal pointers in the ok_list */
					for (i=sel_mode_list; i < number_modes_in_list; i++){
						ok_mode[i].card_ID = ok_mode[i+1].card_ID;
						ok_mode[i].which_mode = ok_mode[i+1].which_mode;
						}
					update_file = 1;
					sel_mode = sel_mode_list = 0;		/* reset so point points to something */
					break;
				}
				break;
		case 2:			/* select a video card move up/down */
			switch (cmd){
				case arrow_up:
					if (sel_card > 0) sel_card -=1;
					else sel_card = last_card;
					sel_mode = 0;		/* old mode number may be high so reset */
					break;
				case arrow_down:
					if (sel_card < last_card) sel_card += 1;
					else sel_card = 0;
					sel_mode = 0;
				}
				break;
		case 1:			/* select a video mode -> test/add to list */
			switch (cmd){
				case arrow_up:
				case arrow_left:
					do{				/* make sure that we get an existing mode */
						if (sel_mode > 0) sel_mode -=1;
						else sel_mode = number_modes_supported - 1;
						} while (video_cards[sel_card].vid_mode[sel_mode].mode_number == 0);
					break;
				case arrow_down:
				case arrow_right:
					do{
						if (sel_mode < number_modes_supported - 1) sel_mode += 1;
						else sel_mode = 0;
						} while (video_cards[sel_card].vid_mode[sel_mode].mode_number == 0);
					break;
				case insert:
					insert_in_list(sel_card, sel_mode);
					update_file = 1;
					break;
				case 0:
					break;		/* make sure return, esc does nothing */
				default:			/* default to testing the mode */
					test_video(sel_card, sel_mode);
			}
			break;
		}
	} while (exit_now == 0);

textmode(C80);
clrscr();
_setcursortype(_NORMALCURSOR);

if (update_file){			/* file was changed - does the user want to save it? */
	printf("The video information has changed.\n\r");
	printf("Do you want to save it (Y or N)?\n\r");
	cmd = toupper(getch());
	if (cmd == 'Y'){
		config_file = fopen(config_name,"wb");
		if (config_file != NULL){						/* load the file mode descriptions */
			putw(text_width, config_file);
			putw(shrink, config_file);
			putw(sort_mode, config_file);
			putw(view_defaults, config_file);
			fputs(file_mask, config_file);
			fputs("\n", config_file);
			fputs(default_path, config_file);
			fputs("\n", config_file);
			i = 0;
	/* dump out card, mode #'s for non-custom modes followed by -1,XX */
			do{
				if (ok_mode[i].card_ID != last_card){		/* only print if its non-custom */
					putw(ok_mode[i].card_ID, config_file);
					putw(ok_mode[i].which_mode, config_file);
					}
				} while(ok_mode[i++].card_ID != -1);

		/* now do custom modes if any */
			for (i = 0; i < number_modes_supported; i++)
				if (video_cards[last_card].vid_mode[i].mode_number != 0){
		/* first write a card # that is in 0x00ff and the mode # is in 0xff00 */
					putw(video_cards[last_card].vid_mode[i].mode_number, config_file);
					putw(video_cards[last_card].vid_mode[i].x_size, config_file);
					putw(video_cards[last_card].vid_mode[i].y_size, config_file);
					}
			putw(-1, config_file);		/* signal end of custom modes / file */
			fclose(config_file);
			}
		else
			printf("Error saving the file.\r\n");
		}
	}
return(0);
}	/* main */
