/*
 *   (C) Eric Praetzel 1992
 *
 *  messy utilities for dvpeg viewer and video setup program
 *
 */

#include <dos.h>
#include <stdio.h>
#include <conio.h>

extern   unsigned char cirrus, everex, paradise, tseng, trident;
extern   unsigned char t8900, ativga, aheada, aheadb;
extern   unsigned char oaktech, video7, chipstech, tseng4, genoa;
extern   unsigned char ncr, compaq, vesa;

extern	int
			view_defaults,
			card_id,
			enable_pan,
			gif_picture,
			shrink,
			sort_mode,
			text_width,
			any_hi_color;

enum bit_locs{				/* masks for bits in word describing setup flags */
	grey_bit = 1,
	dithering_bit = 2,
	smoothing_bit = 4,
	quantize_bit = 8,
	panning_bit = 16,		/* disable panning completely ? */
	ask_size_bit = 32,	/* show screen with defaults or pass it ?? */
	beep = 64,
	only_hi_color = 128	/* flag to disable SVGA modes if hi_color is available for a jpeg */
	};

/* stuff for file selection */

extern char file_mask[20];	/* mask for file selection */
extern char file_path[70];	/* path to files to be viewed */
extern char default_path[80];	/* default path to pictures */
extern char config_name[80]; 		   /* path to configuration file -> assuem its in the same dir as vidsetup.exe */

#define  number_VGA_cards 20        /* the number of VGA cards supported */
#define	start_hi_color 17				/* the first number of the high_color cards ie the last 2 */
#define  last_card 19               /* number of VGA cards -1 : for simplifying code */
#define  number_modes_supported 6   /* the max number of video modes for each card */
#define  number_modes_in_list 10    /* the max number of modes in the user selected list */
#define  escape 27
#define  Return 13
#define  back_space 8

extern struct mode {
	int x_size;
	int y_size;
	int mode_number;};


/* for this struct.  All items should be in ascending order with 0x00 for the unused mode #'s */
/* custom is for typed in modes.  The actual card # is (ok_mode[].card_ID >> 8 ) % 0x00ff where *.card_ID & 0xff is 18 (ie ptr to custom) */

extern struct {
	char name[20];
	struct mode vid_mode[number_modes_supported];
	} video_cards[];

/* now the list of working modes as selected by the user - 10 maximum */
/* one extra item at end (always 0) to simplify deletion */
extern struct {
	int   card_ID;
	int   which_mode;
	} ok_mode[];

const char *config_file_name = "dvpeg.cfg";		/* shared by vidsetup, dvpeg */


int load_config(void);
int get_key(void);
void config_problem();
int  change_defaults(int choice);
void show_defaults(int all);
int config_video(void);
int get_line(char * input_line);
void insert_in_list(int card, int mode);
int is_it_vga(int card, int mode);


/*
 *  Get a line of text but return and signal if ESC is hit
 *    return # char + 1 for return if ok,   0 if ESC hit
 *    that way a null input but not escape has a length of 1
 */

int get_line(char * input_line)
{
int i = 0;
char new_ch;

_setcursortype(_NORMALCURSOR);
do{
	new_ch = getche();
	input_line[i++] = new_ch;
	if (new_ch == back_space)
		if ((i -= 2) < 0) i = 0;
	} while ((new_ch != escape) && (new_ch != Return));
input_line[i-1] = 0;
_setcursortype(_NOCURSOR);
if (new_ch == escape) return 0;
else return i;
}



/*
 * do a test to see if a given card, mode is SVGA (1) or hi_color (0)
 */

int is_it_vga(int card, int mode)
{
/* check if its a custom mode and if so find correct card # */

if (card == last_card)
	card = video_cards[card].vid_mode[mode].mode_number & 0x00ff;	/* process funny mode # into card # */

if (card >= start_hi_color) return 0;
return 1;
}



/* do an insertion into the users list of modes ie the "edited" list
 * handle the special case of inserting a "custom" item
 * mode, card describe what you want to insert
 */

void insert_in_list(int card, int mode)
{
int	i;
int	ins_loc;				/* location to insert a new item into the users list of working modes */

ins_loc = 0;
/* first find the position of a mode that is non 0 and lower resolution than the selected */
for (i = 0; i < number_modes_in_list; i++)
	if (ok_mode[i].card_ID >= 0)
		if ((video_cards[ok_mode[i].card_ID].vid_mode[ok_mode[i].which_mode].y_size <
			video_cards[card].vid_mode[mode].y_size) &&
				( video_cards[card].vid_mode[mode].y_size != 0))
			ins_loc = i + 1;

/* inserting to a full list does nothing */
i = number_modes_in_list;
while( --i > ins_loc){
	ok_mode[i].card_ID = ok_mode[i-1].card_ID;
	ok_mode[i].which_mode = ok_mode[i-1].which_mode;
	}

/* now insert it - watchout for inserting at top + 1*/
if (ins_loc < number_modes_in_list){
	ok_mode[ins_loc].card_ID = card;
	ok_mode[ins_loc].which_mode = mode;
	}
}




/*
 * do an autodetect and setup for video card
 */

int config_video(void)
{
int svga, i;

	svga=whichvga();
	if (svga){
		if (aheada == 1) card_id = 0;
		if (aheadb == 1) card_id = 1;
		if (ativga == 1) card_id = 2;
		if (chipstech == 1) card_id = 3;
		if (everex == 1) card_id = 4;
		if (oaktech == 1) card_id = 5;
		if (genoa == 1) card_id = 6;
		if (ncr == 1) card_id = 7;
		if (paradise == 1) card_id = 8;
		if (trident == 1)
		if (t8900 == 1) card_id = 10;
			else card_id = 9;
		if (tseng == 1)
			if (tseng4 == 1) card_id = 12;
			else card_id = 11;
		if (video7 == 1) card_id = 13;
		if (cirrus == 1) card_id = 14;
		if (compaq == 1) card_id = 15;
		if (vesa == 1) card_id = 16;

		/* assume all modes are there and copy them over */
		for (i=0; i < number_modes_supported; i++)
			if (video_cards[card_id].vid_mode[i].mode_number != 0){
				ok_mode[i].card_ID = card_id;
				ok_mode[i].which_mode = i;
				}
		}
	else
		return 0;
return 1;
}


/* dump the current defaults into the window */
/* only flag is to show it all or partially */
/* assume that the window is big enough */

void show_defaults(int all)
{
	if (all){		/* only show this for vidsetup and outer file selection menu */
		cprintf("The preview Menu will ");
		if (view_defaults & ask_size_bit)
			cprintf("be shown    \r\n");
		else
			cprintf("not be shown\r\n");
		if (view_defaults & beep)
			cprintf("Sound is on \r\n");
		else
			cprintf("Sound is off\r\n");

		cprintf("Panning is ");
		if (view_defaults & panning_bit)
			cprintf("enabled");
		else
			cprintf("off    ");

		if (any_hi_color){
			cprintf("\r\nsvga Lockout on hi_color is o");
			if (view_defaults & only_hi_color)
				cprintf("n ");
			else
				cprintf("ff");
			}
		}
	else{
		cprintf("Panning is o");
		if (enable_pan)
			cprintf("n ");
		else
			cprintf("ff");
		}

	if (!gif_picture){
		cprintf("\r\nShrink is set to ");
		switch (shrink){
			case 1: cprintf("1/1 size\r\n");
					break;
			case 2: cprintf("1/2 size\r\n");
					break;
			case 3: cprintf("1/3 size\r\n");
					break;
			case 4: cprintf("1/4 size\r\n");
			}

		if (view_defaults & dithering_bit)
			cprintf("Dithering is on \r\n");
		else
			cprintf("Dithering is off\r\n");

		if (view_defaults & smoothing_bit)
			cprintf("Block smoothing is on \r\n");
		else
			cprintf("Block smoothing is off\r\n");

		if (view_defaults & quantize_bit)
			cprintf("two pass Quantizer is on\r\n");
		else
			cprintf("one pass Quantizer is on\r\n");

		if (view_defaults & grey_bit)
			cprintf("show as Grey_scale         \r\n");
		else
			cprintf("show as stored (Grey/color)\r\n");
		}
}



/* change the defaults in view_defaults int if requested */
int change_defaults(int choice)
{
switch(toupper(choice)){
	case 'L':
			view_defaults ^= only_hi_color;
			break;
	case 'P':
			view_defaults ^= panning_bit;
			break;
	case 'M':
			view_defaults ^= ask_size_bit;
			break;
	case 'Q':
			view_defaults ^= quantize_bit;
			break;
	case 'D':
			view_defaults ^= dithering_bit;
			break;
	case 'B':
			view_defaults ^= smoothing_bit;
			break;
	case 'G':
			view_defaults ^= grey_bit;
			break;
	case 'S':
			shrink = (shrink % 4) + 1;
			break;
	case 'E':
			view_defaults ^= beep;
			break;
	default:
		return 0;
	}
return 1;		/* signal it was a good key */
}



/* short message if there is a problem in the config file */
void config_problem(int problem_number)
{
printf("Error %i in dvpeg.cfg file.\r\n", problem_number);
printf("Perhaps the files does not exist or it has been corrupted.\r\n");
printf("Please delete dvpeg.cfg and run vidseteup.\r\n");
exit(-1);
}



/* get a key and strip that pesky 0 if its a usefull {arrow, page, insert, delete ..} key */

int get_key(void)
{
int cmd;
if ( (cmd = getch()) == 0) cmd = getch() << 8;
return cmd;
}



int load_config(void)
{
int	i,
		card_selected,
		num_custom;		/* index for custom modes */

FILE *config_file;

/* defaults incase no file exists */
shrink = 1;						/* set default for shrink */
view_defaults = dithering_bit | smoothing_bit | quantize_bit | panning_bit | ask_size_bit | beep;


strcat(config_name, config_file_name);
config_file = fopen(config_name, "rb");
if (config_file != NULL){						/* load the file mode descriptions */
	text_width = getw(config_file);
	shrink = getw(config_file);
	sort_mode = getw(config_file);
	view_defaults = getw(config_file);				/* various defaults ie grey ... */
	fgets(file_mask, 15, config_file);
	for (i=0; i < 15; i++)
		if (file_mask[i] == '\n') file_mask[i] = 0;		/* remove that \n since it is only needed for loading string in */
	fgets(default_path, 78, config_file);			/* default path ?? */
	for (i=0; i < 78; i++)
		if (default_path[i] == '\n') default_path[i] = 0;		/* remove that \n since it is only needed for loading string in */
	i = -1;
	while((card_selected = getw(config_file)) != -1){
		if (card_selected >= start_hi_color) any_hi_color = 1;		/* indicate a hi_color mode */
		ok_mode[++i].card_ID = card_selected;
		ok_mode[i].which_mode = getw(config_file);
		if (i >= number_modes_in_list - 1 || card_selected >= number_VGA_cards)
			config_problem(5);
		card_id = card_selected;		/* let the menu default to last card in the list */
		}
	getw(config_file);		/* clear off extra int */

	/* now load in the custom setup parameters if there are any */
	num_custom = 0;
	while((card_selected = getw(config_file)) != -1){
		ok_mode[++i].card_ID = card_selected;
		ok_mode[i].which_mode = getw(config_file);
		if (i >= number_modes_in_list - 1)
			config_problem(2);
		video_cards[last_card].vid_mode[num_custom].mode_number = card_selected;
		card_selected &= 0x00ff;
		if (card_selected >= 0 && card_selected < last_card){		/* -1 is to ignore "custom" card */
			if (num_custom >= number_modes_supported)
				config_problem(4);
			if (card_selected >= start_hi_color) any_hi_color = 1;		/* indicate a hi_color mode */
			video_cards[last_card].vid_mode[num_custom].x_size = ok_mode[i].which_mode;
			video_cards[last_card].vid_mode[num_custom].y_size = getw(config_file);
			ok_mode[i].which_mode = num_custom++;
			ok_mode[i].card_ID = last_card;
			}
		else config_problem(3);
		}
	fclose(config_file);
	return 1;
	}
else
	return 0;
}