/*
 *  drawing routines for dvpeg
 *
 */

#include "jinclude.h"

#include <dos.h>
#include <conio.h>

extern   unsigned char cirrus, everex, paradise, tseng, trident;
extern   unsigned char t8900, ativga, aheada, aheadb;
extern   unsigned char oaktech, video7, chipstech, tseng4, genoa;
extern   unsigned char ncr, compaq, vesa;
extern	int hi_color;      /* signals existance of hi color card */
extern   unsigned char vga512, vga1024;
extern   int maxx, maxy;


enum bit_locs{				/* masks for bits in word describing setup flags */
	grey_bit = 1,
	dithering_bit = 2,
	smoothing_bit = 4,
	quantize_bit = 8,
	panning_bit = 16,		/* disable panning completely ? */
	ask_size_bit = 32		/* show screen with defaults or pass it ?? */
	};

#ifndef arrow_left
#define  number_VGA_cards 20        /* the number of VGA cards supported */
#define	start_hi_color 17				/* the first number of the high_color cards ie the last 2 */
#define  last_card 19               /* number of VGA cards -1 : for simplifying code */
#define  number_modes_supported 6   /* the max number of video modes for each card */
#define  number_modes_in_list 10    /* the max number of modes in the user selected list */
#define  number_files_max 396       /* maximum number of files to be stored for selection -3 screens worth*/
#define	per_column 22					/* the number of files per column on text screen */


/*    definations for reading keyboard */

#define arrow_left 0x4b00
#define arrow_right 0x4d00
#define arrow_up 0x4800
#define arrow_down 0x5000
#define page_up 0x4900
#define page_down 0x5100
#define escape 27
#define home 0x4700
#define end 0x4f00
#define RTN 13
#define insert 0x5200
#define delete 0x5300
#define plus 43
#define minus 45
#define F1 0x3B00
#define F2 0x3C00
#define F3 0x3D00
#define F4 0x3E00
#define F5 0x3F00
#define F6 0x4000
#endif

/* buffer pointer for panning if needed/possible */
extern big_sarray_ptr raw_pic_ptr;		/* pointer to virt. pic. for panning, 3 used for hi_color mode; 1 otherwise */
extern int
	enable_pan,
	shrink,
	card_id,
	video_mode_used;
extern	unsigned char palbuf[256][3];

extern struct mode {
	int x_size;
	int y_size;
	int mode_number;};


/* for this struct.  All items should be in ascending order with 0x00 for the unused mode #'s */
/* custom is for typed in modes.  The actual card # is (ok_mode[].card_ID >> 8 ) % 0x00ff where *.card_ID & 0xff is 18 (ie ptr to custom) */

extern struct video_card {
	char name[20];
	struct mode vid_mode[number_modes_supported];
	} video_cards[];

/* now the list of working modes as selected by the user - 10 maximum */
/* one extra item at end (always 0) to simplify deletion */
extern struct {
	int   card_ID;
	int   which_mode;
	} ok_mode[];

int row,				/* row, col counters for plotting */
	col,
	color_out,		/* color to be written */
	col_cntr=1, 	/* row, col counters for shrinking */
	row_cntr=1;

/* from put_pixel_rows - taken out so I can re-init them for 2nd, 3rn ... calls for pictures */
int gr_row = 0,  		/* gr_row,col for pixel plotting*/
	gr_col,
	read_row = 0;		/* row for indexing into big buffer for reading ie panning */

static JSAMPROW output_row,			/* pseudo struct to hold 1 line for drawing */
			ptr0, ptr1, ptr2;		/* pointer to rows */

enum card_types{
	ati_hi,
	tseng_hi,
	normal_vga
	};



/* put a box on the screen for showing new panning area
 *  2 edges will not be visable and the other 2 lines will be cut off
 *  therefore only show two lines and save the image underneath in the
 *    leftmost and topmost lines
 */

void box_it(int delta_x, int delta_y)
{
int x, y,
	old_zero;
/*unsigned char	pallet[2][3];

pallet[
setmany(pallet,0,0);*/

y = delta_y;
for (x=0; x < maxx; x++){
	point(x, 0, rdpoint(x,y));
	point(x, y, 0);
	}
x = delta_x;
for (y=0; y < maxy; y++){
	point(0, y, rdpoint(x,y));
	point(x, y, 0);
	}
}



/*
 * This function is called repeatedly, with a few more rows of pixels supplied
 * on each call.  With the current JPEG code, some multiple of 8 rows will be
 * passed on each call except the last, but it is extremely bad form to depend
 * on this.  You CAN assume num_rows > 0.
 * The data is supplied in top-to-bottom row order (the standard order within
 * a JPEG file).  If you cannot readily use the data in that order, you'll
 * need an intermediate array to hold the image.  See jwrrle.c for an example
 * of outputting data in bottom-to-top order.
 *
 * The data is supplied as a 3-D array of JSAMPLEs, indexed as
 *		JSAMPLE pixel_data[component][row][column]
 * where component runs from 0 to cinfo->final_out_comps-1, row runs from 0 to
 * num_rows-1, and column runs from 0 to cinfo->image_width-1 (column 0 is
 * left edge of image).  Note that this is actually an array of pointers to
 * pointers to arrays rather than a true 3D array, since C does not support
 * variable-size multidimensional arrays.
 * JSAMPLE is typically typedef'd as "unsigned char".  If you want your code
 * to be as portable as the JPEG code proper, you should always access JSAMPLE
 * values with the GETJSAMPLE() macro, which will do the right thing if the
 * machine has only signed chars.
 *
 * If quantize_colors is true, then there is only one component, and its values
 * are indexes into the previously supplied colormap.  Otherwise the values
 * are actual data in your selected output colorspace.
 */


void put_pixel_rows (decompress_info_ptr cinfo, int num_rows, JSAMPIMAGE pixel_data)
/* Write some rows of output data */
{

/* note ------ row is not going from 0 to max because it goes in sections ------*/
/*   so gr_row is set externally and incremented here - this allows external control
 *		ie in the case of interlaced gifs  - dito for read_row
 */

for (row = 0; row < num_rows; row++) {
	ptr0 = pixel_data[0][row];
	if (enable_pan){
		output_row = *((*cinfo->emethods->access_big_sarray)
							(raw_pic_ptr, read_row++, TRUE));
		_fmemcpy((void far *) output_row, (void far *) ptr0, (size_t) cinfo->image_width);
		}
	for (gr_col = col = 0; col < cinfo->image_width; col++){
		color_out = GETJSAMPLE(*ptr0++);
		if (gr_row < maxy && gr_col < maxx)
			if (row_cntr == 1 && col_cntr == 1){
				point_spec();
				gr_col++;
				}
		if (++col_cntr > shrink)		/* should be faster than mod */
			col_cntr = 1;
		}
	if (++row_cntr > shrink){
		gr_row++;
		row_cntr = 1;
		}
	}
}



/*
 * put pixel routine for hi_color video cards
 *
 */

void put_pixel_hi (decompress_info_ptr cinfo, int num_rows, JSAMPIMAGE pixel_data)
{
/* note ------ row is not going from 0 to max because it goes in sections ------*/

for (row = 0; row < num_rows; row++) {
	ptr0 = pixel_data[0][row];
	ptr1 = pixel_data[1][row];
	ptr2 = pixel_data[2][row];
	if (enable_pan){
		output_row = *((*cinfo->emethods->access_big_sarray)
			(raw_pic_ptr, read_row, TRUE));
		}
	for (gr_col = col = 0; col < cinfo->image_width; col++){
		/* remember this is going from 8 bit RGB components to 3 * 5 bits */
		color_out = ((GETJSAMPLE(*ptr2++) >> 3) & 0x1f) +
						((GETJSAMPLE(*ptr1++) << 2) & 0x3e0) +
						((GETJSAMPLE(*ptr0++) << 7) & 0x7c00);
		if (enable_pan){
			*output_row++ = color_out >> 8;
			*output_row++ = color_out & 0xff;
			}

/* removed x range checking */
		if (gr_row < maxy && gr_col < maxx)
			if (row_cntr == 1 && col_cntr == 1)
				if (tseng4){
					point_hi(gr_col++, gr_row, color_out);
					}
				else{
					point_wide(gr_col, gr_row, color_out);
					gr_col += 2;
					}
		if (++col_cntr > shrink)		/* should be faster than mod */
			col_cntr = 1;
		}
	if (++row_cntr > shrink){
		gr_row++;
		row_cntr = 1;
		}
	}
}


void output_term (decompress_info_ptr cinfo)
/* Finish up at the end of the output */
{
static int
		x_pos, y_pos,		/*	current upper left x, y position */
		x_max, y_max,		/* maximum video x, y max (counting from 1 */
		x_size, y_size,	/* picture size */
		x,						/* drawing counters */
		old_color_scale,	/* old one to see if its changed */
		color_scale,		/* factor to scale pallete up or down */
		old_contrast_scale,
		contrast_scale,	/* factor to scale contrast up or down  0 -> +/-32 */
		y_delta, x_delta,
		redraw,				/* cmd to force redraw */
		step,					/* step size (pixels) for pan - first used as a keypress counter*/
		card_type,			/* a unique # for card using {hicolor, Tseng_hi_color, Ati_hi_color, other_VGA) */
		temp1, temp2, temp3,
		cmd,
		cmd2;
static unsigned char	pallet[256][3];	/* duplicate pallete for contrast / brightness */


#define con_ctrl(value) (((value - 128) * contrast_scale) / 48 + value)
#define bright_ctrl(value)  (value * color_scale / 40 + value)



if (hi_color)
	if (tseng4) card_type = tseng_hi;
	else card_type = ati_hi;		  		/* assume ATI */
else{
	card_type = normal_vga;					/* assume normal VGA */
	for (x=0; x < 256; x++){		/* also setup pallet for non-hi_color */
		pallet[x][0] = palbuf[x][0] >> 2;
		pallet[x][1] = palbuf[x][1] >> 2;
		pallet[x][2] =	palbuf[x][2] >> 2;
		}
	}

x_size = cinfo->image_width;
if (card_type == ati_hi) x_size /= 2;		/* patch up that * 2 for ATI hi_color modes */
y_size = cinfo->image_height;
x_max = video_cards[card_id].vid_mode[video_mode_used].x_size;
y_max = video_cards[card_id].vid_mode[video_mode_used].y_size;
x_pos = y_pos = color_scale = redraw = contrast_scale = 0;

sound(1500);
delay(150);
nosound();

while(1){
	old_color_scale = color_scale;			/* setup to detect changes in brightness or contrast */
	old_contrast_scale = contrast_scale;
	y_delta = x_delta = redraw = 0;
	step = 1;								/* assume 1 keypress only */
	cmd = get_key();
	while (kbhit()){
		cmd2 = get_key();						/* count the number of times a key is hit (for panning) */
		if (cmd2 == cmd) step++;
		if (cmd2 == escape){						/* if ESC then exit regardless */
			step = 1;
			cmd = escape;
			}
		}

	step *= 15;			/* step 15 pixels per keypress */
	switch (cmd){
		case minus:			shrink++;
								if (shrink > 4) shrink = 4;	/* limit to 1/4 size */
								else redraw = 1;
								break;
		case plus:			shrink--;
								if (shrink < 1) shrink = 1;	/* limit to 1:1 since can't zoom */
								else redraw = 1;
								break;
		case page_up:		color_scale += 2;			/* turn up intensity */
								if (card_type == ati_hi)
									hi_bright(1,1);
								if (color_scale > 100) color_scale = 100;
								break;
		case page_down:	if (--color_scale < -40) color_scale = -40;			/* turn down intensity */
								break;
		case arrow_up:		if (y_pos - step >= 0)
									y_delta = -step;
								else
									y_delta = -y_pos;		/* move all the way to top */
								break;
		case arrow_down:	if (y_pos + step + y_max * shrink <= y_size)
									y_delta = step;
								break;
		case arrow_left:	if (x_pos - step >= 0)
									x_delta = -step;
								else
									x_delta = -x_pos;
								break;
		case arrow_right:	if (x_pos + step + x_max * shrink <= x_size)
									x_delta = step;
								break;
		case RTN:
		case escape:		return;
		case home:			contrast_scale += 2;
								if (contrast_scale > 32)
									contrast_scale = 32;
								break;
		case end:			contrast_scale -= 2;
								if (contrast_scale < -32)
									contrast_scale = -32;
								break;
/*		case F1:				init_screen();
								print_mem_stats();
								getch();
								break;*/
		}
	if ( (color_scale != old_color_scale || contrast_scale != old_contrast_scale)
			 && hi_color == 0){
		for (x=0; x < 256; x++){
			temp1 = con_ctrl(palbuf[x][0]);
			temp1 = (bright_ctrl(temp1) + 2) >> 2;
			temp2 = con_ctrl(palbuf[x][1]);
			temp2 = (bright_ctrl(temp2) + 2) >> 2;
			temp3 = con_ctrl(palbuf[x][2]);
			temp3 = (bright_ctrl(temp3) + 2) >> 2;
			if (temp1 < 64 && temp2 < 64 && temp3 < 64 &&
				temp1 >= 0 && temp2 >= 0 && temp3 >= 0){
				pallet[x][0] = temp1;	/* only change if no color wrapping > 64 */
				pallet[x][1] = temp2;
				pallet[x][2] = temp3;
				}
			}
		setmany(pallet, 0, 256);
		}

	if (enable_pan && ( x_delta != 0 || y_delta != 0 || redraw)){
		x_pos += x_delta;
		y_pos += y_delta;
		for (gr_row=0; gr_row < y_max; gr_row++){
			row = gr_row * shrink + y_pos;
			if (row < y_size){
				output_row = *((*cinfo->emethods->access_big_sarray)
						(raw_pic_ptr, row, FALSE));
				output_row += x_pos;
				for (x = x_pos; x < x_size; x++){
					col = x * shrink;
					if (col < x_size)
						switch (card_type){
							case tseng_hi:
								point_hi(x-x_pos, gr_row, (*output_row++ << 8) + *output_row);
								break;
							case ati_hi:
								point(2 * (x-x_pos), gr_row, (*output_row++ << 8) + *output_row);
								break;
							case normal_vga:
								point(x-x_pos, gr_row, *output_row);
							}
					output_row += shrink;
					}
				}
			}
		}
	}
  /* This termination routine may not need to do anything. */
  /* Note that the JPEG code will only call it during successful exit; */
  /* if you want it called during error exit, you gotta do that yourself. */
}





