/*
 * jdmain.c  ver 1.0I July 24, 1992
 * written by Eric Praetzel
 *

 May 30, 1992
  - patch ATI driver (hardcoded a changable value that was changed)
  - fixed VESA modes
  - added ATI hi_color (32,768 color) mode as card #17 - actually sets ati_hi_color flag
  - note FORCED VIDEO MODE defaults to 1024 size (now removed) --- big mistake if its a lower resolution
  - ATI hi_color x size is patched to work with range checking and allow proper page selection
  - added Tseng 4000 ramdac hi-color modes
  - added multiple keypress detection to move multiple steps per draw
  - insert mode into the user list of modes sorts by y size (assume x also increases with x)
  - the user can fill the mode list with 10 of 320 * 200 if he wants - ie no checking
  - took out jquant1 in ?.h file since why bother using it?
  - fixed some erratic functioning in forcevga (doing something funny crossing segment boundary ??? - seems fixed

 June 7, 1992
- at version 1B
  - made pallet limit if a color hits 255 --> dark areas still lighten but bright ones don't
  - added file selection from a menu (and mode, shrink)
  - can view one file after another without exiting
  - file name mask can be used
  - files names can be sorted
  - a bit of help at places
  - can select video mode for viewing
  - can adjust panning, shrinking before view
  - added color railing on brightness if a color component is going to go > 64 so colors don't wrap anymore
  - added sort modes (name, date, size)
  - config. file is now assumed to be in same dir as dvpeg.exe
  - path, drive now changable from within program
  - other directories shown with files to allow moving around
  - a file name can be given at the cmd line and it is shown first
  - added ability to change smoothing, dithering
- at version 1C
  - put some common stuff (vidsetup, dvpeg) into dvutil.c and call it in with # include - yech but easy to do
- at version 1e
  - fixed problem with 1 pass quantizing
  - can ESC out of viewing now (still a bit slow at times
  - custom video modes are now possible
  - 1 pass/ 2 pass & quantify colors problems were fixed (whole routine was _after_ jump vectors were set)
  - finally fixed boundary problem on panning
  - attempts at speed were thwarted (tried jquant2)
  - patched problem with switching to a drive that was in root - ie gave a:\\
  - fixed video testing on hi_color - it used to generate color comp's 0 .. 64 not 0 .. 32
- at version 1g
  - hi_color modes work (ATI at least).  I forgot about the 8 bit RGB components haveing to be shifted to 5 bits
  - A new jrevdct routine has been put in.  Its about twice as fast as the old one.  Over a 1 min image its about 2 sec faster
	  The 32 bit assembler version is 4 * faster than the 16 bit C code !
  - revamped default flags and put them into both menus but they are always loaded from dvpeg.cfg
  - added Ahead B card
  - gif viewing added (interlaced problems still & its slow )
  - made special pixel plotting for VGA, streamlined ATI hi_color plotting a bit
- at version 1h
  - patched wierd panning problem (if pic was rect and fit on y but no x panning bombed
  - added default director into vidsetup, changed so dvpeg will autodetect
  - added ability to goto a directory in dvpeg using F6
  - seperated out video drawing to rewrite in assembler
  - any errors are now handled properly without program exit
  - ESC pressing will halt for 1 char press, but if ESC from menu you hop back immediately
  - added beep on error (low freq) , done (higher freq)
  - added code to force VGA not hi_color on GIF (will not work with custom definations)
  - j_copy_block_rows, j_copy_samp_rows was changed to use _fmemcpy which is a lot faster
  - changed jzero_far to _fsetmem()  for Borland C - nice speed improvement
  - changed copying to buffer from inner drawing loop to _fmemcpy on super_vga for speed - can't do on hi_color due to bit packing

To add
 - use _fmemcpy looping technique to speed up drawing - ie ignore block testing (multiply) on each point
 - ATI hi_color fix doubles X size therefore paning selection is wrong!!! - check for other problems too
 - add ATI test for 1 meg??? or just let the user set and test modes ??
 - rotate by 90 deg??
 - add wrapping of file selection from left to right and vise-versa?
 - try changing range checks with array lookup for speed??
 - speed up ATI redrawing ???
 - still have to figure out Cirrus card
 - problem with Compaq bank selector ???
 *
 */


#include "jinclude.h"
#ifdef INCLUDES_ARE_ANSI
#include <stdlib.h>		/* to declare exit() */
#endif
#ifdef NEED_SIGNAL_CATCHER
#include <signal.h>		/* to declare signal() */
#endif


#ifdef DONT_USE_B_MODE		/* define mode parameters for fopen() */
#define READ_BINARY	"r"
#define WRITE_BINARY	"w"
#else
#define READ_BINARY	"rb"
#define WRITE_BINARY	"wb"
#endif

#ifndef EXIT_FAILURE		/* define exit() codes if not provided */
#define EXIT_FAILURE  1
#endif


#include "jversion.h"		/* for version message */

#include <dir.h>
#include <string.h>
#include <dos.h>
#include <conio.h>
#include <setjmp.h>
#include <alloc.h>

extern unsigned _stklen = 8192;

#include "jvsetup.h"			/* defines for  viewer */
#include "viewer.h"			/* variables for dvpeg, vidsetup */

/*
 * This list defines the known output image formats
 * (not all of which need be supported by a given version).
 * You can change the default output format by defining DEFAULT_FMT;
 * indeed, you had better do so if you undefine PPM_SUPPORTED.
 */

typedef enum {
	FMT_GIF,		/* GIF format */
	FMT_PPM,		/* PPM/PGM (PBMPLUS formats) */
	FMT_RLE,		/* RLE format */
	FMT_TARGA,		/* Targa format */
	FMT_TIFF		/* TIFF format */
} IMAGE_FORMATS;



#ifndef DEFAULT_FMT		/* so can override from CFLAGS in Makefile */
#define DEFAULT_FMT	FMT_PPM
#endif


struct{				/* store upto 2 full screens of file names */
	char name[13];
	unsigned  date;
	long size;
	} files[number_files_max+1];

/* Neat little trick to do a jump and clean up stack */
jmp_buf setjmp_buffer;

static external_methods_ptr emethods; /* needed for access to message_parm */

/* buffer pointer for panning if needed/possible */
big_sarray_ptr raw_pic_ptr;		/* pointer to virt. pic. for panning, 3 used for hi_color mode; 1 otherwise */

/* stuff for file selection */
char file_mask[20];	/* mask for file selection */
char file_path[70];	/* path to files to be viewed */


int text_width,		/* text mode width - not used yet */
		sort_mode;			/* sort type for file names - not used yet */

/* externally defined vars */
extern int
	gr_row,
	read_row,
	col_cntr,
	row_cntr;

/* external code */
extern void put_pixel_rows (decompress_info_ptr cinfo, int num_rows, JSAMPIMAGE pixel_data);

extern void put_pixel_hi (decompress_info_ptr cinfo, int num_rows, JSAMPIMAGE pixel_data);

extern void output_term (decompress_info_ptr cinfo);


int init_screen();
void check_file_in(decompress_info_ptr cinfo);
void open_window(int width, int height);		/* open a window for selection of file_mask, sort_mode ... */
void get_files(void);	/* get list of files that match spec's and figure out how to draw on screen */
void show_it(decompress_info_ptr cinfo, char *file_name);
void clear_list(void);


/*
 * Signal catcher to ensure that temporary files are removed before aborting.
 * NB: for Amiga Manx C this is actually a global routine named _abort();
 * see -Dsignal_catcher=_abort in CFLAGS.  Talk about bogus...
 */

#ifdef NEED_SIGNAL_CATCHER

GLOBAL void
signal_catcher (int signum)
{
  emethods->trace_level = 0;	/* turn off trace output */
  (*emethods->free_all) ();	/* clean up memory allocation & temp files */
  exit(signum);
}

#endif




/* This routine is used for any and all trace, debug, or error printouts
 * from the JPEG code.  The parameter is a printf format string; up to 8
 * integer data values for the format string have been stored in the
 * message_parm[] field of the external_methods struct.
 */

METHODDEF void
trace_message (const char *msgtext)
{
  cprintf(msgtext,
	  emethods->message_parm[0], emethods->message_parm[1],
	  emethods->message_parm[2], emethods->message_parm[3],
	  emethods->message_parm[4], emethods->message_parm[5],
	  emethods->message_parm[6], emethods->message_parm[7]);
  cprintf("\n");	/* there is no \n in the format string! */
}

/*
 * The error_exit() routine should not return to its caller.  The default
 * routine calls exit(), but here we assume that we want to return to
 * read_JPEG_data, which has set up a setjmp context for the purpose.
 * You should make sure that the free_all method is called, either within
 * error_exit or after the return to the outer-level routine.

 *  If the message is of 0 length then just clean up and pass thru
 *  If the message if of 1 char length or > then wait for at least 1 keypress
 */

METHODDEF void
error_exit (const char *msgtext)
{
if (view_defaults & beep && (strlen(msgtext) > 1) ){
	sound(40);
	delay(500);
	nosound();
	getch();
	init_screen();
	open_window(50, 12);
	trace_message(msgtext);	/* report the error message */
	cprintf("\r\nMemory left in near heap:\r\n    %lu bytes\r\n",(unsigned long) coreleft());
	cprintf("Bytes above highest block in far heap:\r\n    %lu bytes\r\n",farcoreleft());
	cprintf("Hit any key.\r\n");
	}
(*emethods->free_all) ();	/* clean up memory allocation & temp files */
if (strlen(msgtext) >= 1) getch();
longjmp(setjmp_buffer, 1);	/* return control to outer routine */
/*  exit(EXIT_FAILURE);*/
}



/*
 * clear the (edited) user list of chosen video modes
 */

void clear_list(void)
{
int c;
for (c = 0; c < number_modes_in_list; c++)
	ok_mode[c].card_ID = -1;						/* signal as unused to ensure undefined modes are not used */

}



/*
 * To accept the image data from decompression, you must define four routines
 * output_init, put_color_map, put_pixel_rows, and output_term.
 *
 * You must understand the distinction between full color output mode
 * (N independent color components) and colormapped output mode (a single
 * output component representing an index into a color map).  You should use
 * colormapped mode to write to a colormapped display screen or output file.
 * Colormapped mode is also useful for reducing grayscale output to a small
 * number of gray levels: when using the 1-pass quantizer on grayscale data,
 * the colormap entries will be evenly spaced from 0 to MAX_JSAMPLE, so you
 * can regard the indexes are directly representing gray levels at reduced
 * precision.  In any other case, you should not depend on the colormap
 * entries having any particular order.
 * To get colormapped output, set cinfo->quantize_colors to TRUE and set
 * cinfo->desired_number_of_colors to the maximum number of entries in the
 * colormap.  This can be done either in your main routine or in
 * d_ui_method_selection.  For grayscale quantization, also set
 * cinfo->two_pass_quantize to FALSE to ensure the 1-pass quantizer is used
 * (presently this is the default, but it may not be so in the future).
 *
 * The output file writing modules (jwrppm.c, jwrgif.c, jwrtarga.c, etc) may be
 * useful examples of what these routines should actually do, although each of
 * them is encrusted with a lot of specialized code for its own file format.
 */


METHODDEF void
output_init (decompress_info_ptr cinfo)
/* This routine should do any setup required */
{

  /* This routine can initialize for output based on the data passed in cinfo.
	* Useful fields include:
	*	image_width, image_height	Pretty obvious, I hope.
	*	data_precision			bits per pixel value; typically 8.
	*	out_color_space			output colorspace previously requested
	*	color_out_comps			number of color components in same
	*	final_out_comps			number of components actually output
	* final_out_comps is 1 if quantize_colors is true, else it is equal to
	* color_out_comps.
	*
	* If you have requested color quantization, the colormap is NOT yet set.
	* You may wish to defer output initialization until put_color_map is called.
	*/
int i, mode_num;

if (kbhit())
	if (getch() == escape)
		ERREXIT(cinfo->emethods, "E");

if (hi_color){		/* only do this if its in hi_color */

	i = ok_mode[video_mode_used].card_ID;		/* make the lines a bit easier to read by getting card # */

	if (i == last_card){				/* check for custom mode and fix card # */
		mode_num = ok_mode[video_mode_used].which_mode;
		i = video_cards[last_card].vid_mode[mode_num].mode_number;
		forcevga(i & 0x00ff);
		svgamode(i >> 8, video_cards[last_card].vid_mode[mode_num].x_size);
		}
	else{
		forcevga(i);
		svgamode(video_cards[i].vid_mode[ok_mode[video_mode_used].which_mode].mode_number,
				video_cards[i].vid_mode[ok_mode[video_mode_used].which_mode].x_size);
		}
	}
}



/*
 * This routine is called if and only if you have set cinfo->quantize_colors
 * to TRUE.  It is given the selected colormap and can complete any required
 * initialization.  This call will occur after output_init and before any
 * calls to put_pixel_rows.  Note that the colormap pointer is also placed
 * in a cinfo field, whence it can be used by put_pixel_rows or output_term.
 * num_colors will be less than or equal to desired_number_of_colors.
 *
 * The colormap data is supplied as a 2-D array of JSAMPLEs, indexed as
 *		JSAMPLE colormap[component][indexvalue]
 * where component runs from 0 to cinfo->color_out_comps-1, and indexvalue
 * runs from 0 to num_colors-1.  Note that this is actually an array of
 * pointers to arrays rather than a true 2D array, since C does not support
 * variable-size multidimensional arrays.
 * JSAMPLE is typically typedef'd as "unsigned char".  If you want your code
 * to be as portable as the JPEG code proper, you should always access JSAMPLE
 * values with the GETJSAMPLE() macro, which will do the right thing if the
 * machine has only signed chars.
 */

METHODDEF void
put_color_map (decompress_info_ptr cinfo, int num_colors, JSAMPARRAY colormap)
/* Write the color map */
{
int i, mode_num;
unsigned char	pallet[256][3];	/* duplicate pallete that has 6 bit not 8 bit samples */

	/* remember it only gets here if it is not hi_color */


i = ok_mode[video_mode_used].card_ID;		/* make the lines a bit easier to read by getting card # */

if (i == last_card){				/* check for custom mode and fix card # */
	mode_num = ok_mode[video_mode_used].which_mode;
	i = video_cards[last_card].vid_mode[mode_num].mode_number;
	forcevga(i & 0x00ff);
	svgamode(i >> 8, video_cards[last_card].vid_mode[mode_num].x_size);
	}
else{
	forcevga(i);
	svgamode(video_cards[i].vid_mode[ok_mode[video_mode_used].which_mode].mode_number,
			video_cards[i].vid_mode[ok_mode[video_mode_used].which_mode].x_size);
	}

if (colormap != NULL){		/* removed test for color_space = CS_RGB */
	if (cinfo->out_color_space == CS_RGB)
		for (i=0; i < num_colors; i++){
			palbuf[i][0] = GETJSAMPLE(colormap[0][i]);
			palbuf[i][1] = GETJSAMPLE(colormap[1][i]);
			palbuf[i][2] = GETJSAMPLE(colormap[2][i]);
			pallet[i][0] = GETJSAMPLE(colormap[0][i]) >> 2;
			pallet[i][1] = GETJSAMPLE(colormap[1][i]) >> 2;
			pallet[i][2] = GETJSAMPLE(colormap[2][i]) >> 2;
			}
	else
		for (i=0; i < num_colors; i++){
			palbuf[i][0] = palbuf[i][1] = palbuf[i][2] = GETJSAMPLE(colormap[0][i]);
			pallet[i][0] = pallet[i][1] = pallet[i][2] = palbuf[i][0] >> 2;
			}
	setmany(pallet,0,256);
	}
else{
	printf("color map pointer = NULL\n");
	getch();
	}

}



/*
 * This routine gets control after the JPEG file header has been read;
 * at this point the image size and colorspace are known.
 * The routine must determine what output routines are to be used, and make
 * any decompression parameter changes that are desirable.  For example,
 * if it is found that the JPEG file is grayscale, you might want to do
 * things differently than if it is color.  You can also delay setting
 * quantize_colors and associated options until this point.
 *
 * j_d_defaults initializes out_color_space to CS_RGB.  If you want grayscale
 * output you should set out_color_space to CS_GRAYSCALE.  Note that you can
 * force grayscale output from a color JPEG file (though not vice versa).
 */

METHODDEF void
d_ui_method_selection (decompress_info_ptr cinfo)
{
static int
		i, temp,
		quantize,
		repaint,
		largest_y,		/* for finding the largest y video mode in the list */
		temp_y;

  /* if grayscale input, force grayscale output; */
  /* else leave the output colorspace as set by main routine. */
  if (cinfo->jpeg_color_space == CS_GRAYSCALE)
	 cinfo->out_color_space = CS_GRAYSCALE;

  /* select output routines */
  cinfo->methods->output_init = output_init;
  cinfo->methods->put_color_map = put_color_map;
  cinfo->methods->output_term = output_term;


/* first pick the appropiate modes and sort them into order (ie low to hi)
 *  - only keep SVGA modes for GIF and hi_color for JPEGS
 *  - bomb if GIF and only hi_color modes and check to make sure that some
 *     hi_color modes exist for jpeg or else use SVGA for JPEG as a last resort
 */
clear_list();
for (i = 0; i < number_modes_in_list; i++)
	if (all_modes[i].card_ID >= 0)		/* only bother if its a valid mode and not flaged as empty */
		switch (gif_picture){
			case 0:		/* not a gif so only keep hi_color modes */
					if (!is_it_vga(all_modes[i].card_ID, all_modes[i].which_mode))
						insert_in_list(all_modes[i].card_ID, all_modes[i].which_mode);
					break;
			case 1:		/* we've got a gif only keep SVGA */
					if (is_it_vga(all_modes[i].card_ID, all_modes[i].which_mode))
						insert_in_list(all_modes[i].card_ID, all_modes[i].which_mode);
					break;
			}

if (gif_picture && ok_mode[0].card_ID < 0)		/* if its gif and there are no SVGA modes bomb */
	ERREXIT(cinfo->emethods, "Need SVGA modes for GIFs");

if (!gif_picture)
	if (ok_mode[0].card_ID < 0)		/* if jpeg and no viewing modes ie no hi_color modes */
		for (i = 0; i < number_modes_in_list; i++){	/* copy over all modes - by default they are SVGA */
			ok_mode[i].card_ID =	all_modes[i].card_ID;
			ok_mode[i].which_mode = all_modes[i].which_mode;
			}
	else{
	/* if its grey scale keep only SVGA modes since they are better */
		if (cinfo->out_color_space == CS_GRAYSCALE){
			clear_list();
			for (i = 0; i < number_modes_in_list; i++)
				if (is_it_vga(all_modes[i].card_ID, all_modes[i].which_mode))
					insert_in_list(all_modes[i].card_ID, all_modes[i].which_mode);
			}
		else		/* check if we have higher resolution SVGA modes than hi_color modes */
			if (! (view_defaults & only_hi_color)){
				/* well the user wants to consider SVGA modes too */
				/* only get SVGA modes with higher resolution */
				largest_y = 0;
				for (i=0; i < number_modes_in_list; i++)		/* find the largest y size ie largest screen size */
					if (ok_mode[i].card_ID >= 0){
						temp_y = video_cards[ok_mode[i].card_ID].vid_mode[ok_mode[i].which_mode].y_size;
						if (temp_y > largest_y) largest_y = temp_y;
						}

				for (i=0; i < number_modes_in_list; i++)
					if (all_modes[i].card_ID >= 0
							&& is_it_vga(all_modes[i].card_ID, all_modes[i].which_mode)		/* ok its a vga mode now is it big enough? */
							&& video_cards[all_modes[i].card_ID].vid_mode[all_modes[i].which_mode].y_size > largest_y)
						insert_in_list(all_modes[i].card_ID, all_modes[i].which_mode);
				}
		}


/* lets see what the user wants
 *		- first find good window size
 */

	/* first if image is > all modes default to largest mode */
	for (i = 0; i < number_modes_in_list; i++)
		if (ok_mode[i].card_ID >= 0) video_mode_used = i;

	for (i = number_modes_in_list - 1; i >=0; i--)
	/* fudge the size calculation by 5 pixels for those pics that are slightly bigger than the mode */
		if (video_cards[ok_mode[i].card_ID].vid_mode[ok_mode[i].which_mode].x_size >= cinfo->image_width - 10
				&& video_cards[ok_mode[i].card_ID].vid_mode[ok_mode[i].which_mode].y_size >= cinfo->image_height - 10
				&&	ok_mode[i].card_ID >= 0)
			video_mode_used = i;

/* setup enable pan because the user may have the menu turned off */
enable_pan = view_defaults & panning_bit;

if (video_cards[ok_mode[video_mode_used].card_ID].vid_mode[ok_mode[video_mode_used].which_mode].y_size >= cinfo->image_height / shrink - 5
	 && video_cards[ok_mode[video_mode_used].card_ID].vid_mode[ok_mode[video_mode_used].which_mode].x_size >= cinfo->image_width / shrink - 5)
	enable_pan = 0;

repaint = 1;
i = 0;		/* make sure we do this once if asked for */
while ( (i != RTN) && (view_defaults & ask_size_bit)){

/* only clear and repaint if absolutely necessary - ie avoid the flicker */
	if (repaint){
		open_window(55, 21);

		gotoxy(1,1);
		textcolor(WHITE);
		cprintf("Image Size: %4li * %4li  : ",cinfo->image_width, cinfo->image_height);
		repaint = 0;
		if (cinfo->out_color_space == CS_RGB)
			cprintf("color\r\n");
		else
			cprintf("greyscale\r\n");
		}

	enable_pan = view_defaults & panning_bit;

	if (video_cards[ok_mode[video_mode_used].card_ID].vid_mode[ok_mode[video_mode_used].which_mode].y_size >= cinfo->image_height / shrink
		 && video_cards[ok_mode[video_mode_used].card_ID].vid_mode[ok_mode[video_mode_used].which_mode].x_size >= cinfo->image_width / shrink)
	 enable_pan = 0;

	gotoxy(1,2);
	show_defaults(0);

	gotoxy(1,9);
	cprintf("The available video modes are:\n\r");
	for (i=0; i < number_modes_in_list; i++)
		if (ok_mode[i].card_ID >= 0){
			if (i == video_mode_used)
				textcolor(LIGHTMAGENTA);
			else	textcolor(LIGHTGRAY);

			temp = ok_mode[i].card_ID;
			if (temp == last_card){
				/* temp for real card / mode # if its custom */
				temp = video_cards[temp].vid_mode[ok_mode[i].which_mode].mode_number;
				cprintf("Cust %15s    %4i   %5i\r\n",video_cards[temp & 0x00ff].name,
					video_cards[last_card].vid_mode[ok_mode[i].which_mode].x_size,
					video_cards[last_card].vid_mode[ok_mode[i].which_mode].y_size);
				}
			else
				cprintf("     %15s    %4i   %5i\r\n",video_cards[ok_mode[i].card_ID].name,
					video_cards[ok_mode[i].card_ID].vid_mode[ok_mode[i].which_mode].x_size,video_cards[ok_mode[i].card_ID].vid_mode[ok_mode[i].which_mode].y_size);
			textcolor(WHITE);
			}
	switch( (i = get_key()) ){
		case escape:
				error_exit("");
				break;
		case F1:
				clrscr();
				cprintf("up/down arrow - select a video mode\r\n");
				cprintf("enter - check out that picture\r\n");
				cprintf("escape - exit\r\n");
				cprintf("P - toggle panning\r\n");
				cprintf("S - adjust shrinking\r\n");
				cprintf("D - toggle dithering\r\n");
				cprintf("B - toggle block smoothing\r\n");
				cprintf("G - toggle grayscale colorspace\r\n");
				cprintf("Q - toggle one / two pass quantizer\r\n");
				cprintf("M - toggle this menu on/off\r\n");
				cprintf("E - toggle beep / error messages\r\n");
				if (any_hi_color)
					cprintf("L - Lock out/in vga modes for jpegs\r\n");
				getch();
				repaint = 1;
				break;
		case arrow_up:
				do{				/* make sure that we get an existing mode */
					if (video_mode_used > 0) video_mode_used -=1;
					else video_mode_used = number_modes_supported - 1;
					} while (ok_mode[video_mode_used].card_ID == -1);
				break;
		case arrow_down:
				do{
					if (video_mode_used < number_modes_supported - 1) video_mode_used += 1;
					else video_mode_used = 0;
					} while (ok_mode[video_mode_used].card_ID == -1);
				break;
		default:
				change_defaults(i);
		}
	}		/* finally the close of that while */

quantize = view_defaults & quantize_bit;

if (view_defaults & grey_bit & !gif_picture){		/* only go to grey scale if its color - ie grey will already show as grey */
	if (cinfo->out_color_space != CS_GRAYSCALE)
		cinfo->out_color_space = CS_GRAYSCALE;
	quantize = 0;
	}
cinfo->use_dithering = view_defaults & dithering_bit;
cinfo->do_block_smoothing = view_defaults & smoothing_bit;

/* check if hi_color is chosen - if so do setup */
hi_color = 1 - is_it_vga(ok_mode[video_mode_used].card_ID, ok_mode[video_mode_used].which_mode);


/* pick a different putting routine for hi_color vs VGA ie for speed */
if (hi_color)
	cinfo->methods->put_pixel_rows = put_pixel_hi;
else
	cinfo->methods->put_pixel_rows = put_pixel_rows;

if (!gif_picture)
	if (hi_color == 1){
		if (view_defaults & ask_size_bit)
			cprintf("Hi_color mode being used\r\n");
		cinfo -> quantize_colors = FALSE;
		cinfo -> two_pass_quantize = FALSE;
		}
	else{
		if (view_defaults & ask_size_bit)
			cprintf("quantizing down to 256 colors\r\n");
		cinfo->desired_number_of_colors = 256;
		if (quantize){
			cinfo->two_pass_quantize = TRUE;
			cinfo->quantize_colors = TRUE;
			}
		else{
			cinfo->two_pass_quantize = FALSE;
			cinfo->quantize_colors = TRUE;
			}
		}


if (enable_pan)		/* need more storage for hi_color images */
	if (hi_color)
		raw_pic_ptr = (*cinfo->emethods->request_big_sarray)
			(cinfo->image_width * 2, cinfo->image_height, 1L);
	else
		raw_pic_ptr = (*cinfo->emethods->request_big_sarray)
			(cinfo->image_width, cinfo->image_height, 1L);
}



/*
 * Get the list of files matching the file spec and sort into the name array
 *   Return the number of files read in.
 */

void get_files(void)
{
int i, loc, done, count,
	bottom,			/* last directory in the list before file names */
	top;

static struct ffblk ffblk;
static char search_path[80];

for (i=0; i < number_files_max; i++){		/* clear files in list */
	files[i].name[0] = 0;
	files[i].date = 0;
	files[i].size = 0;
	}

count = 0;

strcpy(search_path, file_path);
strcat(search_path, "*.*");

done = findfirst(search_path, &ffblk, FA_DIREC);
while (!done){
	if (ffblk.ff_attrib & FA_DIREC){
		files[count].size = 0;				/* mark it as a directory */
		strcpy(files[count++].name, ffblk.ff_name);
		}
	done = findnext(&ffblk);
	}

bottom = count;

strcpy(search_path, file_path);
strcat(search_path, file_mask);
done = findfirst(search_path, &ffblk, FA_SYSTEM);
while (!done){
	/* insert ffblk.ff_name into list */
	/* first find the right place */
	for (top = bottom-1,loc = -1,i = bottom; i < number_files_max && files[i].name[0] != 0; i++){
		if (files[i].name[0] != 0) top = i;		/* find top of the list */
		switch (sort_mode){
			case FF_NAME:				/* case 0 sort by name - ascending */
				if (strcmp(files[i].name, ffblk.ff_name) >= 0 && loc == -1)
					loc = i;
				break;
			case FF_SIZE:				/* sort by file size - ascending - how?*/
				if (files[i].size >= ffblk.ff_fsize && loc == -1)
					loc = i;
				break;
			case FF_DATE:				/* sort by date - how? - store date?*/
				if (files[i].date >= ffblk.ff_fdate && loc == -1)
					loc = i;
				break;
			case NONE:
				break;
			}
		}
	/* now insert into the list */
	if (loc == -1){		/* bigger than everything so find top of the list */
		loc = top + 1;
		if (loc >= number_files_max) loc = number_files_max - 1;		/* make sure is < array size */
		}

	i = top + 1;
	while (i > loc){
		strcpy(files[i].name, files[i-1].name);
		files[i].date = files[i-1].date;
		files[i--].size = files[i-1].size;
		}
	count++;
	strcpy(files[loc].name, ffblk.ff_name);
	files[loc].size = ffblk.ff_fsize;
	files[loc].date = ffblk.ff_fdate;
	done = findnext(&ffblk);
	}

first_file = 0;			/* start by showing the first file */

number_files = count;

number_pages = number_files / 132;			/* max number of dense 6 col pages */
if (number_files % 132 > 0) number_pages++;
if (number_pages == 0)
	number_pages = 1;
per_page = number_files / number_pages;	/* now break that into how many per page */
if (number_files % number_pages > 0) per_page++;

num_cols = per_page / per_column;
if (per_page % per_column > 0) num_cols++;
if (num_cols == 0)
	num_cols = 1;

per_page = num_cols * per_column;		/* find the real # per page */
column_width = 78 / num_cols;
if (column_width > 26) column_width = 26;
}



int init_screen()		/* paint simple stuff if text screen is redrawn */
{
textmode (C80);
_setcursortype(_NOCURSOR);
clrscr();
gotoxy(1,1);
textcolor(WHITE);
cprintf("Select a file                      (F1 = help)                      DVPEG 2.0");
return 1;
}



/* put a window up in the center of the screen
	- ask about panning, video mode ....
	- don't worry what is under it because the image will be drawn */

void open_window(int width, int height)
{
char char_is;
struct text_info ti;
int i;

window(12, 4, 12 + width, 4 + height);
clrscr();

gettextinfo(&ti);				 /*  border */

textcolor(WHITE);
char_is = 219;			/* solid block */

for (i=1; i <= (ti.winright-ti.winleft); i++){		/* should go 1 count more */
	gotoxy(i, 1);
	putch(char_is);
	gotoxy(i, ti.winbottom - ti.wintop + 1);
	putch(char_is);
	}
for (i=2; i <= (ti.winbottom-ti.wintop); i++){
	gotoxy(1, i);
	putch(char_is);
	gotoxy(ti.winright - ti.winleft, i);		/* had to sub +1 */
	putch(char_is);
	}
window(14, 6, 10 + width, 2 + height);
}



void check_file_in(decompress_info_ptr cinfo)
{
int c;

  gif_picture = 0;
  if ((c = getc(cinfo->input_file)) == EOF)
	 ERREXIT(cinfo->emethods, "Empty input file");

  switch (c) {
#ifdef GIF_SUPPORTED
  case 'G':
	 jselrgif(cinfo);
	 gif_picture = 1;
	 break;
#endif
  default:			/* assume default is jpeg type picture */

#ifdef JFIF_SUPPORTED
  jselrjfif(cinfo);
#else
  You shoulda defined JFIF_SUPPORTED.   /* deliberate syntax error */
#endif
	 break;
  }

if (ungetc(c, cinfo->input_file) == EOF)
	 ERREXIT(cinfo->emethods, "ungetc failed");

}



/* do everything to show the file */

void show_it(decompress_info_ptr cinfo, char *file_name)
{
static char path_file_name[70];	/* path + name to file to view */
static struct decompress_methods_struct dc_methods;
static struct external_methods_struct e_methods;
int test_it,
	old_shrink;		/* place to save shrink if its a gif - ie no shrinking gifs yet*/


/* Initialize the system-dependent method pointers. */
cinfo->methods = &dc_methods;
cinfo->emethods = &e_methods;

/* Here we supply our own error handler; compare to use of standard error
 * handler in the previous write_JPEG_file example.
 */
emethods = &e_methods;	/* save struct addr for possible access */
e_methods.trace_level = 0;
e_methods.error_exit = error_exit; /* supply error-exit routine */
e_methods.trace_message = trace_message; /* supply trace-message routine */

jselmemmgr(&e_methods);	/* memory allocation routines */
dc_methods.d_ui_method_selection = d_ui_method_selection;

/* Now OK to enable signal catcher. */
#ifdef NEED_SIGNAL_CATCHER
	emethods = &e_methods;
	signal(SIGINT, signal_catcher);
	#ifdef SIGTERM			/* not all systems have SIGTERM */
		signal(SIGTERM, signal_catcher);
	#endif
#endif

/* Set up default JPEG parameters. */
j_d_defaults(cinfo, TRUE);

strcpy(path_file_name, file_path);
strcat(path_file_name, file_name);

if ((cinfo->input_file = fopen(path_file_name, READ_BINARY)) != NULL) {
	check_file_in(cinfo);
	gr_row = 0;				/* one shot stuff for pixel drawing routine */
	read_row = 0;
	col_cntr=1, row_cntr=1;
	test_it = setjmp(setjmp_buffer);
	if (test_it == 0)			/* hop to here if there was a tragic error */
		if (gif_picture){
			old_shrink = shrink;
			shrink = 1;
			read_gif(cinfo);
			shrink = old_shrink;
			}
		else
			jpeg_decompress(cinfo);
	gif_picture = 0;				/* reset to ensure we get the full menu */
	fclose(cinfo->input_file);
	}
}



/*
 * The main program.
 */

GLOBAL int
main (int argc, char **argv)
{
int x_pos, y_pos, old_selected_file, exit_prog, draw_all;
struct decompress_info_struct cinfo;
int c;
FILE *config_file;


clear_list();		/* clear the list of user selected video modes */

/* Select the input and output files */

cinfo.output_file = stdout;	/* always the output file */

/* setup path for viewing files to current drive, directory */
strcpy(file_path, "C:\\");
file_path[0] = getdisk() + 'A';
getcurdir(getdisk()+1, file_path + 3);
if (strlen(file_path) > 3) strcat(file_path, "\\");		/* only add if not in root */

/* does the dvpeg.cfg file exist? change .exe to .cfg and fetch from same dir as executable */
/* set up name for config file (dvpeg.cfg) and assume its in the same dir as vidsetup.exe */
strcpy(config_name, argv[0]);

/* knock off file and add dvpeg.cfg to path */
for (c=strlen(config_name); c >= 0 && config_name[c] != '\\'; c--);
config_name[c+1] = 0;		/* add dvpeg.cfg in load_config */

if ( !load_config() )
	if ( !config_video() )		/* do an autodetect */
		config_problem(1);		/* exit on error */


/* now setup the permenant list of modes as the user has chosen them --> ok_modes
 *  - the list in ok_mode[] is edited so that hi_color is used for JPEG and SVGA for GIF
 */

for (c = 0; c < number_modes_in_list; c++){
	all_modes[c].card_ID = ok_mode[c].card_ID;
	all_modes[c].which_mode = ok_mode[c].which_mode;
	}

if (argc == 2){		/* if a file is given on cmd line then view it */
	selected_file = view_defaults;		/* save it */
	view_defaults &= (~ask_size_bit);	/* turn off second menu */
	init_screen();
	gotoxy (1,4);
	cprintf("Getting the image\r\n");
	show_it(&cinfo, argv[1]);
	view_defaults = selected_file;		/* restore */
	}

/* if we have made it this far then setup the custom directory */
if (strlen(default_path) > 0){
	strcpy(file_path, default_path);
	strcat(file_path, "\\");
	}



  /* If the decompressor requires full-image buffers (for two-pass color
	* quantization or a noninterleaved JPEG file), it will create temporary
	* files for anything that doesn't fit within the maximum-memory setting.
	* You can change the default maximum-memory setting by changing
	* e_methods.max_memory_to_use after jselmemmgr returns.
	* On some systems you may also need to set up a signal handler to
	* ensure that temporary files are deleted if the program is interrupted.
	* (This is most important if you are on MS-DOS and use the jmemdos.c
	* memory manager back end; it will try to grab extended memory for
	* temp files, and that space will NOT be freed automatically.)
	* See jcmain.c or jdmain.c for an example signal handler.
	*/


/* ok put up the list of files and let the user pick one */

	exit_prog = 0;
	selected_file = 0;
	draw_all = init_screen();		/* signal whole screen redraw */
	get_files();

	do{
		if (draw_all){
			for (c=0; c < per_page && first_file + c < number_files; c++){			/* now print the names */
				if (c + first_file == selected_file) textcolor(YELLOW);
				else
					if (files[c + first_file].size == 0)
						textcolor(LIGHTBLUE);
					else
						textcolor(LIGHTGRAY);
				x_pos = column_width * (c / per_column) + 1;
				y_pos = ( c % per_column) + 3;
				gotoxy(x_pos, y_pos);
				cprintf("%.13s", &files[c + first_file].name);
				}
			draw_all = 0;
			}
		else		/* only redraw current line & old selection */
			{
			if (files[old_selected_file].size == 0)
				textcolor(LIGHTBLUE);
			else
				textcolor(LIGHTGRAY);
			x_pos = column_width * ((old_selected_file - first_file) / per_column) + 1;
			y_pos = ((old_selected_file - first_file) % per_column) + 3;
			gotoxy(x_pos, y_pos);
			cprintf("%.13s", &files[old_selected_file].name);

			textcolor(YELLOW);
			x_pos = column_width * ((selected_file - first_file) / per_column) + 1;
			y_pos = ((selected_file - first_file) % per_column) + 3;
			gotoxy(x_pos, y_pos);
			cprintf("%.13s", &files[selected_file].name);
			}
		old_selected_file = selected_file;
		switch (get_key()){
			case escape:
				exit_prog = 1;
				break;
			case RTN:
				if (files[selected_file].size == 0)		/* changing directory ?? */
					if (files[selected_file].name[0] == '.'){
						/* do nothing on a . but move up in tree on .. */
						if (files[selected_file].name[1] == '.'){
							for (c=strlen(file_path)-2; c >= 0 && file_path[c] != '\\'; c--);
							file_path[c+1] = 0;
							get_files();
							draw_all = init_screen();
							}
						}
					else{		/* its a directory down - add it to list */
						strcat(file_path, files[selected_file].name);
						strcat(file_path, "\\");
						get_files();
						draw_all = init_screen();
						}
				else
					{
					show_it(&cinfo, files[selected_file].name);
					textmode(C80);
					clrscr();			/* reset if wrong video mode is used */
					draw_all = init_screen();
					}
				break;
			case arrow_up:
				selected_file--;
				break;
			case arrow_down:
				selected_file++;
				break;
			case arrow_left:
				if (selected_file - per_column >= first_file)
					selected_file -= per_column;
				break;
			case arrow_right:			/* stop going off right edge */
				if (selected_file + per_column < first_file + per_page)
					selected_file += per_column;
				break;
			case page_up:
				selected_file -= per_page;
				break;
			case page_down:
				selected_file += per_page;
				break;
			case F1:
					open_window(40, 11);
					cprintf("up/down arrow - select a file\r\n");
					cprintf("enter - check out that picture\r\n");
					cprintf("F2 - change drive\r\n");
					cprintf("F3 - change defaults\r\n");
					cprintf("F4 - change mask for files\r\n");
					cprintf("F5 - change sorting criteria\r\n");
					cprintf("F6 - change file path");
					getch();
					draw_all = init_screen();
					break;
			case F2:		/* change directory and default to the current path on that drive */
				open_window(40,10);
				cprintf("Current drive is %c\r\n",file_path[0]);
				cprintf("What is the new drive?\r\n");
				c = toupper(getch());
				if (c < 'M' && c >= 'A'){
					strcpy(file_path, "C:\\");
					file_path[0] = c;
					getcurdir(c - 'A' + 1, file_path + 3);
					if (strlen(file_path) > 3)   /* watch out for root because its X:/ already */
						strcat(file_path, "\\");
					}
				get_files();
				draw_all = init_screen();
				break;
			case F3:		/* see if user wants to turn off next window */
				do{
					open_window(40,15);
					show_defaults(1);
					} while ( change_defaults(getch()) );

				draw_all = init_screen();
				break;
			case F4:				/* get the file mask */
				open_window(40,10);
				cprintf("File mask = %15s\r\n", file_mask);
				cprintf("What is the new file mask?\r\n");
				if (get_line(&config_name)){
					strcpy(file_mask, config_name);
					get_files();
					}
				draw_all = init_screen();
				break;
			case F5:				/* change the sort order */
				open_window(40,10);
				cprintf("Sort order is: ");
				switch (sort_mode){
					case NONE:
									cprintf("unsorted");
									break;
					case FF_NAME:
									cprintf("by name");
									break;
					case FF_SIZE:
									cprintf("by size");
									break;
					case FF_DATE:
									cprintf("by date");
									break;
					}
				cprintf("\r\nchoose: Unsorted, Name, Size, Date\r\n");
				c = getch();
				switch (c){
					case 'N':
					case 'n':   sort_mode = FF_NAME;
									break;
					case 'U':
					case 'u':
									sort_mode = NONE;
									break;
					case 'S':
					case 's':
									sort_mode = FF_SIZE;
									break;
					case 'D':
					case 'd':
									sort_mode = FF_DATE;
									break;
					}
				get_files();
				draw_all = init_screen();
				break;
			case F6:
				open_window(50, 10);
				cprintf("The file path is: %25s\r\n\n", file_path);
				cprintf("What is the new path (ie d:\\gifs)?\r\n");
				if (get_line(&config_name)){
					strcpy(file_path, config_name);
					strcat(file_path, "\\");
					get_files();
					}
				draw_all = init_screen();
				break;
			}
		if (selected_file < 0) selected_file = 0;
		if (selected_file >= number_files) selected_file = number_files - 1;

		if (selected_file >= first_file + per_page){	/* went off bottom of page */
			first_file += per_page;
			if (first_file >= number_files - per_page)
				first_file = number_files - per_page;
			draw_all = init_screen();
			}
		if (selected_file < first_file){		/* went off top of screen */
			first_file -= per_page;
			if (first_file < 0)
				first_file = 0;
			draw_all = init_screen();
			}
	}while (!exit_prog);

txtmode();
_setcursortype(_NORMALCURSOR);

printf("Thanks to IJG and all my net.helpers\r\n");
printf("%s\r\n%s\r\n",JVERSION, JCOPYRIGHT);
return 1;			/* indicate success */
}
