/*       These are various definations which are common to the viewing program
		(jvmain.c) and the video setup program (jvsetup.c).


*/

extern   unsigned char cirrus, everex, paradise, tseng, trident;
extern   unsigned char t8900, ativga, aheada, aheadb;
extern   unsigned char oaktech, video7, chipstech, tseng4, genoa;
extern   unsigned char ncr, compaq, vesa;
extern	int hi_color;      /* signals existance of hi color card */
extern   unsigned char vga512, vga1024;
extern   int maxx, maxy;


enum sorting_names{     /* enum for sorting modes */
	NONE,
	FF_NAME,
	FF_DATE,
	FF_SIZE
	};

enum bit_locs{				/* masks for bits in word describing setup flags */
	grey_bit = 1,
	dithering_bit = 2,
	smoothing_bit = 4,
	quantize_bit = 8,
	panning_bit = 16,		/* disable panning completely ? */
	ask_size_bit = 32,	/* show screen with defaults or pass it ?? */
	beep = 64,
	only_hi_color = 128	/* flag to disable SVGA modes if hi_color is available for a jpeg */
	};

#ifndef arrow_left
#define  number_VGA_cards 20        /* the number of VGA cards supported */
#define	start_hi_color 17				/* the first number of the high_color cards ie the last 2 */
#define  last_card 19               /* number of VGA cards -1 : for simplifying code */
#define  number_modes_supported 6   /* the max number of video modes for each card */
#define  number_modes_in_list 10    /* the max number of modes in the user selected list */
#define  number_files_max 528       /* maximum number of files to be stored for selection
														ie 4 screens * 22 rows * 6 columns*/
#define	per_column 22					/* the number of files per column on text screen */


/*    definations for reading keyboard */

#define arrow_left 0x4b00
#define arrow_right 0x4d00
#define arrow_up 0x4800
#define arrow_down 0x5000
#define page_up 0x4900
#define page_down 0x5100
#define escape 27
#define home 0x4700
#define end 0x4f00
#define RTN 13
#define insert 0x5200
#define delete 0x5300
#define plus 43
#define minus 45
#define F1 0x3B00
#define F2 0x3C00
#define F3 0x3D00
#define F4 0x3E00
#define F5 0x3F00
#define F6 0x4000

struct mode {
	int x_size;
	int y_size;
	int mode_number;};


/* for this struct.  All items should be in ascending order with 0x00 for the unused mode #'s */
/* custom is for typed in modes.  The actual card # is (ok_mode[].card_ID >> 8 ) % 0x00ff where *.card_ID & 0xff is 18 (ie ptr to custom) */

struct video_card {
	char name[20];
	struct mode vid_mode[number_modes_supported];
	} video_cards[number_VGA_cards] =
	{ {"ahead A", {{320, 200, 0x13}, {640, 400, 0x60}, {640, 480, 0x61}, {800, 600, 0x62}, {0000, 000, 0x00}, {0, 0, 0x0}}},
	  {"ahead B", {{320, 200, 0x13}, {640, 400, 0x60}, {640, 480, 0x61}, {800, 600, 0x62}, {0000, 000, 0x00}, {0, 0, 0x0}}},
	  {"ati", {{320, 200, 0x13}, {640, 400, 0x61}, {640, 480, 0x62}, {800, 600, 0x63}, {1024, 768, 0x64}, {0, 0, 0x0}}},
	  {"chips & tech", {{320, 200, 0x13}, {640, 400, 0x78}, {640, 480, 0x79}, {800, 600, 0x7b}, {0, 0, 0x0}, {0, 0, 0x0}}},
	  {"everex", {{320, 200, 0x13}, {640, 400, 0x14}, {512, 480, 0x15}, {640, 480, 0x30}, {800, 600, 0x31}, {0, 0, 0x0}}},
	  {"oak-tek", {{320, 200, 0x13}, {640, 480, 0x53}, {800, 600, 0x54}, {0, 0, 0x0}, {0, 0, 0x0}, {0, 0, 0x0}}},
	  {"genoa", {{320, 200, 0x13}, {640, 400, 0x7e}, {640, 480, 0x5c}, {720, 512, 0x5d}, {800, 600, 0x5e}, {0, 0, 0x0}}},
	  {"NCR", {{320, 200, 0x13}, {640, 400, 0x5e}, {640, 480, 0x5f}, {800, 600, 0x5c}, {0, 0, 0x0}, {0, 0, 0x0}}},
	  {"paradise", {{320, 200, 0x13}, {640, 400, 0x5e}, {640, 480, 0x5f}, {0, 0, 0x0}, {0, 0, 0x0}, {0, 0, 0x0}}},
	  {"trident", {{320, 200, 0x13}, {640, 400, 0x5c}, {640, 480, 0x5d}, {800, 600, 0x5e}, {0, 0, 0x00}, {0, 0, 0x0}}},
	  {"trident 8900", {{320, 200, 0x13}, {640, 400, 0x5c}, {640, 480, 0x5d}, {800, 600, 0x5e}, {1024, 768, 0x62}, {0, 0, 0x0}}},
	  {"tseng", {{320, 200, 0x13}, {640, 350, 0x2d}, {640, 480, 0x2e}, {800, 600, 0x30}, {1024, 768, 0x38}, {0, 0, 0x0}}},
	  {"tseng 4000", {{320, 200, 0x13}, {640, 350, 0x2d}, {640, 400, 0x2f}, {640, 480, 0x2e}, {800, 600, 0x30}, {1024, 768, 0x38}}},
	  {"video 7", {{320, 200, 0x13}, {640, 400, 0x66}, {640, 480, 0x67}, {800, 600, 0x69}, {1024, 768, 0x6a}, {0, 0, 0x0}}},
	  {"cirrus", {{320, 200, 0x13}, {640, 480, 0x2e}, {0, 0, 0x0}, {0, 0, 0x0}, {0, 0, 0x0}, { 0, 0, 0x0}}},
	  {"compaq", {{320, 200, 0x13}, {640, 480, 0x2e}, {0, 0, 0x0}, {0, 0, 0x0}, {0, 0, 0x0}, { 0, 0, 0x0}}},
	  {"vesa", {{320, 200, 0x13}, {640, 400, 0x100}, {640, 480, 0x101}, {800, 600, 0x103}, {1024, 768, 0x106}, {1280, 1024, 0x107}}},
	  {"ATI, hi color", {{1280, 480, 0x72}, {1600, 600, 0x73}, {0, 0, 0x0}, {0, 0, 0x0}, {0, 0, 0x0}, {0, 0, 0x0}}},
	  {"Tseng, hi color", {{640, 350, 0x2d}, {640, 400, 0x2f}, {640, 480, 0x2e}, {800, 600, 0x30}, {0, 0, 0x0}, {0, 0, 0x0}}},
	  {"Custom", {{0, 0, 0x0}, {0, 0, 0x0}, {0, 0, 0x0}, {0, 0, 0x0}, {0, 0, 0x0}, {0, 0, 0x0}}}
	};

/* now the list of working modes as selected by the user - 10 maximum */
/* one extra item at end (always 0) to simplify deletion */
struct {
	int   card_ID;
	int   which_mode;
	} ok_mode[number_modes_in_list+1],		/* used by drawing routines etc - mode listed as edited for gif, jpeg*/
		 all_modes[number_modes_in_list+1];		/* the total list of modes as read in */
#endif

