
	include	model.h

;
;	VGAKIT Version 4.1
;
;	Copyright 1988,89,90,91 John Bridges
;	Free for use in commercial, shareware or freeware applications
;
;	POINT.ASM
;	removed point13, range checking (Eric P)
;
;
.data

	extrn gr_col:word
	extrn gr_row:word
	extrn color_out:word
	extrn	curbk:word
	extrn	maxx:word,maxy:word,xwidth:word

.code

	extrn	newbank:proc

	public	point_spec  ; special point drawing with reg passing
	public	point
	public	point_wide	; write a word to video memory
	public	point_hi		; hi color Tseng 4000 support
	public	hi_bright	; bright the hi_color screen
	public	rdpoint		; read a point on the screen


point_hi	proc	xpos:word,ypos:word,color:word
	mov	bx,[xpos]
	mov	ax,[ypos]		; removed all range checking on x,y for speed
	mul	[xwidth]			;640 bytes wide in most cases
	add	bx,ax
	adc	dx,0
	mov	ax, dx			; what a $#%%# stupid microprocessor
	shl	ax, 1
	shl	bx, 1
	adc	ax, 0
; don't bother with current bank check since this looks faster

	mov	dx, 03cdh
	out	dx, ax
	mov	dx,0a000h		;setup screen segment A000
	mov	es,dx
	mov	ax, [color]		;get color of pixel to plot
	mov	es:[bx], ax
	ret
point_hi	endp


point_spec	proc
mov ax, [gr_row]
mov bx, [gr_col]
mov cx, [color_out]
	mul	[xwidth]			;X size bytes wide in most cases
	add	bx, ax
	adc	dx,0
	mov	ax,dx
	cmp	ax,[curbk]
	jz	noneww
	call	newbank			;switch banks if a new bank entered
noneww:	mov	ax,0a000h		;setup screen segment A000
	mov	es,ax
	mov	es:[bx],cl
	ret
point_spec	endp



point	proc	xpos:word,ypos:word,color:word
	mov	bx,[xpos]
	mov	ax,[ypos]
;	mov	dx,[maxx]
;	cmp	bx,0			; range checking not necessary since it will
;	jl	nope2				;  always be within one 64k bank
;	cmp	bx,dx
;	jge	nope2
;	cmp	ax,0
;	jl	nope2
;	cmp	ax,[maxy]
;	jge	nope2
	mul	[xwidth]			;X size bytes wide in most cases
	add	bx, ax
	adc	dx,0
	mov	ax,dx
	cmp	ax,[curbk]
	jz	nonew
	call	newbank			;switch banks if a new bank entered
nonew:	mov	ax,0a000h		;setup screen segment A000
	mov	es,ax
	mov	cl,byte ptr [color]	;get color of pixel to plot
	mov	es:[bx],cl
nope2:	ret
point	endp



;/* print a word wide point into video memory */

point_wide	proc	xpos:word,ypos:word,color:word
	mov	bx,[xpos]
	mov	ax,[ypos]
	mul	[xwidth]			;X size bytes wide in most cases
	add	bx, ax
	adc	dx,0
	mov	ax,dx
	cmp	ax,[curbk]
	jz	nonewo
	call	newbank			;switch banks if a new bank entered
nonewo:	mov	ax,0a000h		;setup screen segment A000
	mov	es,ax
	mov	cx, [color]	;get color of pixel to plot
	mov	es:[bx],cx
	ret
point_wide	endp



;
;	VGAKIT Version 4.1
;
;	Copyright 1988,89,90,91 John Bridges
;	Free for use in commercial, shareware or freeware applications
;
;	RDPOINT.ASM
;
;modified by Eric P to do a brighten on hi_color cards

; vid_type is the video type, 0 = Tseng, 1 = ATI

hi_bright	proc	uses si di, vid_type:word, amount:word
; set up x loop (di??)
	mov si, [maxy]
; set up y loop (cx?)
next_line:
	mov di, [maxx]
next_pixel:
	mov	ax,[xwidth]		;640 bytes wide in most cases
	mul	[ypos]
	add	ax,[xpos]
	adc	dx,0
	mov	bx,ax
	mov	ax,dx
	cmp	ax,[curbk]
	jz		notnew
	call	newbank			;switch banks if a new bank entered
notnew:
	mov	ax,0a000h		;setup screen segment A000
	mov	es,ax
	mov	ax,es:[bx]
; component is in al

; read the colors, & add 1 to each component
	add   ax, 0000010000100001b
; check each for overflow

; and save it
	mov	es:[bx], ax

	dec di
	jnz next_pixel
	dec si
	jns next_line
	ret
hi_bright	endp



rdpoint	proc	xpos:word,ypos:word
	mov	ax,[xwidth]		;640 bytes wide in most cases
	mul	[ypos]
	add	ax,[xpos]
	adc	dx,0
	mov	bx,ax
	mov	ax,dx
	cmp	ax,[curbk]
	jz		no2new
	call	newbank			;switch banks if a new bank entered
no2new:	mov	ax,0a000h		;setup screen segment A000
	mov	es,ax
	mov	al,es:[bx]
	mov	ah,0
	ret
rdpoint	endp

	end


