
	include model.h

;
;	VGAKIT Version 4.1
;
;	Copyright 1988,89,90,91 John Bridges
;	Free for use in commercial, shareware or freeware applications
;
;	SVGAMODE.ASM
;
;
.data
	extrn	cirrus:byte,everex:byte,paradise:byte,tseng:byte,trident:byte
	extrn	t8900:byte,ativga:byte,aheada:byte,aheadb:byte
	extrn	oaktech:byte,video7:byte,chipstech:byte,tseng4:byte,genoa:byte
	extrn	ncr:byte,compaq:byte,vesa:byte
	extrn	vga512:byte,vga1024:byte,hi_color:byte

	extrn	curbk:word

	public	maxx,maxy,xwidth

maxx	dw	?		;xwidth of screen in pixels
maxy	dw	?		;height of screen in pixels
xwidth	dw	?		;actual xwidth of screen in bytes

.code

	public	svgamode
	public	txtmode
	public	setmany

svgamode proc vid_mode:word, max_x:word		;Set 640x480x256 on most SVGA cards
	mov ax, [vid_mode]
	cmp	[vesa],0			; override for vesa since its special
	jz	notvesa
	mov	ax,4f02h
	mov	bx,101h
	jmp	setupmode
notvesa:
	cmp [video7], 0		; special case for these cards
	jz notvid7
	mov bl,67h
	jmp setupmode
notvid7:
	cmp	[tseng4], 0		; test for tseng 4000
	jz		try_everex
	cmp	[hi_color], 0	; test for hi color & tseng 4000
	jz		try_everex
	mov   bx, [vid_mode]
	mov	ax, 10f0h
	jmp	setupmode
try_everex:
	cmp [everex], 0		; another special
	jz setupmode
	mov bl, 30h

setupmode:
	int	10h

	mov	[curbk],-1
	mov	ax, [max_x]
	mov	[maxx],ax		;default xwidth to whatever for now
	cmp	[compaq],0
	jz	nokludge
	mov	ax,1024
nokludge:
	mov	[xwidth],ax
	mov	ax,40h
	mov	es,ax
	mov	al,es:[84h]		;get height of screen
	inc	al
	mul	byte ptr es:[85h]
	mov	[maxy],ax

nots:	ret
svgamode endp

txtmode	proc
	mov	ax,3
	int	10h
	ret
txtmode	endp

setmany proc	palbuf:ptr byte,begcol:word,numcol:word
if @Datasize
	les	dx,[palbuf]
else
	mov	ax,ds
	mov	es,ax
	mov	dx,[palbuf]
endif
	mov	bx,[begcol]
	mov	cx,[numcol]
	mov	ax,1012h
	int	10h
	ret
setmany endp

	end

