/* Direct Video Write Routines called from C
   Just an example

   Used in SNOW for fast screen writes

   JEff Bowermaster
   Splat! Graphics
   1992

   TurboC 2.0

   Heavily Borrowed from Ferraro's 
   Programmers Guide to EGA and VGA cards


*/


#include <graphics.h>
#include <math.h>
#include <conio.h>
#include <stdlib.h>
#include <time.h>

#define 	boxes	120

char	Old[19200],
		New[19200];


void DefineScreen();
void Random_Blocks();
void Set_the_palette();

extern void	Paint(int,int,int); /* define the routine external */

void main(){

	DefineScreen();     /* set up a standard BGI VGA screen */
   Set_the_palette();  /* some decent colors please */ 
	Random_Blocks();    /* Draw Some Random Blocks          */
	while(!kbhit());    /* pause */
	closegraph();       /* bye */
}

void DefineScreen()
{
	int g_driver=9, g_mode=2, d;     /*     VGA 640 x 480, 16 color */
	if(registerbgidriver(EGAVGA_driver) < 0) exit(1);
	detectgraph(&g_driver,&g_mode);
	initgraph(&g_driver,&g_mode,"");     /* Set up screen size */
}

void Set_the_palette()
{
	int i,j,Col[16][3]=
	{ {  5,  5,  5 },
	  { 32,  0,  0 },
	  { 42,  0,  0 },
	  { 58, 16,  0 },
	  { 63, 32,  0 },
	  { 58, 56,  0 },
	  { 16, 42,  0 },
	  {  0, 30, 36 },
	  {  0, 20, 40 },
	  {  0, 10, 48 },
	  {  0,  0, 63 },
	  { 20,  0, 53 },
	  { 23,  0, 29 },
	  { 19,  7, 17 },
	  { 50, 40, 45 },
	  { 60, 60, 60 } };

	for (i=0; i<16; i++){
		setpalette(i,i);
		setrgbpalette(i,Col[i][0],Col[i][1],Col[i][2]);
	}
}

void Random_Blocks()
{
 int 	x,
		y,
		g,
		color,
		colors=16,
		blocks=0,
		three=0;

	randomize();
	for(x=0;x<boxes;x++){
		for(y=0;y<boxes;y++){
			color=(random(colors));
			Paint(color,blocks,three);
			*(Old+blocks)=color;
			*(New+blocks)=color;
			blocks++;
		}
		blocks+=40;
		three+=240;
	}
}

