Prefix  macro
        push    bp
        mov     bp,sp
        push    ds
        push    es
        push    si
        push    di
        endm

Postfix macro
        pop     di
        pop     si
        pop     es
        pop     ds
        mov     sp,bp
        pop     bp
        ret
        endm
DOSSEG
.MODEL  small
.CODE
PUBLIC  _Paint

_Paint   proc    far

        Prefix

        mov     dx,03CEh        ; Graphics Control register

; ===== Odd or Even Line ? =====

        clc
        rcr     word ptr [bp+8],1
        jc      Odd

; ===== Mask off left pixels ---

;Even:                                
        mov     ax,0F008h       ; Select the Bit Mask Register  
        out     dx,ax           ; Right Pixels '11110000'

        jmp     Plane

; ===== Mask off right pixels ---

Odd:                                
        mov     ax,00F08h       ; Select the Bit Mask Register  
        out     dx,ax           ; Left Pixels '00001111'


; ===== VGA memory begins at A0000h 

Plane:  mov     ax,0A000h       ; Start of VGA Memory        
        mov     ds,ax           ; in DS:SI

; ===== Convert Block into address 

        mov     ax,[bp+8]       ; Block/2 from rotate command
        add     ax,[bp+10]      ; Index; move down 3 lines
        mov     si,ax

; ===== Voodoo programming - Must read a byte to correct problems

        mov     ax,4
        out     dx,ax
        mov     al,ds:si        ;Read Plane 0

; ===== Set/Reset Registers to Correct color 

        mov     ax,0F01h        ; Enable Set/Reset Register
        out     dx,ax
 
        mov     al,0            ; The Set/Reset Register
        mov     ah,[bp+6]       ; Set the color 
        out     dx,ax

; ===== Draw a solid line 4 times ===

        mov     cx,4            ; 4 lines
line1:  mov     ds:si,al        ; Write anything to the display
        add     si,80           ; Go down 1 line 
        loop    line1

        Postfix

_Paint  endp

END

