#include <dos.h>
#include <string.h>
#include <conio.h>

typedef unsigned int  word;
typedef unsigned char byte;

#include "font6x6s.h"

/* informations about active font */
char *fontptr = font6x6s; // pointer to active font
byte width = 6;				// width of char
byte height = 6;			// height of char
byte widthb = 1;			// width in bytes
byte shifts = 1;			// in font are used shifts
byte startchar = 0;		// first char from font
byte endchar = 127;		// last char from font
word firstshift = (((endchar-startchar)+1)*height*widthb);
//   ^^^ offset of first shift in font

#define videoofs(x, y) ((y * 320) + x)
#define videoseg 0xA000
#define putpixel(x, y, color) pokeb(videoseg, videoofs((x), (y)), color)

void putch(word x, word y, char ch, byte col1 = 15, byte col2 = 0)
{
	byte a, b, w = shifts ? fontptr[firstshift + ch] : width;
	byte bit[8] = { 128, 64, 32, 16, 8, 4, 2, 1 };

	for (a = 0; a < height; a++)
		for (b = 0; b < w; b++)
			if ((fontptr[(ch*height*widthb) + (a*widthb) + (b > 7 ? 1 : 0)] & bit[b > 7 ? b - 8 : b]))
				putpixel(x + b, y + a, col1);
			else
				if (col2 != 255)
					putpixel(x + b, y + a, col2);
}

void printat(word x, word y, char *text, byte col1 = 15, byte col2 = 0)
{
	word a, xx = x, yy = y;
	for (a = 0; a < strlen(text); a++)
		switch (text[a]) {
			case 10	:	yy += height;
								xx = x;
								break;
			default:	putch(xx, yy, text[a] - startchar, col1, col2);
								xx += shifts ? fontptr[firstshift + (text[a]-startchar)] : width;
								break;
		};
}

void main()
{
	asm mov ax, 0013h   // int vga (13h) mode
	asm int 10h
	printat(1, 1, "Hello world!", 1, 0);
	printat(0, 0, "Hello world!", 4, 255);
// if color of background is 255 then background of text won't be printed
	getch();
	asm mov ax, 0003h
	asm int 10h
}