#include <conio.h>
#include <dos.h>
#include <memory.h>
#include <stdio.h>
#include <stdlib.h>
#include <pc.h>

#include "gfxmisc.h"

long *cosTab;
long *sinTab;
long *scaleTab;
long *yTab;
long startingPointU[256];
long startingPointV[256];

void
gfxSetMode(int mode)
{
	union REGS r;

	r.x.ax = mode;

	int86(0x10, &r, &r);
}


void
gfxExtendMode(void)
{
	outportb(0x3C2, 0xE3);
}


void
gfxSetPalette(unsigned char *palette)
{
	int i;

	outportb(0x03c8, 0);

	i = 256;
	while (i--) {
		outportb(0x03c9, *palette++);
		outportb(0x03c9, *palette++);
		outportb(0x03c9, *palette++);
	}
}


char *
gfxLoadPCX(char *pcxFName, char *image)
{
	FILE *fp;
	int size, i;
	unsigned char PCX_byte, RLE_byte;
	unsigned char *buf_ptr;
	unsigned char *end_of_buf;
	unsigned char palette[768];

	fp = fopen(pcxFName, "rb");

	if (fp == NULL) {
		return NULL;
	} else {
		fseek(fp, 8, SEEK_SET);
		size = 64000;

		image = (char *) malloc(size);
		buf_ptr = image;
		end_of_buf = buf_ptr + size;

		fseek(fp, -768, SEEK_END);
		fread(palette, 1, 768, fp);
		for (i=0; i < 768; i++) {
			palette[i] = palette[i] >> 2;
		}

		fseek(fp, 128, SEEK_SET);

		while (buf_ptr < end_of_buf) {
			fread(&PCX_byte, 1, 1, fp);

			if (PCX_byte < 192) {
				*buf_ptr++ = PCX_byte;
			} else {
				PCX_byte = PCX_byte & 0x3F;
				fread(&RLE_byte, 1, 1, fp);
				memset(buf_ptr, RLE_byte, PCX_byte);
				buf_ptr += PCX_byte;
			}
		}

		fclose(fp);

		gfxSetPalette(palette);

		return image;
	}

}


void
gfxInitTables(void)
{
	FILE *fp;
	int i;
	unsigned long dU, dV;

	sinTab = (long *) malloc(256 * 4);
	cosTab = (long *) malloc(256 * 4);
	scaleTab = (long *) malloc(128 * 4);
	yTab	 = (long *) malloc(200 * 4);

	fp = fopen("sintab.dat", "rb");
	fread(sinTab, 4, 256, fp);
	fread(cosTab, 4, 256, fp);
	fclose(fp);

	for (i=0; i < 200; i++) {
		yTab[i] = i * 320;
	}

	for (i=0; i < 128; i++) {
		scaleTab[i] = (i << 4);
	}

	for (i=0; i<255; i++) {
		dU = sinTab[i];
		dV = cosTab[i];
		startingPointU[i] = ((-160 * dV) + (100 * dU)) + (160 << 10);
		startingPointV[i] = ((-160 * dU) - (100 * dV)) + (100 << 10);
	}
}


void
gfxCleanup(void)
{
	free(sinTab);
	free(cosTab);
	free(scaleTab);
	free(yTab);
}

